/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value;

import org.eclipse.jpt.common.utility.internal.model.value.AbstractPropertyValueModel;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyValueModelWrapper<V>
extends AbstractPropertyValueModel {
    protected final PropertyValueModel<? extends V> valueHolder;
    protected final PropertyChangeListener valueChangeListener;

    protected PropertyValueModelWrapper(PropertyValueModel<? extends V> valueHolder) {
        if (valueHolder == null) {
            throw new NullPointerException();
        }
        this.valueHolder = valueHolder;
        this.valueChangeListener = this.buildValueChangeListener();
    }

    protected PropertyChangeListener buildValueChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                PropertyValueModelWrapper.this.valueChanged(event);
            }

            public String toString() {
                return "value change listener";
            }
        };
    }

    @Override
    protected void engageModel() {
        this.valueHolder.addPropertyChangeListener("value", this.valueChangeListener);
    }

    @Override
    protected void disengageModel() {
        this.valueHolder.removePropertyChangeListener("value", this.valueChangeListener);
    }

    protected abstract void valueChanged(PropertyChangeEvent var1);
}

