/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.synchronizers;

import java.util.concurrent.ThreadFactory;
import org.eclipse.jpt.common.utility.Command;
import org.eclipse.jpt.common.utility.internal.ConsumerThreadCoordinator;
import org.eclipse.jpt.common.utility.internal.SynchronizedBoolean;
import org.eclipse.jpt.common.utility.synchronizers.Synchronizer;

public class AsynchronousSynchronizer
implements Synchronizer {
    final SynchronizedBoolean synchronizeFlag = new SynchronizedBoolean(false);
    private final ConsumerThreadCoordinator consumerThreadCoordinator;

    public AsynchronousSynchronizer(Command command) {
        this(command, null, null);
    }

    public AsynchronousSynchronizer(Command command, ThreadFactory threadFactory) {
        this(command, threadFactory, null);
    }

    public AsynchronousSynchronizer(Command command, String threadName) {
        this(command, null, threadName);
    }

    public AsynchronousSynchronizer(Command command, ThreadFactory threadFactory, String threadName) {
        if (command == null) {
            throw new NullPointerException();
        }
        this.consumerThreadCoordinator = new ConsumerThreadCoordinator(this.buildConsumer(command), threadFactory, threadName);
    }

    ConsumerThreadCoordinator.Consumer buildConsumer(Command command) {
        return new Consumer(command);
    }

    public void start() {
        this.consumerThreadCoordinator.start();
    }

    public void synchronize() {
        this.synchronizeFlag.setTrue();
    }

    public void stop() {
        this.consumerThreadCoordinator.stop();
    }

    class Consumer
    implements ConsumerThreadCoordinator.Consumer {
        private final Command command;

        Consumer(Command command) {
            this.command = command;
        }

        public void waitForProducer() throws InterruptedException {
            AsynchronousSynchronizer.this.synchronizeFlag.waitToSetFalse();
        }

        public void execute() {
            this.command.execute();
        }
    }
}

