/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.context.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkMutable;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.java.JavaEclipseLinkPersistentAttribute;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkMutableAnnotation;

public class JavaEclipseLinkMutable
extends AbstractJavaJpaContextNode
implements EclipseLinkMutable {
    protected Boolean specifiedMutable = this.buildSpecifiedMutable();
    protected boolean defaultMutable;

    public JavaEclipseLinkMutable(JavaAttributeMapping parent) {
        super((JpaContextNode)parent);
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedMutable_(this.buildSpecifiedMutable());
    }

    public void update() {
        super.update();
        this.setDefaultMutable(this.buildDefaultMutable());
    }

    public boolean isMutable() {
        return this.specifiedMutable != null ? this.specifiedMutable : this.defaultMutable;
    }

    public Boolean getSpecifiedMutable() {
        return this.specifiedMutable;
    }

    public void setSpecifiedMutable(Boolean mutable) {
        if (this.valuesAreDifferent(mutable, this.specifiedMutable)) {
            EclipseLinkMutableAnnotation annotation = this.getMutableAnnotation();
            if (mutable == null) {
                if (annotation != null) {
                    this.removeMutableAnnotation();
                }
            } else {
                Boolean annotationValue;
                boolean annotationBooleanValue;
                if (annotation == null) {
                    annotation = this.addMutableAnnotation();
                }
                boolean bl = annotationBooleanValue = (annotationValue = annotation.getValue()) == null ? true : annotationValue;
                if (annotationBooleanValue != mutable) {
                    annotation.setValue(mutable);
                }
            }
            this.setSpecifiedMutable_(mutable);
        }
    }

    protected void setSpecifiedMutable_(Boolean mutable) {
        Boolean old = this.specifiedMutable;
        this.specifiedMutable = mutable;
        this.firePropertyChanged("specifiedMutable", old, mutable);
    }

    protected Boolean buildSpecifiedMutable() {
        EclipseLinkMutableAnnotation annotation = this.getMutableAnnotation();
        if (annotation == null) {
            return null;
        }
        Boolean annotationValue = annotation.getValue();
        return annotationValue == null ? Boolean.TRUE : annotationValue;
    }

    public boolean isDefaultMutable() {
        return this.defaultMutable;
    }

    protected void setDefaultMutable(boolean mutable) {
        boolean old = this.defaultMutable;
        this.defaultMutable = mutable;
        this.firePropertyChanged("defaultMutable", old, mutable);
    }

    protected boolean buildDefaultMutable() {
        JavaEclipseLinkPersistentAttribute javaAttribute = this.getPersistentAttribute();
        if (javaAttribute.typeIsDateOrCalendar()) {
            Boolean puTemporalMutable = this.getPersistenceUnit().getOptions().getTemporalMutable();
            return puTemporalMutable == null ? false : puTemporalMutable;
        }
        return javaAttribute.typeIsSerializable();
    }

    protected EclipseLinkMutableAnnotation getMutableAnnotation() {
        return (EclipseLinkMutableAnnotation)this.getResourcePersistentAttribute().getAnnotation(this.getMutableAnnotationName());
    }

    protected EclipseLinkMutableAnnotation addMutableAnnotation() {
        return (EclipseLinkMutableAnnotation)this.getResourcePersistentAttribute().addAnnotation(this.getMutableAnnotationName());
    }

    protected void removeMutableAnnotation() {
        this.getResourcePersistentAttribute().removeAnnotation(this.getMutableAnnotationName());
    }

    protected String getMutableAnnotationName() {
        return "org.eclipse.persistence.annotations.Mutable";
    }

    public JavaAttributeMapping getParent() {
        return (JavaAttributeMapping)super.getParent();
    }

    protected JavaAttributeMapping getAttributeMapping() {
        return this.getParent();
    }

    protected JavaResourcePersistentAttribute getResourcePersistentAttribute() {
        return this.getAttributeMapping().getResourcePersistentAttribute();
    }

    protected JavaEclipseLinkPersistentAttribute getPersistentAttribute() {
        return (JavaEclipseLinkPersistentAttribute)this.getAttributeMapping().getPersistentAttribute();
    }

    public EclipseLinkPersistenceUnit getPersistenceUnit() {
        return (EclipseLinkPersistenceUnit)super.getPersistenceUnit();
    }

    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.getAnnotationTextRange(astRoot);
        return textRange != null ? textRange : this.getAttributeMapping().getValidationTextRange(astRoot);
    }

    protected TextRange getAnnotationTextRange(CompilationUnit astRoot) {
        EclipseLinkMutableAnnotation annotation = this.getMutableAnnotation();
        return annotation == null ? null : annotation.getTextRange(astRoot);
    }
}

