/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.feature;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IDirectEditingContext;
import org.eclipse.graphiti.features.impl.AbstractDirectEditingFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.i18n.JPAEditorMessages;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.BidirectionalRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.IRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;

public class DirectEditAttributeFeature
extends AbstractDirectEditingFeature {
    private boolean isMethodAnnotated = false;

    public DirectEditAttributeFeature(IFeatureProvider fp) {
        super(fp);
    }

    public int getEditingType() {
        return 1;
    }

    public boolean canDirectEdit(IDirectEditingContext context) {
        return true;
    }

    public String getInitialValue(IDirectEditingContext context) {
        PictogramElement pe = context.getPictogramElement();
        JavaPersistentAttribute jpa = (JavaPersistentAttribute)this.getFeatureProvider().getBusinessObjectForPictogramElement(pe);
        this.isMethodAnnotated = JpaArtifactFactory.instance().isMethodAnnotated(jpa);
        Text txt = (Text)pe.getGraphicsAlgorithm().getGraphicsAlgorithmChildren().get(0);
        String value = txt.getValue();
        if (this.isMethodAnnotated) {
            value = JPAEditorUtil.produceValidAttributeName(value);
        }
        return value;
    }

    public String checkValueValid(String value, IDirectEditingContext context) {
        IStatus status;
        if (this.isMethodAnnotated) {
            value = JPAEditorUtil.produceValidAttributeName(value);
        }
        if (!(status = JavaConventions.validateFieldName((String)value, (String)"1.5", (String)"1.5")).isOK()) {
            return status.getMessage();
        }
        status = this.checkDuplicateAttribute(value, context);
        if (!status.isOK()) {
            return status.getMessage();
        }
        return null;
    }

    private IStatus checkDuplicateAttribute(String value, IDirectEditingContext context) {
        PictogramElement pe = context.getPictogramElement();
        JavaPersistentAttribute oldAt = (JavaPersistentAttribute)this.getBusinessObjectForPictogramElement(pe);
        JavaPersistentAttribute newAl = ((JavaPersistentType)oldAt.getParent()).getAttributeNamed(value);
        if (newAl != null && !newAl.equals(oldAt)) {
            String message = MessageFormat.format(JPAEditorMessages.DirectEditAttributeFeature_attributeExists, value);
            return new Status(4, "org.eclipse.jpt.jpadiagrameditor.ui", message);
        }
        return Status.OK_STATUS;
    }

    public IJPAEditorFeatureProvider getFeatureProvider() {
        return (IJPAEditorFeatureProvider)super.getFeatureProvider();
    }

    public void setValue(String value, IDirectEditingContext context) {
        if (this.isMethodAnnotated) {
            value = JPAEditorUtil.produceValidAttributeName(value);
        }
        PictogramElement pe = context.getPictogramElement();
        JavaPersistentAttribute oldAt = (JavaPersistentAttribute)this.getBusinessObjectForPictogramElement(pe);
        IRelation rel = this.getFeatureProvider().getRelationRelatedToAttribute(oldAt);
        String inverseJPTName = null;
        if (BidirectionalRelation.class.isInstance(rel)) {
            inverseJPTName = rel.getInverse().getName();
        }
        if (oldAt.getName().equals(value)) {
            return;
        }
        try {
            JpaArtifactFactory.instance().renameAttribute(oldAt, value, inverseJPTName, this.getFeatureProvider());
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        if (pe.getGraphicsAlgorithm() == null) {
            return;
        }
        final GraphicsAlgorithm alg = (GraphicsAlgorithm)pe.getGraphicsAlgorithm().getGraphicsAlgorithmChildren().get(0);
        final String newValue = value;
        TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)alg);
        ted.getCommandStack().execute((Command)new RecordingCommand(ted){

            protected void doExecute() {
                ((Text)alg).setValue(newValue);
            }
        });
    }
}

