/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.feature;

import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.i18n.JPAEditorMessages;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;

public class RestoreEntityFeature
extends AbstractCustomFeature {
    public RestoreEntityFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canExecute(ICustomContext context) {
        return true;
    }

    public void execute(ICustomContext context) {
        JavaPersistentType jpt = (JavaPersistentType)this.getFeatureProvider().getBusinessObjectForPictogramElement(context.getPictogramElements()[0]);
        if (JPAEditorUtil.isEntityOpenElsewhere(jpt, true)) {
            String shortEntName = JPAEditorUtil.returnSimpleName(JpaArtifactFactory.instance().getEntityName(jpt));
            String message = NLS.bind((String)JPAEditorMessages.JPASolver_closeWarningMsg, (Object)shortEntName);
            MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), JPAEditorMessages.JPASolver_closeEditors, null, message, 4, new String[]{JPAEditorMessages.BTN_OK}, 0){

                protected int getShellStyle() {
                    return 0x10860 | 1.getDefaultOrientation();
                }
            };
            dialog.open();
            return;
        }
        JpaArtifactFactory.instance().restoreEntityClass(jpt, this.getFeatureProvider());
    }

    public IJPAEditorFeatureProvider getFeatureProvider() {
        return (IJPAEditorFeatureProvider)super.getFeatureProvider();
    }

    public String getName() {
        return JPAEditorMessages.JPAEditorToolBehaviorProvider_discardChangesMenuItem;
    }
}

