/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.app.autagent;

import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jubula.autagent.AutStarter;
import org.eclipse.jubula.autagent.desktop.DesktopIntegration;
import org.eclipse.jubula.communication.connection.ConnectionState;
import org.eclipse.jubula.tools.exception.JBVersionException;
import org.eclipse.jubula.tools.utils.EnvironmentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutAgentApplication
implements IApplication {
    private static final Logger LOG = LoggerFactory.getLogger(AutAgentApplication.class);
    private static final int TIMEOUT_SEND_STOP_CMD = 10000;
    private static final String COMMANDLINE_OPTION_STOP = "stop";
    private static final String COMMANDLINE_OPTION_PORT = "p";
    private static final String COMMANDLINE_OPTION_HELP = "h";
    private static final String COMMANDLINE_OPTION_LENIENT = "l";
    private static final String COMMANDLINE_OPTION_VERBOSE = "v";
    private static final String COMMANDLINE_OPTION_QUIET = "q";
    private static final int EXIT_INVALID_OPTIONS = -1;
    private static final int EXIT_HELP_OPTION = 0;
    private static final int EXIT_SECURITY_VIOLATION = 1;
    private static final int EXIT_IO_EXCEPTION = 2;
    private static final int EXIT_CLIENT_SERVER_VERSION_ERROR = 4;

    public Object start(IApplicationContext context) throws Exception {
        String[] args = (String[])context.getArguments().get("application.args");
        if (args == null) {
            args = new String[]{};
        }
        AutStarter server = AutStarter.getInstance();
        PosixParser parser = new PosixParser();
        try {
            CommandLine cmd = parser.parse(AutAgentApplication.createOptions(), args);
            if (cmd.hasOption(COMMANDLINE_OPTION_HELP)) {
                this.printHelp();
                return 0;
            }
            int port = this.getPortNumber(cmd);
            if (cmd.hasOption(COMMANDLINE_OPTION_STOP)) {
                String hostname = "localhost";
                if (cmd.getOptionValue(COMMANDLINE_OPTION_STOP) != null) {
                    hostname = cmd.getOptionValue(COMMANDLINE_OPTION_STOP);
                }
                this.stopAutAgent(hostname, port);
            } else {
                boolean killDuplicateAuts = !cmd.hasOption(COMMANDLINE_OPTION_LENIENT);
                AutStarter.Verbosity verbosity = AutStarter.Verbosity.NORMAL;
                if (cmd.hasOption(COMMANDLINE_OPTION_VERBOSE)) {
                    verbosity = AutStarter.Verbosity.VERBOSE;
                } else if (cmd.hasOption(COMMANDLINE_OPTION_QUIET)) {
                    verbosity = AutStarter.Verbosity.QUIET;
                }
                DesktopIntegration di = new DesktopIntegration(server.getAgent());
                di.setPort(port);
                server.getAgent().addPropertyChangeListener("auts", (PropertyChangeListener)di);
                server.start(port, killDuplicateAuts, verbosity, true);
            }
        }
        catch (ParseException pe) {
            String message = "invalid option: ";
            LOG.error(message, (Throwable)pe);
            this.printHelp();
            return -1;
        }
        catch (SecurityException se) {
            LOG.error("security violation", (Throwable)se);
            return 1;
        }
        catch (IOException ioe) {
            String message = "could not open socket: ";
            LOG.error(message, (Throwable)ioe);
            return 2;
        }
        catch (NumberFormatException nfe) {
            String message = "invalid value for option port";
            LOG.error(message, (Throwable)nfe);
            return -1;
        }
        catch (NullPointerException npe) {
            LOG.error("no command line", (Throwable)npe);
            this.printHelp();
            return -1;
        }
        catch (JBVersionException ve) {
            LOG.error(ve.getMessage(), (Throwable)ve);
            return 4;
        }
        return IApplication.EXIT_OK;
    }

    public void stop() {
    }

    private static Options createOptions() {
        Options options = new Options();
        Option portOption = new Option(COMMANDLINE_OPTION_PORT, true, "the port to listen to");
        portOption.setArgName("port");
        options.addOption(portOption);
        options.addOption(COMMANDLINE_OPTION_LENIENT, false, "lenient mode; does not shutdown AUTs that try to register themselves using an already registered AUT ID");
        options.addOption(COMMANDLINE_OPTION_HELP, false, "prints this help text and exits");
        OptionGroup verbosityOptions = new OptionGroup();
        verbosityOptions.addOption(new Option(COMMANDLINE_OPTION_QUIET, false, "quiet mode"));
        verbosityOptions.addOption(new Option(COMMANDLINE_OPTION_VERBOSE, false, "verbose mode"));
        options.addOptionGroup(verbosityOptions);
        OptionGroup startStopOptions = new OptionGroup();
        startStopOptions.addOption(new Option("start", false, "startup mode"));
        OptionBuilder.hasOptionalArg();
        Option stopOption = OptionBuilder.create((String)COMMANDLINE_OPTION_STOP);
        stopOption.setDescription("stops a running AUT Agent instance for the given port on the given hostname (default \"localhost\")");
        stopOption.setArgName("hostname");
        startStopOptions.addOption(stopOption);
        options.addOptionGroup(startStopOptions);
        return options;
    }

    private void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("autagent", AutAgentApplication.createOptions(), true);
    }

    private void waitForAgentToTerminate(BufferedReader br) {
        boolean socketAlive = true;
        while (socketAlive) {
            try {
                if (br.readLine() != null) continue;
                socketAlive = false;
            }
            catch (IOException iOException) {
                socketAlive = false;
            }
        }
    }

    private int getPortNumber(CommandLine cmd) {
        int port = 60000;
        if (cmd.hasOption(COMMANDLINE_OPTION_PORT)) {
            port = Integer.valueOf(cmd.getOptionValue(COMMANDLINE_OPTION_PORT));
        } else {
            String portStr = EnvironmentUtils.getProcessEnvironment().getProperty("TEST_AUT_AGENT_PORT");
            if (portStr != null && !portStr.trim().equals("")) {
                try {
                    port = Integer.valueOf(portStr);
                }
                catch (NumberFormatException nfe) {
                    LOG.error("Format of portnumber in Environment-Variable 'TEST_AUT_AGENT_PORT' is not an integer", (Throwable)nfe);
                }
            }
            LOG.info("using default port " + String.valueOf(port));
        }
        return port;
    }

    private void stopAutAgent(String hostname, int port) throws UnknownHostException, IOException, JBVersionException {
        try {
            Socket commandSocket = new Socket(hostname, port);
            InputStream inputStream = commandSocket.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
            ConnectionState.respondToTypeRequest((long)10000L, (BufferedReader)br, (InputStream)inputStream, (PrintStream)new PrintStream(commandSocket.getOutputStream()), (String)"ClientType.Command.ShutDown");
            this.waitForAgentToTerminate(br);
        }
        catch (ConnectException connectException) {
            System.out.println("AUT Agent not found at " + hostname + ":" + port);
        }
    }
}

