/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.app.cmd;

import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.eclipse.jubula.app.cmd.batch.ExecutionController;
import org.eclipse.jubula.app.cmd.i18n.Messages;
import org.eclipse.jubula.client.cmd.AbstractCmdlineClient;
import org.eclipse.jubula.client.cmd.JobConfiguration;
import org.eclipse.jubula.tools.exception.CommunicationException;
import org.eclipse.jubula.tools.exception.JBFatalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Client
extends AbstractCmdlineClient {
    private static Logger log = LoggerFactory.getLogger(Client.class);
    private static AbstractCmdlineClient instance = null;

    private Client() {
    }

    public static AbstractCmdlineClient getInstance() {
        if (instance == null) {
            instance = new Client();
        }
        return instance;
    }

    protected void preRun() {
        ExecutionController.getInstance().setJob(this.getJob());
    }

    public int doRun() {
        int exitCode = 0;
        try {
            ExecutionController controller = ExecutionController.getInstance();
            if (this.isNoRun()) {
                controller.simulateJob();
            } else if (!controller.executeJob()) {
                exitCode = 1;
            }
        }
        catch (CommunicationException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            Client.printlnConsoleError((String)e.getMessage());
        }
        catch (IllegalArgumentException e) {
            log.error("An error occured: ", (Throwable)e);
            Client.printlnConsoleError((String)e.getMessage());
        }
        catch (JBFatalException e) {
            log.error("An error occured: ", (Throwable)e);
            Client.printlnConsoleError((String)e.getMessage());
        }
        catch (Throwable t) {
            log.error("An unexpected error occured in command-line-client: ", t);
            Client.printlnConsoleError((String)t.getMessage());
        }
        this.shutdown();
        return exitCode;
    }

    protected void extendOptions(Options options, boolean req) {
        options.addOption(Client.createOption((String)"server", (boolean)true, (String)"hostname", (String)org.eclipse.jubula.client.cmd.i18n.Messages.ClientServerOpt, (boolean)req));
        options.addOption(Client.createOption((String)"port", (boolean)true, (String)"port_number", (String)org.eclipse.jubula.client.cmd.i18n.Messages.ClientPortOpt, (boolean)req));
        options.addOption(Client.createOption((String)"project", (boolean)true, (String)"project_name", (String)org.eclipse.jubula.client.cmd.i18n.Messages.ClientProjectOpt, (boolean)req));
        options.addOption(Client.createOption((String)"version", (boolean)true, (String)"project_version", (String)org.eclipse.jubula.client.cmd.i18n.Messages.ClientProjectVersionOpt, (boolean)req));
        options.addOption(Client.createOption((String)"language", (boolean)true, (String)"language", (String)org.eclipse.jubula.client.cmd.i18n.Messages.ClientLanguageOpt, (boolean)req));
        options.addOption(Client.createOption((String)"resultdir", (boolean)true, (String)"resultdir", (String)org.eclipse.jubula.client.cmd.i18n.Messages.ClientResultdirOpt, (boolean)req));
        OptionGroup autOptionGroup = new OptionGroup();
        autOptionGroup.setRequired(false);
        autOptionGroup.addOption(Client.createOption((String)"autconfig", (boolean)true, (String)"autconfig", (String)org.eclipse.jubula.client.cmd.i18n.Messages.ClientAutconfigOpt, (boolean)req));
        autOptionGroup.addOption(Client.createOption((String)"autid", (boolean)true, (String)"autid", (String)org.eclipse.jubula.client.cmd.i18n.Messages.ClientAutIdOpt, (boolean)req));
        options.addOptionGroup(autOptionGroup);
        OptionGroup testExecutionGroup = new OptionGroup();
        testExecutionGroup.setRequired(req);
        testExecutionGroup.addOption(Client.createOption((String)"testjob", (boolean)true, (String)"testjob", (String)org.eclipse.jubula.client.cmd.i18n.Messages.ClientTestJobOpt, (boolean)req));
        testExecutionGroup.addOption(Client.createOption((String)"testsuite", (boolean)true, (String)"testsuite", (String)org.eclipse.jubula.client.cmd.i18n.Messages.ClientTestSuiteOpt, (boolean)req));
        options.addOptionGroup(testExecutionGroup);
        options.addOption(Client.createOption((String)"datadir", (boolean)true, (String)"datadir_path", (String)org.eclipse.jubula.client.cmd.i18n.Messages.ClientDataFile, (boolean)req));
        options.addOption(Client.createOption((String)"n", (boolean)false, (String)"", (String)org.eclipse.jubula.client.cmd.i18n.Messages.ClientNoRunOpt, (boolean)false));
        options.addOption(Client.createOption((String)"s", (boolean)false, (String)"", (String)org.eclipse.jubula.client.cmd.i18n.Messages.ClientAutoScreenshot, (boolean)false));
        options.addOption(Client.createOption((String)"r", (boolean)false, (String)"", (String)org.eclipse.jubula.client.cmd.i18n.Messages.ClientRelevantFlag, (boolean)false));
        options.addOption(Client.createOption((String)"timeout", (boolean)true, (String)"timeout", (String)org.eclipse.jubula.client.cmd.i18n.Messages.ClientTimeout, (boolean)false));
        options.addOption(Client.createOption((String)"startserver", (boolean)true, (String)"port_number", (String)org.eclipse.jubula.client.cmd.i18n.Messages.ClientStartServerOpt, (boolean)false));
    }

    protected void extendValidate(JobConfiguration job, StringBuilder errorMsgs) {
        if (job.getProjectName() == null) {
            this.appendError(errorMsgs, "project", "project_name");
        }
        if (job.getProjectMajor() == null || job.getProjectMinor() == null) {
            this.appendError(errorMsgs, "version", "project_version");
        }
        if (job.getServer() == null) {
            this.appendError(errorMsgs, "server", "hostname");
        }
        if (job.getPort() == null) {
            this.appendError(errorMsgs, "port", "port_number");
        }
        if (job.getAutConfigName() == null && job.getAutId() == null && job.getTestJobName() == null) {
            this.appendError(errorMsgs, "autconfig", "autconfig");
            this.appendError(errorMsgs, "autid", "autid");
        }
        if (job.getLanguage() == null) {
            this.appendError(errorMsgs, "language", "language");
        }
        if (job.getResultDir() == null) {
            this.appendError(errorMsgs, "resultdir", "resultdir");
        }
        if (job.getDataDir() == null) {
            this.appendError(errorMsgs, "datadir", "datadir_path");
        }
        if (job.getTestSuiteNames().isEmpty() && job.getTestJobName() == null && job.getServerPort() == null) {
            this.appendError(errorMsgs, "testsuite", "testsuite");
            this.appendError(errorMsgs, "testjob", "testjob");
        }
        if (job.getTimeout() < 0) {
            this.appendError(errorMsgs, "timeout", "timeout");
        }
    }

    public String getCmdlineClientExecName() {
        return Messages.ClientNameShort;
    }
}

