/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.app;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jubula.app.core.WorkSpaceData;
import org.eclipse.jubula.app.i18n.Messages;
import org.eclipse.jubula.app.ui.ChooseWorkspaceDialog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Launcher
implements IApplication,
IExecutableExtension {
    private static final String METADATA_FOLDER = ".metadata";
    private static final String VERSION_FILENAME = "version.ini";
    private static final String WORKSPACE_VERSION_KEY = "org.eclipse.core.runtime";
    private static final String WORKSPACE_VERSION_VALUE = "1";
    private static Logger log = LoggerFactory.getLogger(Launcher.class);

    protected boolean checkInstanceLocation(Shell shell) {
        Location instanceLoc = Platform.getInstanceLocation();
        if (instanceLoc == null) {
            MessageDialog.openError((Shell)shell, (String)Messages.LauncherValidWorkspaceTitle, (String)Messages.LauncherValidWorkspace);
            return false;
        }
        if (instanceLoc.isSet()) {
            return true;
        }
        URL defaultUrl = instanceLoc.getDefault();
        String initialDefault = defaultUrl == null ? null : defaultUrl.getFile();
        WorkSpaceData launchData = new WorkSpaceData(initialDefault);
        URL workspaceUrl;
        while ((workspaceUrl = this.promptForWorkspace(shell, launchData)) != null) {
            try {
                if (instanceLoc.set(workspaceUrl, true)) {
                    launchData.writePersistedData(shell);
                    Launcher.writeWorkspaceVersion(shell);
                    return true;
                }
            }
            catch (IllegalStateException illegalStateException) {
                MessageDialog.openError((Shell)shell, (String)Messages.LauncherCannotBeSetTitle, (String)Messages.LauncherCannotBeSet);
                return false;
            }
            catch (IOException iOException) {
                MessageDialog.openError((Shell)shell, (String)Messages.LauncherCannotBeSetTitle, (String)Messages.LauncherCannotBeSet);
                return false;
            }
            MessageDialog.openError((Shell)shell, (String)Messages.LauncherAlreadyInUseTitle, (String)Messages.LauncherAlreadyInUse);
        }
        return false;
    }

    private URL promptForWorkspace(Shell shell, WorkSpaceData launchData) {
        URL url = null;
        do {
            ChooseWorkspaceDialog wd = new ChooseWorkspaceDialog(shell, launchData);
            wd.open();
            String instancePath = launchData.getSelection();
            if (instancePath == null || wd.getReturnCode() == 1) {
                return null;
            }
            try {
                File file = new File(instancePath);
                url = file.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                MessageDialog.openError((Shell)shell, (String)Messages.LauncherNotValidTitle, (String)Messages.LauncherNotValid);
            }
        } while (!this.isValidWorkspace(shell, url));
        return url;
    }

    private boolean isValidWorkspace(Shell shell, URL url) {
        String version = Launcher.readWorkspaceVersion(url, shell);
        if (version == null) {
            return true;
        }
        int ideversion = Integer.parseInt(WORKSPACE_VERSION_VALUE);
        int workspaceversion = Integer.parseInt(version);
        if (workspaceversion == ideversion) {
            return true;
        }
        String title = Messages.LauncherDifferentVersionTitle;
        String message = NLS.bind((String)Messages.LauncherDifferentVersionMessage, (Object)url.getFile());
        MessageBox mbox = new MessageBox(shell, 65832);
        mbox.setText(title);
        mbox.setMessage(message);
        return mbox.open() == 32;
    }

    private static String readWorkspaceVersion(URL workspace, Shell shell) {
        File versionFile = Launcher.getVersionFile(workspace, false);
        if (versionFile == null || !versionFile.exists()) {
            return null;
        }
        try {
            Properties props = new Properties();
            FileInputStream is = new FileInputStream(versionFile);
            try {
                props.load(is);
            }
            finally {
                is.close();
            }
            return props.getProperty(WORKSPACE_VERSION_KEY);
        }
        catch (IOException e) {
            log.error(Messages.CouldNotReadVersionFile, (Throwable)e);
            MessageDialog.openError((Shell)shell, (String)Messages.LauncherCouldNotReadTitle, (String)Messages.LauncherCouldNotRead);
            return null;
        }
    }

    private static void writeWorkspaceVersion(Shell shell) {
        block16: {
            Location instanceLoc = Platform.getInstanceLocation();
            if (instanceLoc == null || instanceLoc.isReadOnly()) {
                return;
            }
            File versionFile = Launcher.getVersionFile(instanceLoc.getURL(), true);
            if (versionFile == null) {
                return;
            }
            OutputStream output = null;
            try {
                try {
                    String versionLine = "org.eclipse.core.runtime=1";
                    output = new FileOutputStream(versionFile);
                    output.write(versionLine.getBytes("UTF-8"));
                }
                catch (IOException e) {
                    log.error(Messages.CouldNotWriteVersionFile, (Throwable)e);
                    MessageDialog.openError((Shell)shell, (String)Messages.LauncherCouldNotWriteTitle, (String)Messages.LauncherCouldNotWrite);
                    try {
                        if (output != null) {
                            output.close();
                        }
                        break block16;
                    }
                    catch (IOException iOException) {}
                    break block16;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static File getVersionFile(URL workspaceUrl, boolean create) {
        File versionFile;
        block6: {
            File metaDir;
            block5: {
                if (workspaceUrl == null) {
                    return null;
                }
                try {
                    URL metaUrl = new URL(workspaceUrl, METADATA_FOLDER);
                    metaDir = new File(metaUrl.getFile());
                    if (metaDir.exists() || create && metaDir.mkdir()) break block5;
                    return null;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            URL versionUrl = new URL(metaDir.toURL(), VERSION_FILENAME);
            versionFile = new File(versionUrl.getFile());
            if (versionFile.exists() || create && versionFile.createNewFile()) break block6;
            return null;
        }
        return versionFile;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
    }

    public Object start(IApplicationContext context) throws Exception {
        Display.setAppName((String)"Jubula");
        Display display = new Display();
        try {
            Shell shell = new Shell(display, 147456);
            try {
                if (!this.checkInstanceLocation(shell)) {
                    context.applicationRunning();
                    Integer n = EXIT_OK;
                    return n;
                }
            }
            finally {
                if (shell != null) {
                    shell.dispose();
                }
            }
            {
            }
        }
        finally {
            if (display != null) {
                display.dispose();
            }
        }
    }

    public void stop() {
    }
}

