/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.app.core;

import org.eclipse.core.commands.HandlerEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jubula.app.i18n.Messages;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.utils.CommandHelper;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.handlers.IHandlerService;

public class ActionBuilder {
    private IWorkbenchWindow m_window;
    private ActionFactory.IWorkbenchAction m_quitAction;
    private ActionFactory.IWorkbenchAction m_prefAction;
    private ActionFactory.IWorkbenchAction m_helpCont;
    private ActionFactory.IWorkbenchAction m_intro;
    private ActionFactory.IWorkbenchAction m_fileSave;
    private ActionFactory.IWorkbenchAction m_refresh;
    private ActionFactory.IWorkbenchAction m_fileSaveAll;
    private ActionFactory.IWorkbenchAction m_resetPersp;
    private ActionFactory.IWorkbenchAction m_cut;
    private ActionFactory.IWorkbenchAction m_paste;
    private ActionFactory.IWorkbenchAction m_redo;
    private ActionFactory.IWorkbenchAction m_undo;

    public ActionBuilder(IWorkbenchWindow window) {
        this.m_window = window;
    }

    public void fillActionBars(IActionBarConfigurer configurer, int flags) {
        if ((flags & 1) == 0) {
            this.makeActions(configurer);
        }
        if ((flags & 2) != 0) {
            this.fillMenuBar(configurer.getMenuManager());
        }
        if ((flags & 4) != 0) {
            this.fillCoolBar(configurer.getCoolBarManager());
        }
    }

    private void makeActions(IActionBarConfigurer configurer) {
        IHandlerService handlerService = (IHandlerService)this.m_window.getService(IHandlerService.class);
        String saveCommandId = "org.eclipse.ui.file.save";
        String saveAllCommandId = "org.eclipse.ui.file.saveAll";
        String refreshCommandId = "org.eclipse.ui.file.refresh";
        String cutCommandId = "org.eclipse.ui.edit.cut";
        String pasteCommandId = "org.eclipse.ui.edit.paste";
        this.m_intro = ActionFactory.INTRO.create(this.m_window);
        this.m_helpCont = ActionFactory.HELP_CONTENTS.create(this.m_window);
        this.m_helpCont.setToolTipText(Messages.ActionBuilderHelpContentItem);
        this.m_helpCont.setText(Messages.ActionBuilderHelpContentToolTip);
        this.m_quitAction = ActionFactory.QUIT.create(this.m_window);
        this.m_quitAction.setText(Messages.ActionBuilderExitItem);
        this.m_prefAction = ActionFactory.PREFERENCES.create(this.m_window);
        this.m_prefAction.setText(Messages.ActionBuilderPreferencesItem);
        this.m_fileSaveAll = ActionFactory.SAVE_ALL.create(this.m_window);
        this.m_fileSaveAll.setToolTipText(Messages.ActionBuilderSaveAllToolTip);
        this.m_fileSaveAll.setText(Messages.ActionBuilderSaveAllItem);
        this.m_fileSaveAll.setActionDefinitionId(saveAllCommandId);
        handlerService.activateHandler(saveAllCommandId, (IHandler)new ActionHandler((IAction)this.m_fileSaveAll));
        this.m_fileSave = ActionFactory.SAVE.create(this.m_window);
        this.m_fileSave.setToolTipText(Messages.ActionBuilderSaveToolTip);
        this.m_fileSave.setText(Messages.ActionBuilderSaveItem);
        this.m_fileSave.setActionDefinitionId(saveCommandId);
        ActionHandler saveHandler = new ActionHandler((IAction)this.m_fileSave);
        saveHandler.addHandlerListener(new IHandlerListener(){

            public void handlerChanged(HandlerEvent handlerEvent) {
                IEditorPart[] parts = Plugin.getDefault().getDirtyEditors();
                if (parts.length == 0 || parts.length == 1 && parts[0] == Plugin.getActiveEditor() && !ActionBuilder.this.m_fileSave.isEnabled()) {
                    ActionBuilder.this.m_fileSaveAll.setEnabled(false);
                }
            }
        });
        handlerService.activateHandler(saveCommandId, (IHandler)saveHandler);
        this.m_refresh = ActionFactory.REFRESH.create(this.m_window);
        this.m_refresh.setText(Messages.ActionBuilderrefreshItem);
        this.m_refresh.setActionDefinitionId(refreshCommandId);
        handlerService.activateHandler(refreshCommandId, (IHandler)new ActionHandler((IAction)this.m_refresh));
        this.m_refresh.setImageDescriptor(IconConstants.REFRESH_IMAGE_DESCRIPTOR);
        this.m_refresh.setDisabledImageDescriptor(IconConstants.REFRESH_DISABLED_IMAGE_DESCRIPTOR);
        configurer.registerGlobalAction((IAction)this.m_refresh);
        this.m_resetPersp = ActionFactory.RESET_PERSPECTIVE.create(this.m_window);
        this.m_resetPersp.setText(Messages.ActionBuilderresetPerspective);
        this.m_cut = this.createCutAction(cutCommandId);
        configurer.registerGlobalAction((IAction)this.m_cut);
        this.m_paste = ActionFactory.PASTE.create(this.m_window);
        this.m_paste.setToolTipText(Messages.ActionBuilderPasteToolTip);
        this.m_paste.setText(Messages.ActionBuilderPasteItem);
        this.m_paste.setActionDefinitionId(pasteCommandId);
        configurer.registerGlobalAction((IAction)this.m_paste);
        this.addMBTspecificActions(configurer);
    }

    private void addMBTspecificActions(IActionBarConfigurer configurer) {
        this.m_redo = ActionFactory.REDO.create(this.m_window);
        configurer.registerGlobalAction((IAction)this.m_redo);
        this.m_undo = ActionFactory.UNDO.create(this.m_window);
        configurer.registerGlobalAction((IAction)this.m_undo);
    }

    private ActionFactory.IWorkbenchAction createCutAction(String commandId) {
        ActionFactory.IWorkbenchAction cutAction = ActionFactory.CUT.create(this.m_window);
        cutAction.setToolTipText(Messages.ActionBuilderCutToolTip);
        cutAction.setText(Messages.ActionBuilderCutItem);
        cutAction.setActionDefinitionId(commandId);
        return cutAction;
    }

    private void fillMenuBar(IMenuManager menuBar) {
        this.m_resetPersp.setEnabled(true);
        menuBar.setRemoveAllWhenShown(true);
        menuBar.add((IContributionItem)this.createFileMenu());
        menuBar.add((IContributionItem)this.createEditMenu());
        menuBar.add((IContributionItem)this.createSearchMenu());
        menuBar.add((IContributionItem)this.createRunMenu());
        menuBar.add((IContributionItem)this.createWindowMenu());
        menuBar.add((IContributionItem)this.createHelpMenu());
    }

    private IMenuManager createEditMenu() {
        MenuManager editMenu = new MenuManager(Messages.ActionBuilderEdit, "edit");
        editMenu.add((IAction)this.m_redo);
        editMenu.add((IAction)this.m_undo);
        editMenu.add((IContributionItem)new Separator());
        editMenu.add((IAction)this.m_cut);
        editMenu.add((IAction)this.m_paste);
        editMenu.add((IContributionItem)new Separator());
        editMenu.add((IContributionItem)new GroupMarker("JubulaEditSeparator1"));
        editMenu.add((IContributionItem)new Separator());
        editMenu.add((IContributionItem)new GroupMarker("JubulaEditSeparator2"));
        editMenu.add((IContributionItem)new Separator());
        editMenu.add((IContributionItem)new GroupMarker("JubulaEditSeparator3"));
        return editMenu;
    }

    private IMenuManager createSearchMenu() {
        MenuManager searchMenu = new MenuManager(Messages.ActionBuilderSearch, "org.eclipse.search.menu");
        return searchMenu;
    }

    private IMenuManager createRunMenu() {
        MenuManager runMenu = new MenuManager(Messages.ActionBuilderRun, "org.eclipse.ui.run");
        return runMenu;
    }

    private IMenuManager createFileMenu() {
        MenuManager fileMenu = new MenuManager(Messages.ActionBuilderMyFileEntry, "file");
        fileMenu.add((IAction)this.m_fileSave);
        fileMenu.add((IAction)this.m_fileSaveAll);
        fileMenu.add((IContributionItem)new Separator());
        CommandHelper.createContributionPushItem((IMenuManager)fileMenu, (String)"org.eclipse.ui.edit.rename");
        CommandHelper.createContributionPushItem((IMenuManager)fileMenu, (String)"org.eclipse.ui.file.refresh");
        fileMenu.add((IContributionItem)new Separator());
        CommandHelper.createContributionPushItem((IMenuManager)fileMenu, (String)ActionFactory.IMPORT.getCommandId());
        CommandHelper.createContributionPushItem((IMenuManager)fileMenu, (String)ActionFactory.EXPORT.getCommandId());
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IAction)this.m_quitAction);
        return fileMenu;
    }

    private IMenuManager createWindowMenu() {
        MenuManager windowMenu = new MenuManager(Messages.ActionBuilderWindowEntry, "window");
        windowMenu.add((IContributionItem)this.createOpenPersp());
        windowMenu.add((IContributionItem)this.createShowView());
        windowMenu.add((IContributionItem)new Separator());
        windowMenu.add((IAction)this.m_resetPersp);
        windowMenu.add((IContributionItem)new Separator());
        windowMenu.add((IAction)this.m_prefAction);
        return windowMenu;
    }

    private IMenuManager createShowView() {
        MenuManager showView = new MenuManager(Messages.ActionBuildershowView);
        showView.add(ContributionItemFactory.VIEWS_SHORTLIST.create(this.m_window));
        return showView;
    }

    private IMenuManager createOpenPersp() {
        MenuManager openPersp = new MenuManager(Messages.ActionBuilderopenPerspective);
        openPersp.add(ContributionItemFactory.PERSPECTIVES_SHORTLIST.create(this.m_window));
        return openPersp;
    }

    private IMenuManager createHelpMenu() {
        MenuManager helpMenu = new MenuManager(Messages.ActionBuilderMyHelpEntry, "help");
        helpMenu.add((IAction)this.m_intro);
        helpMenu.add((IAction)this.m_helpCont);
        helpMenu.add((IContributionItem)new Separator("helpEnd"));
        CommandHelper.createContributionPushItem((IMenuManager)helpMenu, (String)"org.eclipse.ui.help.aboutAction");
        helpMenu.add((IContributionItem)new Separator());
        helpMenu.add(CommandHelper.createContributionItem((String)"org.eclipse.ui.cheatsheets.openCheatSheet", null, (String)Messages.ActionBuilderHelpCheatSheetsItem, (int)8));
        return helpMenu;
    }

    private void fillCoolBar(ICoolBarManager coolBar) {
        ToolBarManager toolBar = new ToolBarManager(0x820000);
        coolBar.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)toolBar));
        ActionContributionItem save = new ActionContributionItem((IAction)this.m_fileSave);
        toolBar.add((IContributionItem)save);
    }

    public void dispose() {
        if (this.m_cut != null) {
            this.m_cut.dispose();
        }
        if (this.m_fileSave != null) {
            this.m_fileSave.dispose();
        }
        if (this.m_helpCont != null) {
            this.m_helpCont.dispose();
        }
        if (this.m_paste != null) {
            this.m_paste.dispose();
        }
        if (this.m_prefAction != null) {
            this.m_prefAction.dispose();
        }
        if (this.m_quitAction != null) {
            this.m_quitAction.dispose();
        }
        if (this.m_resetPersp != null) {
            this.m_resetPersp.dispose();
        }
    }
}

