/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.app.core;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jubula.app.i18n.Messages;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkSpaceData {
    private static final int RECENT_MAX_LENGTH = 5;
    private static final String PERS_FOLDER = "org.eclipse.jubula.app";
    private static final String PERS_FILENAME = "recentWorkspaces.xml";
    private static final int PERS_ENCODING_VERSION = 1;
    private static Logger log = LoggerFactory.getLogger(WorkSpaceData.class);
    private String m_initialDefault;
    private String m_selection;
    private String[] m_recentWorkspaces;

    public WorkSpaceData(String initialDefault) {
        this.readPersistedData();
        this.m_initialDefault = initialDefault;
    }

    public String getInitialDefault() {
        if (this.m_initialDefault == null) {
            this.m_initialDefault = String.valueOf(System.getProperty("user.dir")) + File.separator + "jubulaWorkspace";
        }
        return this.m_initialDefault;
    }

    public String getSelection() {
        return this.m_selection;
    }

    public String[] getRecentWorkspaces() {
        return this.m_recentWorkspaces;
    }

    public void workspaceSelected(String dir) {
        this.m_selection = dir;
    }

    public void writePersistedData(Shell shell) {
        block19: {
            Location configLoc = Platform.getUserLocation();
            if (configLoc == null || configLoc.isReadOnly()) {
                return;
            }
            URL persUrl = WorkSpaceData.getPersistenceUrl(configLoc.getURL(), true);
            if (persUrl == null) {
                return;
            }
            if (this.m_selection != null) {
                String oldEntry = this.m_recentWorkspaces[0];
                this.m_recentWorkspaces[0] = this.m_selection;
                int i = 1;
                while (i < this.m_recentWorkspaces.length && oldEntry != null) {
                    if (this.m_selection.equals(oldEntry)) break;
                    String tmp = this.m_recentWorkspaces[i];
                    this.m_recentWorkspaces[i] = oldEntry;
                    oldEntry = tmp;
                    ++i;
                }
            }
            FileWriter writer = null;
            try {
                try {
                    writer = new FileWriter(persUrl.getFile());
                    XMLMemento memento = XMLMemento.createWriteRoot((String)Messages.LaunchWorkspaceData);
                    memento.createChild("protocol").putInteger("version", 1);
                    memento.createChild("lastUsedWorkspace").putString("path", this.m_selection);
                    IMemento recentMemento = memento.createChild("recentWorkspaces");
                    recentMemento.putInteger("maxLength", this.m_recentWorkspaces.length);
                    int i = 0;
                    while (i < this.m_recentWorkspaces.length) {
                        if (this.m_recentWorkspaces[i] == null) break;
                        recentMemento.createChild("workspace").putString("path", this.m_recentWorkspaces[i]);
                        ++i;
                    }
                    memento.save((Writer)writer);
                }
                catch (IOException e) {
                    log.error(Messages.UnableToWriteWorkspaceData, (Throwable)e);
                    MessageDialog.openError((Shell)shell, (String)Messages.WorkSpaceDataCantWriteDataTitle, (String)Messages.WorkSpaceDataCanWriteData);
                    if (writer != null) {
                        try {
                            ((Writer)writer).close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        ((Writer)writer).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    ((Writer)writer).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void readPersistedData() {
        URL persUrl = null;
        Location configLoc = Platform.getUserLocation();
        if (configLoc != null) {
            persUrl = WorkSpaceData.getPersistenceUrl(configLoc.getURL(), true);
        }
        try {
            IMemento[] indices;
            if (persUrl == null) {
                return;
            }
            FileReader reader = new FileReader(persUrl.getFile());
            XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
            if (memento == null || !WorkSpaceData.compatibleProtocol((IMemento)memento)) {
                return;
            }
            IMemento recent = memento.getChild("recentWorkspaces");
            if (recent == null) {
                return;
            }
            Integer maxLength = recent.getInteger("maxLength");
            int max = 5;
            if (maxLength != null) {
                max = maxLength;
            }
            if ((indices = recent.getChildren("workspace")) == null || indices.length <= 0) {
                return;
            }
            max = Math.max(max, indices.length);
            this.m_recentWorkspaces = new String[max];
            int i = 0;
            while (i < indices.length) {
                String path = indices[i].getString("path");
                if (path == null) break;
                this.m_recentWorkspaces[i] = path;
                ++i;
            }
            IMemento lastUsed = memento.getChild("lastUsedWorkspace");
            if (lastUsed == null) {
                this.m_selection = this.m_initialDefault;
                return;
            }
            this.m_selection = lastUsed.getString("path");
            return;
        }
        catch (IOException iOException) {
        }
        catch (WorkbenchException workbenchException) {
        }
        finally {
            if (this.m_recentWorkspaces == null) {
                this.m_recentWorkspaces = new String[5];
            }
        }
    }

    private static boolean compatibleProtocol(IMemento memento) {
        IMemento protocolMemento = memento.getChild("protocol");
        if (protocolMemento == null) {
            return false;
        }
        Integer version = protocolMemento.getInteger("version");
        return version != null && version == 1;
    }

    private static URL getPersistenceUrl(URL baseUrl, boolean create) {
        File persFile;
        block8: {
            File dir;
            URL url;
            block7: {
                block6: {
                    if (baseUrl == null) {
                        return null;
                    }
                    try {
                        url = new URL(baseUrl, PERS_FOLDER);
                        File baseDir = new File(baseUrl.getFile());
                        if (baseDir.exists() || create && baseDir.mkdir()) break block6;
                        return null;
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                }
                dir = new File(url.getFile());
                if (dir.exists() || create && dir.mkdir()) break block7;
                return null;
            }
            url = new URL(dir.toURL(), PERS_FILENAME);
            persFile = new File(url.getFile());
            if (persFile.exists() || create && persFile.createNewFile()) break block8;
            return null;
        }
        return persFile.toURL();
    }

    private static interface XML {
        public static final String PROTOCOL = "protocol";
        public static final String VERSION = "version";
        public static final String WORKSPACE = "workspace";
        public static final String LAST_USED_WORKSPACE = "lastUsedWorkspace";
        public static final String RECENT_WORKSPACES = "recentWorkspaces";
        public static final String MAX_LENGTH = "maxLength";
        public static final String PATH = "path";
    }
}

