/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.app.ui;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jubula.app.core.WorkSpaceData;
import org.eclipse.jubula.app.i18n.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ChooseWorkspaceDialog
extends TitleAreaDialog {
    private WorkSpaceData m_launchData;
    private String m_currentSelection;

    public ChooseWorkspaceDialog(Shell parentShell, WorkSpaceData launchData) {
        super(parentShell);
        this.m_launchData = launchData;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.setTitle(Messages.ChooseWorkspaceDialogDialogMessage);
        this.setMessage(Messages.ChooseWorkspaceDialogMessageArea);
        super.setShellStyle(147456);
        this.setShellStyle(147456);
        this.createWorkspaceBrowseRow(composite);
        return composite;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.ChooseWorkspaceDialogDialogText);
    }

    protected void okPressed() {
        this.m_launchData.workspaceSelected(this.m_currentSelection);
        super.okPressed();
    }

    protected void cancelPressed() {
        this.m_currentSelection = null;
        this.m_launchData.workspaceSelected(this.m_currentSelection);
        super.cancelPressed();
    }

    private void createWorkspaceBrowseRow(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(1808));
        panel.setFont(parent.getFont());
        Label label = new Label(panel, 0);
        label.setText(Messages.ChooseWorkspaceDialogWorkspace);
        final Combo text = new Combo(panel, 18436);
        text.setLayoutData((Object)new GridData(768));
        this.setInitialTextValues(text);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ChooseWorkspaceDialog.this.m_currentSelection = text.getText();
                ChooseWorkspaceDialog.this.m_launchData.workspaceSelected(ChooseWorkspaceDialog.this.m_currentSelection);
            }
        });
        text.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseWorkspaceDialog.this.m_currentSelection = text.getText();
                ChooseWorkspaceDialog.this.m_launchData.workspaceSelected(ChooseWorkspaceDialog.this.m_currentSelection);
            }
        });
        Button browseButton = new Button(panel, 8);
        browseButton.setText(Messages.ChooseWorkspaceDialogBrowse);
        this.setButtonLayoutData(browseButton);
        GridData data = (GridData)browseButton.getLayoutData();
        data.horizontalAlignment = 128;
        browseButton.setLayoutData((Object)data);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(ChooseWorkspaceDialog.this.getShell(), 147456);
                dialog.setText(Messages.ChooseWorkspaceDialogSelectDir);
                dialog.setMessage(Messages.ChooseWorkspaceDialogMessaageDir);
                dialog.setFilterPath(ChooseWorkspaceDialog.this.m_currentSelection);
                String dir = dialog.open();
                if (dir != null) {
                    text.setText(dir);
                    ChooseWorkspaceDialog.this.m_launchData.workspaceSelected(dir);
                }
            }
        });
    }

    private void setInitialTextValues(Combo text) {
        String[] recentWorkspaces = this.m_launchData.getRecentWorkspaces();
        int i = 0;
        while (i < recentWorkspaces.length) {
            if (recentWorkspaces[i] != null) {
                text.add(recentWorkspaces[i]);
            }
            ++i;
        }
        this.m_currentSelection = text.getItemCount() > 0 && this.m_launchData.getSelection() != null ? this.m_launchData.getSelection() : this.m_launchData.getInitialDefault();
        text.setText(this.m_currentSelection);
    }
}

