/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.archive;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import org.apache.commons.lang.ObjectUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jubula.client.archive.XmlImporter;
import org.eclipse.jubula.client.archive.i18n.Messages;
import org.eclipse.jubula.client.archive.schema.ActivationMethodEnum;
import org.eclipse.jubula.client.archive.schema.Attribute;
import org.eclipse.jubula.client.archive.schema.Aut;
import org.eclipse.jubula.client.archive.schema.AutConfig;
import org.eclipse.jubula.client.archive.schema.Cap;
import org.eclipse.jubula.client.archive.schema.Category;
import org.eclipse.jubula.client.archive.schema.CheckActivatedContext;
import org.eclipse.jubula.client.archive.schema.CheckAttribute;
import org.eclipse.jubula.client.archive.schema.CheckConfiguration;
import org.eclipse.jubula.client.archive.schema.CompNames;
import org.eclipse.jubula.client.archive.schema.ComponentName;
import org.eclipse.jubula.client.archive.schema.EventHandler;
import org.eclipse.jubula.client.archive.schema.EventTestCase;
import org.eclipse.jubula.client.archive.schema.I18NString;
import org.eclipse.jubula.client.archive.schema.MapEntry;
import org.eclipse.jubula.client.archive.schema.MonitoringValues;
import org.eclipse.jubula.client.archive.schema.NamedTestData;
import org.eclipse.jubula.client.archive.schema.Node;
import org.eclipse.jubula.client.archive.schema.ObjectMapping;
import org.eclipse.jubula.client.archive.schema.ObjectMappingProfile;
import org.eclipse.jubula.client.archive.schema.OmCategory;
import org.eclipse.jubula.client.archive.schema.OmEntry;
import org.eclipse.jubula.client.archive.schema.ParamDescription;
import org.eclipse.jubula.client.archive.schema.Project;
import org.eclipse.jubula.client.archive.schema.ReentryProperty;
import org.eclipse.jubula.client.archive.schema.RefTestCase;
import org.eclipse.jubula.client.archive.schema.RefTestSuite;
import org.eclipse.jubula.client.archive.schema.ReusedProject;
import org.eclipse.jubula.client.archive.schema.SummaryAttribute;
import org.eclipse.jubula.client.archive.schema.TechnicalName;
import org.eclipse.jubula.client.archive.schema.TestCase;
import org.eclipse.jubula.client.archive.schema.TestData;
import org.eclipse.jubula.client.archive.schema.TestDataCell;
import org.eclipse.jubula.client.archive.schema.TestDataRow;
import org.eclipse.jubula.client.archive.schema.TestJobs;
import org.eclipse.jubula.client.archive.schema.TestSuite;
import org.eclipse.jubula.client.archive.schema.TestresultSummaries;
import org.eclipse.jubula.client.archive.schema.TestresultSummary;
import org.eclipse.jubula.client.archive.schema.UsedToolkit;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.businessprocess.ProjectNameBP;
import org.eclipse.jubula.client.core.businessprocess.UsedToolkitBP;
import org.eclipse.jubula.client.core.model.IAUTConfigPO;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICapParamDescriptionPO;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.ICheckConfContPO;
import org.eclipse.jubula.client.core.model.ICheckConfPO;
import org.eclipse.jubula.client.core.model.ICompIdentifierPO;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IDataSetPO;
import org.eclipse.jubula.client.core.model.IDocAttributeDescriptionPO;
import org.eclipse.jubula.client.core.model.IDocAttributeListPO;
import org.eclipse.jubula.client.core.model.IDocAttributePO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.model.IObjectMappingCategoryPO;
import org.eclipse.jubula.client.core.model.IObjectMappingPO;
import org.eclipse.jubula.client.core.model.IObjectMappingProfilePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IRefTestSuitePO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITDManager;
import org.eclipse.jubula.client.core.model.ITestDataPO;
import org.eclipse.jubula.client.core.model.ITestJobPO;
import org.eclipse.jubula.client.core.model.ITestResultSummary;
import org.eclipse.jubula.client.core.model.ITestResultSummaryPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.IUsedToolkitPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.ISpecPersistable;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PMSaveException;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.core.persistence.TestResultSummaryPM;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.objects.MonitoringValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XmlExporter {
    private static final Comparator<Locale> LANG_CODE_ALPHA_COMPARATOR = new Comparator<Locale>(){

        @Override
        public int compare(Locale locale1, Locale locale2) {
            return ObjectUtils.toString((Object)locale1).compareTo(ObjectUtils.toString((Object)locale2));
        }
    };
    private static final char TABLE_AUT = 'A';
    private static final char TABLE_AUT_CONFIG = 'C';
    private static Logger log = LoggerFactory.getLogger(XmlExporter.class);
    private IProgressMonitor m_monitor;

    public XmlExporter(IProgressMonitor monitor) {
        this.m_monitor = monitor;
    }

    private void fillAUTConfig(AutConfig xml, IAUTConfigPO po) {
        xml.setId(this.i2id('C', po.getId()));
        xml.setName(po.getName());
        xml.setClassname("");
        xml.setClasspath("");
        xml.setJarfile("");
        xml.setParameter("");
        xml.setWorkingDir("");
        xml.setJreDir("");
        xml.setJreParameter("");
        xml.setServer("");
        xml.setEnvironment("");
        xml.setActivateApp(false);
        xml.setActivationMethod(ActivationMethodEnum.NONE);
        ArrayList sortedConfigKeys = new ArrayList(po.getAutConfigKeys());
        Collections.sort(sortedConfigKeys);
        for (String key : sortedConfigKeys) {
            MapEntry entry = xml.addNewConfAttrMapEntry();
            entry.setKey(key);
            entry.setValue(po.getValue(key, ""));
        }
    }

    private void fillAUT(Aut xml, IAUTMainPO po) {
        xml.setId(this.i2id('A', po.getId()));
        xml.setName(po.getName());
        xml.setAutToolkit(po.getToolkit());
        xml.setGenerateNames(po.isGenerateNames());
        ObjectMapping om = xml.addNewObjectMapping();
        this.fillObjectMapping(om, po.getObjMap());
        for (Locale l : po.getLangHelper().getLanguageList()) {
            xml.addLanguage(l.toString());
        }
        ArrayList sortedAutConfigs = new ArrayList(po.getAutConfigSet());
        Collections.sort(sortedAutConfigs, new Comparator<IAUTConfigPO>(){

            @Override
            public int compare(IAUTConfigPO autConfig1, IAUTConfigPO autConfig2) {
                return autConfig1.getName().compareTo(autConfig2.getName());
            }
        });
        for (IAUTConfigPO conf : sortedAutConfigs) {
            AutConfig xmlConf = xml.addNewConfig();
            this.fillAUTConfig(xmlConf, conf);
        }
        for (String autId : po.getAutIds()) {
            xml.addAutId(autId);
        }
    }

    private void fillObjectMapping(ObjectMapping xml, IObjectMappingPO po) {
        IObjectMappingProfilePO profilePo = po.getProfile();
        ObjectMappingProfile profileXml = xml.addNewProfile();
        profileXml.setName(profilePo.getName());
        profileXml.setContextFactor(profilePo.getContextFactor());
        profileXml.setNameFactor(profilePo.getNameFactor());
        profileXml.setPathFactor(profilePo.getPathFactor());
        profileXml.setThreshold(profilePo.getThreshold());
        this.fillObjectMappingCategory(xml.addNewMapped(), po.getMappedCategory());
        this.fillObjectMappingCategory(xml.addNewUnmappedComponent(), po.getUnmappedLogicalCategory());
        this.fillObjectMappingCategory(xml.addNewUnmappedTechnical(), po.getUnmappedTechnicalCategory());
    }

    private void fillObjectMappingCategory(OmCategory categoryXml, IObjectMappingCategoryPO category) {
        categoryXml.setName(category.getName());
        for (IObjectMappingCategoryPO subcategory : category.getUnmodifiableCategoryList()) {
            OmCategory subcategoryXml = categoryXml.addNewCategory();
            this.fillObjectMappingCategory(subcategoryXml, subcategory);
        }
        for (IObjectMappingAssoziationPO assoc : category.getUnmodifiableAssociationList()) {
            OmEntry assocXml = categoryXml.addNewAssociation();
            this.fillObjectMappingAssociation(assocXml, assoc);
        }
    }

    private void fillObjectMappingAssociation(OmEntry assocXml, IObjectMappingAssoziationPO assoc) {
        ICompIdentifierPO technicalName = assoc.getTechnicalName();
        if (technicalName != null) {
            TechnicalName xmlTecName = assocXml.addNewTechnicalName();
            this.fillTechnicalName(xmlTecName, technicalName);
        }
        assocXml.setType(assoc.getType());
        for (String logicalName : assoc.getLogicalNames()) {
            assocXml.addLogicalName(logicalName);
        }
    }

    private void fillTechnicalName(TechnicalName xml, ICompIdentifierPO po) {
        xml.setComponentClassName(po.getComponentClassName());
        xml.setSupportedClassName(po.getSupportedClassName());
        xml.setAlternativeDisplayName(po.getAlternativeDisplayName());
        for (Object n : po.getNeighbours()) {
            String neighbour = (String)n;
            xml.addNeighbour(neighbour);
        }
        for (Object h : po.getHierarchyNames()) {
            String hierarchy = (String)h;
            xml.addHierarchyName(hierarchy);
        }
    }

    public void fillProject(Project xml, IProjectPO po, boolean includeTestResultSummaries) throws ProjectDeletedException, PMException, OperationCanceledException {
        this.fillNode(xml, (INodePO)po);
        this.fillAttributes(xml, (INodePO)po, po.getProjectAttributeDescriptions());
        this.checkForCancel();
        this.fillCheckConfiguration(xml, po.getProjectProperties().getCheckConfCont());
        this.fillUsedToolkits(xml, po);
        this.m_monitor.worked(1);
        this.fillComponentNames(xml, po);
        String autToolKit = po.getToolkit();
        xml.setAutToolKit(autToolKit);
        this.m_monitor.worked(1);
        xml.setDefaultLanguage(po.getDefaultLanguage().toString());
        for (Locale l : po.getLangHelper().getLanguageList()) {
            xml.addProjectLanguage(l.toString());
            this.m_monitor.worked(1);
        }
        for (IParameterInterfacePO testDataCube : po.getTestDataCubeCont().getTestDataCubeList()) {
            NamedTestData xmlTestDataCube = xml.addNewNamedTestData();
            this.fillNamedTestData(xmlTestDataCube, testDataCube);
        }
        for (IAUTMainPO aut : this.getSortedAutList(po)) {
            Aut xmlAut = xml.addNewAut();
            this.fillAUT(xmlAut, aut);
            this.m_monitor.worked(1);
        }
        List tcDescList = po.getTestCaseAttributeDescriptions();
        for (ISpecPersistable tcOrCat : po.getSpecObjCont().getSpecObjList()) {
            this.checkForCancel();
            if (tcOrCat instanceof ICategoryPO) {
                Category cat = xml.addNewCategory();
                this.fillCategory(cat, (ICategoryPO)tcOrCat);
                continue;
            }
            TestCase tc = xml.addNewTestcase();
            this.fillTestCase(tc, (ISpecTestCasePO)tcOrCat);
            this.fillAttributes(tc, (INodePO)tcOrCat, tcDescList);
        }
        this.handleTestSuites(xml, po);
        this.checkForCancel();
        this.handleTestJobs(xml, po);
        this.checkForCancel();
        this.handleReusedProjects(xml, po);
        this.checkForCancel();
        if (includeTestResultSummaries) {
            this.fillTestResultSummary(xml, po);
        }
        this.checkForCancel();
        xml.setMetaDataVersion(po.getClientMetaDataVersion());
        xml.setMajorProjectVersion(po.getMajorProjectVersion());
        xml.setMinorProjectVersion(po.getMinorProjectVersion());
        xml.setIsReusable(po.getIsReusable());
        xml.setIsProtected(po.getIsProtected());
        xml.setTeststyleEnabled(po.getProjectProperties().getCheckConfCont().getEnabled());
        xml.setTestResultDetailsCleanupInterval(po.getTestResultCleanupInterval());
        this.m_monitor.worked(1);
    }

    private void fillCheckConfiguration(Project xml, ICheckConfContPO checkConfCont) {
        for (String chkId : checkConfCont.getConfMap().keySet()) {
            this.checkForCancel();
            ICheckConfPO chkConf = (ICheckConfPO)checkConfCont.getConfMap().get(chkId);
            CheckConfiguration xmlChkConf = xml.addNewCheckConfiguration();
            xmlChkConf.setCheckId(chkId);
            xmlChkConf.setActivated(chkConf.isActive());
            xmlChkConf.setSeverity(chkConf.getSeverity());
            this.fillCheckAttribute(xmlChkConf, chkConf.getAttr());
            this.fillCheckContext(xmlChkConf, chkConf.getContexts());
        }
    }

    private void fillCheckContext(CheckConfiguration xmlChkConf, Map<String, Boolean> contexts) {
        for (Map.Entry<String, Boolean> e : contexts.entrySet()) {
            this.checkForCancel();
            CheckActivatedContext c = xmlChkConf.addNewActiveContext();
            c.setClass1(e.getKey());
            Boolean obj = e.getValue();
            if (obj instanceof BigDecimal) {
                BigDecimal bd = (BigDecimal)((Object)obj);
                c.setActive(bd.equals(BigDecimal.ONE));
                continue;
            }
            c.setActive(e.getValue());
        }
    }

    private void fillCheckAttribute(CheckConfiguration xmlChkConf, Map<String, String> attr) {
        for (Map.Entry<String, String> e : attr.entrySet()) {
            this.checkForCancel();
            CheckAttribute chkAttr = xmlChkConf.addNewCheckAttribute();
            chkAttr.setName(e.getKey());
            chkAttr.setValue(e.getValue());
        }
    }

    private List<IAUTMainPO> getSortedAutList(IProjectPO po) {
        ArrayList<IAUTMainPO> sortedAuts = new ArrayList<IAUTMainPO>(po.getAutMainList());
        Collections.sort(sortedAuts, new Comparator<IAUTMainPO>(){

            @Override
            public int compare(IAUTMainPO aut1, IAUTMainPO aut2) {
                return aut1.getGuid().compareTo(aut2.getGuid());
            }
        });
        return sortedAuts;
    }

    private void fillTestResultSummary(Project xml, IProjectPO po) throws PMException {
        PropertyDescriptor[] properties = XmlImporter.BEAN_UTILS.getPropertyUtils().getPropertyDescriptors(ITestResultSummary.class);
        List poSummaryList = TestResultSummaryPM.getAllTestResultSummaries((IProjectPO)po, null);
        TestresultSummaries xmlSummaryList = xml.addNewTestresultSummaries();
        for (ITestResultSummaryPO poSummary : poSummaryList) {
            this.checkForCancel();
            if (!poSummary.isTestsuiteRelevant()) continue;
            TestresultSummary xmlSummary = xmlSummaryList.addNewTestresultSummary();
            PropertyDescriptor[] propertyDescriptorArray = properties;
            int n = properties.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor p = propertyDescriptorArray[n2];
                String pName = p.getName();
                try {
                    String pValue = XmlImporter.BEAN_UTILS.getProperty((Object)poSummary, pName);
                    Class<?> pType = p.getPropertyType();
                    SummaryAttribute xmlSummaryAttribute = xmlSummary.addNewAttribute();
                    xmlSummaryAttribute.setKey(pName);
                    if (pValue != null) {
                        xmlSummaryAttribute.setValue(pValue);
                    } else {
                        xmlSummaryAttribute.setNilValue();
                    }
                    xmlSummaryAttribute.setType(pType.getName());
                }
                catch (NoSuchMethodException e) {
                    log.warn("An error occured: ", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    log.warn("An error occured: ", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    log.warn("An error occured: ", (Throwable)e);
                }
                ++n2;
            }
            Map tmpMap = poSummary.getMonitoringValues();
            for (Map.Entry pairs : tmpMap.entrySet()) {
                MonitoringValue tmp = (MonitoringValue)pairs.getValue();
                MonitoringValues monTmp = xmlSummary.addNewMonitoringValue();
                monTmp.setKey((String)pairs.getKey());
                monTmp.setCategory(tmp.getCategory());
                monTmp.setIsSignificant(tmp.isSignificant());
                monTmp.setType(tmp.getType());
                monTmp.setValue(tmp.getValue());
            }
        }
    }

    private void handleTestSuites(Project xml, IProjectPO po) {
        List tsDescs = po.getTestSuiteAttributeDescriptions();
        for (ITestSuitePO ts : po.getTestSuiteCont().getTestSuiteList()) {
            this.checkForCancel();
            TestSuite xmlTs = xml.addNewTestsuite();
            this.fillTestsuite(xmlTs, ts);
            this.fillAttributes(xmlTs, (INodePO)ts, tsDescs);
        }
    }

    private void handleTestJobs(Project xml, IProjectPO po) {
        for (ITestJobPO tj : po.getTestJobCont().getTestJobList()) {
            this.checkForCancel();
            TestJobs xmlTj = xml.addNewTestJobs();
            this.fillNode(xmlTj, (INodePO)tj);
            this.fillTestJob(xmlTj, tj);
        }
    }

    private void fillTestJob(TestJobs xmlTj, ITestJobPO tj) {
        for (Object child : tj.getUnmodifiableNodeList()) {
            if (!(child instanceof IRefTestSuitePO)) continue;
            IRefTestSuitePO rts = (IRefTestSuitePO)child;
            RefTestSuite xmlRts = xmlTj.addNewRefTestSuite();
            this.fillNode(xmlRts, (INodePO)rts);
            xmlRts.setName(rts.getName());
            xmlRts.setGUID(rts.getGuid());
            xmlRts.setTsGuid(rts.getTestSuiteGuid());
            xmlRts.setAutId(rts.getTestSuiteAutID());
        }
    }

    private void handleReusedProjects(Project xml, IProjectPO po) {
        for (IReusedProjectPO reusedProject : po.getUsedProjects()) {
            this.checkForCancel();
            ReusedProject xmlReused = xml.addNewReusedProjects();
            this.fillReusedProject(xmlReused, reusedProject);
            this.m_monitor.worked(1);
        }
    }

    private void fillComponentNames(Project projXml, IProjectPO projPo) throws PMException {
        Collection allCompNamePOs = ComponentNamesBP.getInstance().getAllComponentNamePOs(projPo.getId());
        for (IComponentNamePO compName : allCompNamePOs) {
            ComponentName newXmlCompName = projXml.addNewComponentNames();
            newXmlCompName.setGUID(compName.getGuid());
            newXmlCompName.setCompType(compName.getComponentType());
            newXmlCompName.setCompName(compName.getName());
            newXmlCompName.setCreationContext(compName.getCreationContext().toString());
            newXmlCompName.setRefGuid(compName.getReferencedGuid());
            this.m_monitor.worked(1);
        }
    }

    private void fillUsedToolkits(Project xml, IProjectPO po) throws ProjectDeletedException, PMSaveException {
        UsedToolkitBP toolkitBP = UsedToolkitBP.getInstance();
        try {
            toolkitBP.refreshToolkitInfo(po);
        }
        catch (PMException e) {
            throw new PMSaveException(String.valueOf(Messages.DataBaseErrorUpdatingToolkits) + String.valueOf(po.getName()) + Messages.OriginalException + e.toString(), MessageIDs.E_FILE_IO);
        }
        Set toolkits = toolkitBP.getUsedToolkits();
        for (IUsedToolkitPO toolkit : toolkits) {
            UsedToolkit usedToolkit = xml.addNewUsedToolkit();
            this.fillUsedToolkit(usedToolkit, toolkit);
        }
    }

    private void fillAttributes(Node xml, INodePO po, List<IDocAttributeDescriptionPO> descList) {
        for (IDocAttributeDescriptionPO desc : descList) {
            IDocAttributePO attrPo = po.getDocAttribute(desc);
            if (attrPo == null) continue;
            Attribute attrXml = xml.addNewAttribute();
            this.fillAttribute(attrXml, attrPo, desc);
        }
    }

    private void fillAttribute(Attribute xml, IDocAttributePO po, IDocAttributeDescriptionPO description) {
        xml.setValue(po.getValue());
        xml.setType(description.getLabelKey());
        for (IDocAttributeDescriptionPO subDesc : po.getDocAttributeTypes()) {
            IDocAttributeListPO attrList = po.getDocAttributeList(subDesc);
            if (attrList == null) continue;
            for (IDocAttributePO subAttrPo : attrList.getAttributes()) {
                Attribute subAttrXml = xml.addNewSubAttribute();
                this.fillAttribute(subAttrXml, subAttrPo, subDesc);
            }
        }
    }

    private void fillUsedToolkit(UsedToolkit xml, IUsedToolkitPO usedToolkit) {
        xml.setName(usedToolkit.getToolkitId());
        xml.setMajorVersion(usedToolkit.getMajorVersion());
        xml.setMinorVersion(usedToolkit.getMinorVersion());
    }

    private void fillReusedProject(ReusedProject xml, IReusedProjectPO po) {
        xml.setProjectName(ProjectNameBP.getInstance().getName(po.getProjectGuid()));
        xml.setProjectGUID(po.getProjectGuid());
        xml.setMajorProjectVersion(po.getMajorNumber());
        xml.setMinorProjectVersion(po.getMinorNumber());
    }

    private void fillNode(Node xml, INodePO po) {
        this.checkForCancel();
        String name = po.getName();
        if (po instanceof IExecTestCasePO && (name = ((IExecTestCasePO)po).getRealName()) == null) {
            name = "";
        }
        xml.setName(po.getName());
        xml.setComment(po.getComment());
        xml.setGUID(po.getGuid());
        xml.setGenerated(po.isGenerated());
        xml.setActive(po.isActive());
        this.m_monitor.worked(1);
    }

    private void fillTestsuite(TestSuite xml, ITestSuitePO po) {
        this.fillNode(xml, (INodePO)po);
        this.checkForCancel();
        if (po.getAut() != null) {
            xml.setSelectedAut(this.i2id('A', po.getAut().getId()));
        } else {
            xml.setSelectedAut(null);
        }
        xml.setStepDelay(po.getStepDelay());
        xml.setCommandLineParameter(po.getCmdLineParameter());
        for (Object o : po.getUnmodifiableNodeList()) {
            if (!(o instanceof IExecTestCasePO)) continue;
            IExecTestCasePO tc = (IExecTestCasePO)o;
            RefTestCase xmlTc = xml.addNewUsedTestcase();
            this.fillRefTestCase(xmlTc, tc);
        }
        for (Object o : po.getDefaultEventHandler().keySet()) {
            String eventType = (String)o;
            Integer evProp = (Integer)po.getDefaultEventHandler().get(eventType);
            ReentryProperty.Enum reentryProperty = ReentryProperty.Enum.forInt(evProp);
            EventHandler xmlEvHandler = xml.addNewEventHandler();
            xmlEvHandler.setEvent(eventType);
            xmlEvHandler.setReentryProperty(reentryProperty);
            if (reentryProperty != ReentryProperty.RETRY) continue;
            xmlEvHandler.setMaxRetries(1);
        }
    }

    private void fillRefTestCase(RefTestCase xml, IExecTestCasePO po) {
        ITDManager dataManager;
        this.fillNode(xml, (INodePO)po);
        this.checkForCancel();
        String execName = po.getRealName();
        if (execName == null) {
            execName = "";
        }
        if (po.getSpecTestCase() != null) {
            String specName = po.getSpecTestCase().getName();
            if (execName.equals(specName)) {
                xml.setName(null);
            } else {
                xml.setName(execName);
            }
        } else {
            xml.setName(execName);
        }
        xml.setTestcaseGuid(po.getSpecTestCaseGuid());
        if (po.getProjectGuid() != null) {
            xml.setProjectGuid(po.getProjectGuid());
        } else if (po.getSpecTestCase() != null) {
            try {
                xml.setProjectGuid(ProjectPM.loadProjectById((Long)po.getSpecTestCase().getParentProjectId()).getGuid());
            }
            catch (JBException jBException) {}
        }
        xml.setHasOwnTestdata(!po.getHasReferencedTD());
        xml.setDatafile(po.getDataFile());
        if (po.getReferencedDataCube() != null) {
            xml.setReferencedTestData(po.getReferencedDataCube().getName());
        }
        if (!po.getHasReferencedTD() && (dataManager = po.getDataManager()) != null) {
            TestData xmlTD = xml.addNewTestdata();
            if (po.getReferencedDataCube() == null) {
                this.fillTestData(xmlTD, dataManager);
            }
        }
        for (ICompNamesPairPO name : po.getCompNamesPairs()) {
            CompNames xmlNames = xml.addNewOverriddenNames();
            xmlNames.setOriginalName(name.getFirstName());
            xmlNames.setNewName(name.getSecondName());
            xmlNames.setPropagated(name.isPropagated());
            xmlNames.setType(name.getType() == null ? "" : name.getType());
        }
    }

    private void fillEventTestCase(EventTestCase xml, IEventExecTestCasePO po) {
        Integer maxRetries;
        this.fillRefTestCase(xml, (IExecTestCasePO)po);
        xml.setEventType(po.getEventType());
        ReentryProperty.Enum reentryProperty = ReentryProperty.Enum.forInt(po.getReentryProp().getValue());
        xml.setReentryProperty(reentryProperty);
        if (reentryProperty == ReentryProperty.RETRY && (maxRetries = po.getMaxRetries()) != null) {
            xml.setMaxRetries(maxRetries);
        }
    }

    private void fillTestCase(TestCase xml, ISpecTestCasePO po) {
        ITDManager dataManager;
        this.fillNode(xml, (INodePO)po);
        this.checkForCancel();
        for (Object o : po.getUnmodifiableNodeList()) {
            TestCase.Teststep stepXml = xml.addNewTeststep();
            if (o instanceof ICapPO) {
                ICapPO capPO = (ICapPO)o;
                Cap xmlCap = stepXml.addNewCap();
                this.fillCap(xmlCap, capPO);
                continue;
            }
            if (!(o instanceof IExecTestCasePO)) continue;
            IExecTestCasePO tcPO = (IExecTestCasePO)o;
            RefTestCase xmlTC = stepXml.addNewUsedTestcase();
            this.fillRefTestCase(xmlTC, tcPO);
        }
        for (IParamDescriptionPO paramPO : po.getParameterList()) {
            ParamDescription xmlDescription = xml.addNewParameterDescription();
            this.fillParamDescription(xmlDescription, paramPO);
        }
        xml.setInterfaceLocked(po.isInterfaceLocked());
        xml.setDatafile(po.getDataFile());
        if (po.getReferencedDataCube() != null) {
            xml.setReferencedTestData(po.getReferencedDataCube().getName());
        }
        if ((dataManager = po.getDataManager()) != null) {
            TestData xmlTD = xml.addNewTestdata();
            if (po.getReferencedDataCube() == null) {
                this.fillTestData(xmlTD, dataManager);
            }
        }
        for (Object o : po.getEventExecTcMap().keySet()) {
            String eventType = (String)o;
            IEventExecTestCasePO evTc = po.getEventExecTC(eventType);
            EventTestCase xmlEvTc = xml.addNewEventTestcase();
            this.fillEventTestCase(xmlEvTc, evTc);
        }
    }

    private void fillCap(Cap xml, ICapPO po) {
        this.fillNode(xml, (INodePO)po);
        xml.setActionName(po.getActionName());
        xml.setComponentName(po.getComponentName());
        xml.setComponentType(po.getComponentType());
        xml.setDatafile(po.getDataFile());
        TestData xmlData = xml.addNewTestdata();
        this.fillTestData(xmlData, po.getDataManager());
        for (IParamDescriptionPO desc : po.getParameterList()) {
            ParamDescription xmlDescription = xml.addNewParameterDescription();
            this.fillParamDescription(xmlDescription, desc);
        }
    }

    private void fillParamDescription(ParamDescription xml, IParamDescriptionPO po) {
        if (po instanceof ICapParamDescriptionPO) {
            xml.setName(po.getUniqueId());
        } else {
            xml.setName(po.getName());
        }
        xml.setType(po.getType());
        xml.setUniqueId(po.getUniqueId());
    }

    private void fillNamedTestData(NamedTestData xml, IParameterInterfacePO po) {
        xml.setName(po.getName());
        for (IParamDescriptionPO paramDesc : po.getParameterList()) {
            ParamDescription xmlParamDesc = xml.addNewParameterDescription();
            this.fillParamDescription(xmlParamDesc, paramDesc);
        }
        TestData tdXml = xml.addNewTestData();
        if (po.getReferencedDataCube() == null) {
            this.fillTestData(tdXml, po.getDataManager());
        }
        xml.setTestData(tdXml);
    }

    private void fillTestData(TestData xml, ITDManager po) {
        for (String uniqueId : po.getUniqueIds()) {
            xml.addUniqueIds(uniqueId);
        }
        int rowCnt = 1;
        for (IDataSetPO row : po.getDataSets()) {
            TestDataRow xmlRow = xml.addNewRow();
            xmlRow.setRowCount(rowCnt++);
            int colCnt = 1;
            for (ITestDataPO td : row.getList()) {
                TestDataCell xmlCell = xmlRow.addNewData();
                xmlCell.setColumnCount(colCnt++);
                ArrayList sortedLanguageList = new ArrayList(td.getLanguages());
                Collections.sort(sortedLanguageList, LANG_CODE_ALPHA_COMPARATOR);
                for (Locale lang : sortedLanguageList) {
                    String val = td.getValue(lang);
                    I18NString xmlI18n = xmlCell.addNewData();
                    xmlI18n.setLanguage(lang.toString());
                    xmlI18n.setValue(val);
                }
            }
        }
    }

    private void fillCategory(Category xml, ICategoryPO po) {
        this.fillNode(xml, (INodePO)po);
        for (Object o : po.getUnmodifiableNodeList()) {
            this.checkForCancel();
            if (!(o instanceof ISpecPersistable)) continue;
            ISpecPersistable tcOrCat = (ISpecPersistable)o;
            if (tcOrCat instanceof ICategoryPO) {
                Category cat = xml.addNewCategory();
                this.fillCategory(cat, (ICategoryPO)tcOrCat);
                continue;
            }
            TestCase tc = xml.addNewTestcase();
            this.fillTestCase(tc, (ISpecTestCasePO)tcOrCat);
        }
    }

    private String i2str(Long l) {
        if (l == null) {
            return null;
        }
        return l.toString();
    }

    private void checkForCancel() throws OperationCanceledException {
        if (this.m_monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private String i2id(char table, Long l) {
        return "ID_" + table + "_" + this.i2str(l);
    }

    public int getPredictedWork(IProjectPO project) {
        int work = 0;
        ++work;
        ++work;
        ++work;
        work += project.getLangHelper().getLanguageList().size();
        try {
            Collection allComponentNamePOs = ComponentNamesBP.getInstance().getAllComponentNamePOs(project.getId());
            work += allComponentNamePOs.size();
        }
        catch (PMException pMException) {}
        work += project.getAutMainList().size();
        work = (int)((long)work + NodePM.getNumNodes((long)project.getId(), (EntityManager)GeneralStorage.getInstance().getMasterSession()));
        work += project.getUsedProjects().size();
        return ++work;
    }
}

