/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.archive.converter;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.client.archive.converter.AbstractXmlConverter;
import org.eclipse.jubula.client.archive.schema.Aut;
import org.eclipse.jubula.client.archive.schema.AutConfig;
import org.eclipse.jubula.client.archive.schema.MapEntry;
import org.eclipse.jubula.client.archive.schema.Project;

public class AutIdGenerationConverter
extends AbstractXmlConverter {
    protected boolean conversionIsNecessary(Project xml) {
        return true;
    }

    protected void convertImpl(Project xml) {
        for (Aut autXml : xml.getAutList()) {
            for (AutConfig configXml : autXml.getConfigList()) {
                if (this.containsAutId(configXml)) continue;
                String autIdValue = this.createUniqueAutId(xml, autXml.getName());
                MapEntry autIdEntryXml = configXml.addNewConfAttrMapEntry();
                autIdEntryXml.setKey("AUT_ID");
                autIdEntryXml.setValue(autIdValue);
            }
        }
    }

    private boolean containsAutId(AutConfig configXml) {
        for (MapEntry configEntryXml : configXml.getConfAttrMapEntryList()) {
            if (!"AUT_ID".equals(configEntryXml.getKey()) || !StringUtils.isNotEmpty((String)configEntryXml.getValue())) continue;
            return true;
        }
        return false;
    }

    private String createUniqueAutId(Project xml, String autName) {
        String autId = autName;
        int counter = 0;
        while (!this.isAutIdUnique(xml, autId)) {
            autId = String.valueOf(autName) + ++counter;
        }
        return autId;
    }

    private boolean isAutIdUnique(Project xml, String autId) {
        for (Aut autXml : xml.getAutList()) {
            for (AutConfig configXml : autXml.getConfigList()) {
                for (MapEntry configEntryXml : configXml.getConfAttrMapEntryList()) {
                    if (!"AUT_ID".equals(configEntryXml.getKey()) || !StringUtils.equals((String)autId, (String)configEntryXml.getValue())) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

