/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess;

import java.util.List;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.TestDataCubePM;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestDataCubeBP {
    private TestDataCubeBP() {
    }

    public static IParameterInterfacePO getTestDataCubeByName(String cubeName, IProjectPO containingProject) {
        Validate.notNull((Object)cubeName);
        Validate.notNull((Object)containingProject);
        for (IParameterInterfacePO testDataCube : containingProject.getTestDataCubeCont().getTestDataCubeList()) {
            if (!cubeName.equals(testDataCube.getName())) continue;
            return testDataCube;
        }
        return null;
    }

    public static boolean isCubeReused(IParameterInterfacePO pio) {
        GeneralStorage gs = GeneralStorage.getInstance();
        return TestDataCubePM.computeReuser(pio, gs.getMasterSession()).size() > 0;
    }

    public static List<IParamNodePO> getReuser(IParameterInterfacePO pio) {
        GeneralStorage gs = GeneralStorage.getInstance();
        IProjectPO proj = gs.getProject();
        return TestDataCubePM.computeParamNodeReuser(pio, gs.getMasterSession(), proj);
    }
}

