/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.Validate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jubula.client.core.ClientTestFactory;
import org.eclipse.jubula.client.core.MessageFactory;
import org.eclipse.jubula.client.core.agent.AutAgentRegistration;
import org.eclipse.jubula.client.core.agent.AutRegistrationEvent;
import org.eclipse.jubula.client.core.agent.IAutRegistrationListener;
import org.eclipse.jubula.client.core.businessprocess.CompNamesBP;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.businessprocess.ExternalTestDataBP;
import org.eclipse.jubula.client.core.businessprocess.ITestExecutionEventListener;
import org.eclipse.jubula.client.core.businessprocess.ObjectMappingEventDispatcher;
import org.eclipse.jubula.client.core.businessprocess.TDVariableStore;
import org.eclipse.jubula.client.core.businessprocess.TestExecutionEvent;
import org.eclipse.jubula.client.core.businessprocess.TestResultBP;
import org.eclipse.jubula.client.core.commands.CAPTestResponseCommand;
import org.eclipse.jubula.client.core.commands.DisplayManualTestStepResponseCommand;
import org.eclipse.jubula.client.core.commands.EndTestExecutionResponseCommand;
import org.eclipse.jubula.client.core.commands.TakeScreenshotResponseCommand;
import org.eclipse.jubula.client.core.communication.AUTConnection;
import org.eclipse.jubula.client.core.communication.BaseConnection;
import org.eclipse.jubula.client.core.communication.ConnectionException;
import org.eclipse.jubula.client.core.communication.ServerConnection;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IAUTConfigPO;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.IEventStackModificationListener;
import org.eclipse.jubula.client.core.model.IExecStackModificationListener;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IObjectMappingPO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.ITDManager;
import org.eclipse.jubula.client.core.model.ITestDataPO;
import org.eclipse.jubula.client.core.model.ITestJobPO;
import org.eclipse.jubula.client.core.model.ITestResultSummary;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.LogicComponentNotManagedException;
import org.eclipse.jubula.client.core.model.ReentryProperty;
import org.eclipse.jubula.client.core.model.ResultTreeBuilder;
import org.eclipse.jubula.client.core.model.ResultTreeTracker;
import org.eclipse.jubula.client.core.model.TestResult;
import org.eclipse.jubula.client.core.model.TestResultNode;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.core.utils.ExecObject;
import org.eclipse.jubula.client.core.utils.ModelParamValueConverter;
import org.eclipse.jubula.client.core.utils.Traverser;
import org.eclipse.jubula.communication.message.ActivateApplicationMessage;
import org.eclipse.jubula.communication.message.CAPTestMessage;
import org.eclipse.jubula.communication.message.CAPTestResponseMessage;
import org.eclipse.jubula.communication.message.DisplayManualTestStepMessage;
import org.eclipse.jubula.communication.message.EndTestExecutionMessage;
import org.eclipse.jubula.communication.message.InitTestExecutionMessage;
import org.eclipse.jubula.communication.message.Message;
import org.eclipse.jubula.communication.message.MessageCap;
import org.eclipse.jubula.communication.message.MessageParam;
import org.eclipse.jubula.communication.message.NullMessage;
import org.eclipse.jubula.communication.message.ResetMonitoringDataMessage;
import org.eclipse.jubula.communication.message.RestartAutMessage;
import org.eclipse.jubula.communication.message.TakeScreenshotMessage;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.exception.CommunicationException;
import org.eclipse.jubula.tools.exception.InvalidDataException;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.objects.IComponentIdentifier;
import org.eclipse.jubula.tools.objects.event.EventFactory;
import org.eclipse.jubula.tools.objects.event.TestErrorEvent;
import org.eclipse.jubula.tools.registration.AutIdentifier;
import org.eclipse.jubula.tools.utils.ExternalCommandExecutor;
import org.eclipse.jubula.tools.utils.StringParsing;
import org.eclipse.jubula.tools.utils.TimeUtil;
import org.eclipse.jubula.tools.xml.businessmodell.Action;
import org.eclipse.jubula.tools.xml.businessmodell.CompSystem;
import org.eclipse.jubula.tools.xml.businessmodell.Component;
import org.eclipse.jubula.tools.xml.businessmodell.Param;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestExecution {
    private static final Logger LOG = LoggerFactory.getLogger(TestExecution.class);
    private static final String LAST_ACTION_RETURN = "GD_LAR";
    private static final String CURRENT_DATASET_NUMBER = "GD_CDN";
    private static TestExecution instance = null;
    private int m_requestTimeout = 600000;
    private int m_stepSpeed = 0;
    private boolean m_paused = false;
    private boolean m_skipError = false;
    private boolean m_stopped = false;
    private boolean m_autoScreenshot = true;
    private ITestJobPO m_startedTestJob;
    private ITestSuitePO m_startedTestSuite;
    private ICapPO m_currentCap;
    private Locale m_executionLanguage;
    private Traverser m_trav;
    private StepCounter m_stepCounter;
    private ResultTreeTracker m_resultTreeTracker;
    private CompNamesBP m_compNamesBP = new CompNamesBP();
    private ExternalTestDataBP m_externalTestDataBP;
    private PostExecCommandFactory m_postExecCmdFactory;
    private TDVariableStore m_varStore = new TDVariableStore();
    private Map<String, Long> m_timerStore;
    private int m_expectedNumberOfSteps;

    private TestExecution() {
        this.m_postExecCmdFactory = new PostExecCommandFactory();
        this.setTimerStore(new HashMap<String, Long>());
        this.m_externalTestDataBP = new ExternalTestDataBP();
        ClientTestFactory.getClientTest().addTestExecutionEventListener(new ITestExecutionEventListener(){

            public void endTestExecution() {
                TestExecution.this.m_externalTestDataBP.clearExternalData();
            }

            public void stateChanged(TestExecutionEvent event) {
            }
        });
    }

    public static synchronized TestExecution getInstance() {
        if (instance == null) {
            instance = new TestExecution();
        }
        return instance;
    }

    public void executeTestSuite(ITestSuitePO testSuite, Locale locale, AutIdentifier autId, boolean autoScreenshot, Map<String, String> externalVars, ITestResultSummary summary, IProgressMonitor monitor) {
        this.m_stopped = false;
        this.m_autoScreenshot = autoScreenshot;
        this.setPaused(false);
        Validate.notNull((Object)testSuite, (String)Messages.TestsuiteMustNotBeNull);
        this.m_executionLanguage = locale;
        this.m_externalTestDataBP.clearExternalData();
        try {
            if (AUTConnection.getInstance().connectToAut(autId, (IProgressMonitor)new SubProgressMonitor(monitor, 0))) {
                summary.setAutHostname(AUTConnection.getInstance().getCommunicator().getConnection().getAddress().getCanonicalHostName());
                summary.setAutAgentName(ServerConnection.getInstance().getCommunicator().getHostName());
                monitor.subTask(Messages.StartingTestSuite_resolvingPredefinedVariables);
                this.m_varStore.storeEnvironmentVariables();
                this.storePredefinedVariables(this.m_varStore, testSuite);
                this.storeExternallyDefinedVariables(this.m_varStore, externalVars);
                this.startTestSuite(testSuite, locale, monitor);
                final AtomicBoolean testSuiteFinished = new AtomicBoolean();
                ClientTestFactory.getClientTest().addTestExecutionEventListener(new ITestExecutionEventListener(){

                    public void endTestExecution() {
                        try {
                            AUTConnection.getInstance().close();
                        }
                        catch (ConnectionException connectionException) {}
                        ClientTestFactory.getClientTest().removeTestExecutionEventListener(this);
                        testSuiteFinished.set(true);
                    }

                    public void stateChanged(TestExecutionEvent event) {
                    }
                });
                while (!testSuiteFinished.get()) {
                    TimeUtil.delay((long)250L);
                }
            } else {
                this.handleNoConnectionToAUT(testSuite, autId);
            }
        }
        catch (ConnectionException e) {
            LOG.error(String.valueOf(Messages.UnableToConnectToAUT) + ".", (Throwable)((Object)e));
        }
    }

    private void storeExternallyDefinedVariables(TDVariableStore varStore, Map<String, String> externalVars) {
        if (externalVars != null) {
            for (String key : externalVars.keySet()) {
                varStore.store(key, externalVars.get(key));
            }
        }
    }

    private void handleNoConnectionToAUT(ITestSuitePO testSuite, AutIdentifier autId) {
        String autName = autId.getExecutableName();
        if (TestExecution.isAutNameSet(autName)) {
            autName = NLS.bind((String)Messages.ErrorDetailNO_AUT_ID_FOR_REF_TS_FOUND, (Object)testSuite.getName());
        }
        ClientTestFactory.getClientTest().fireTestExecutionChanged(new TestExecutionEvent(3, (Exception)((Object)new JBException(String.valueOf(Messages.CouldNotConnectToAUT) + ":" + " " + autName, MessageIDs.E_NO_AUT_CONNECTION_ERROR))));
    }

    public static boolean isAutNameSet(String autName) {
        return String.valueOf(autName).equals("null");
    }

    private void storePredefinedVariables(TDVariableStore varStore, ITestSuitePO testSuite) {
        varStore.store("TEST_LANGUAGE", this.m_executionLanguage.toString());
        varStore.store("TEST_TESTSUITE", testSuite.getName());
        varStore.store("TEST_USERNAME", System.getProperty("user.name"));
        varStore.store("TEST_DBUSERNAME", Persistor.instance().getCurrentDBUser());
        try {
            ServerConnection serverConn = ServerConnection.getInstance();
            varStore.store("TEST_AUTAGENT", serverConn.getCommunicator().getHostName());
            varStore.store("TEST_PORTNUMBER", String.valueOf(serverConn.getCommunicator().getPort()));
        }
        catch (ConnectionException connectionException) {}
        varStore.store("TEST_AUT", testSuite.getAut().getName());
        Map<String, String> autConfigMap = this.getConnectedAUTsConfigMap();
        if (autConfigMap != null) {
            varStore.store("TEST_AUTCONFIG", MapUtils.getString(autConfigMap, (Object)"CONFIG_NAME", (String)"autrun"));
        } else {
            varStore.store("TEST_AUTCONFIG", "autrun");
        }
        varStore.store("TEST_CLIENTVERSION", (String)Platform.getBundle((String)"org.eclipse.jubula.client.core").getHeaders().get("Bundle-Version"));
    }

    protected Map<String, String> getConnectedAUTsConfigMap() {
        if (TestExecution.getInstance().getConnectedAutId() != null) {
            String autID = this.getConnectedAutId().getExecutableName();
            return ClientTestFactory.getClientTest().requestAutConfigMapFromAgent(autID);
        }
        return null;
    }

    private void startTestSuite(ITestSuitePO testSuite, Locale locale, IProgressMonitor monitor) {
        Validate.notNull((Object)testSuite, (String)"No testsuite available");
        ICapPO firstCap = null;
        this.m_expectedNumberOfSteps = 0;
        this.m_trav = new Traverser(testSuite, locale);
        try {
            monitor.subTask(Messages.StartingTestSuite_resolvingTestStepsToExecute);
            Traverser copier = new Traverser(testSuite, locale);
            ResultTreeBuilder resultTreeBuilder = new ResultTreeBuilder(copier);
            copier.addExecStackModificationListener(resultTreeBuilder);
            ICapPO iterNode = copier.next();
            while (iterNode != null) {
                iterNode = copier.next();
                ++this.m_expectedNumberOfSteps;
            }
            Map<String, String> autConfigMap = this.getConnectedAUTsConfigMap();
            this.resetMonitoringData(autConfigMap, monitor);
            TestResultBP.getInstance().setResultTestModel(new TestResult(resultTreeBuilder.getRootNode(), autConfigMap));
            this.initTestExecutionMessage(autConfigMap, monitor);
            this.m_resultTreeTracker = new ResultTreeTracker(resultTreeBuilder.getRootNode(), this.m_externalTestDataBP);
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1000);
            subMonitor.beginTask(Messages.ExecutingTestSuite, this.m_expectedNumberOfSteps);
            this.m_stepCounter = new StepCounter((IProgressMonitor)subMonitor);
            this.addTestExecutionListener();
            ClientTestFactory.getClientTest().fireTestExecutionChanged(new TestExecutionEvent(6));
            monitor.subTask(testSuite.getName());
            firstCap = this.m_trav.next();
        }
        catch (JBException e) {
            LOG.error(Messages.IncompleteTestdata, (Throwable)e);
            this.fireError((Exception)((Object)e));
        }
        if (firstCap != null) {
            ClientTestFactory.getClientTest().fireTestExecutionChanged(new TestExecutionEvent(1));
            this.processCap(firstCap);
        } else {
            this.endTestExecution();
        }
    }

    private void addTestExecutionListener() {
        this.m_trav.addExecStackModificationListener(this.m_resultTreeTracker);
        this.m_trav.addEventStackModificationListener(this.m_stepCounter);
        this.m_trav.addExecStackModificationListener(this.m_stepCounter);
    }

    private void processCap(ICapPO cap) {
        ICapPO currCap = cap;
        MessageCap messageCap = null;
        if (currCap == null) {
            this.endTestExecution();
            return;
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.valueOf(Messages.TestStep) + ":" + " " + currCap.getName());
                LOG.debug(String.valueOf(Messages.Component) + ":" + " " + currCap.getComponentName());
            }
            messageCap = this.buildMessageCap(currCap, false);
            if (!this.m_stopped) {
                CAPTestMessage capTestMessage = MessageFactory.getCAPTestMessage(messageCap);
                TimeUtil.delay((long)this.m_stepSpeed);
                while (this.isPaused()) {
                    this.testConnection();
                    TimeUtil.delay((long)100L);
                }
                if (!this.m_stopped) {
                    CAPTestResponseMessage clientResponse = this.clientExecutionHandling(currCap, capTestMessage);
                    if (!this.m_stopped) {
                        if (clientResponse != null) {
                            CAPTestResponseCommand responseCommand = new CAPTestResponseCommand();
                            responseCommand.setMessage((Message)clientResponse);
                            responseCommand.setMessageCap(messageCap);
                            responseCommand.execute();
                        } else {
                            int timeOut = this.calculateRequestTimeout(messageCap);
                            AUTConnection.getInstance().request((Message)capTestMessage, new CAPTestResponseCommand(), timeOut);
                        }
                    }
                } else {
                    this.endTestExecution();
                }
            }
        }
        catch (BaseConnection.NotConnectedException bnce) {
            LOG.error(Messages.AUTConnectionFails, (Throwable)((Object)bnce));
        }
        catch (CommunicationException bce) {
            LOG.error(Messages.CommunicationWithAUTFails, (Throwable)bce);
            this.fireError((Exception)((Object)bce));
        }
        catch (LogicComponentNotManagedException blcnme) {
            LOG.error(blcnme.getMessage(), (Throwable)((Object)blcnme));
            this.fireComponentError();
        }
        catch (InvalidDataException invalidDataException) {}
    }

    private int calculateRequestTimeout(MessageCap messageCap) {
        int showTextTimeout;
        ArrayList<Integer> timeOuts = new ArrayList<Integer>();
        IParamDescriptionPO desc1 = this.m_currentCap.getParameterForUniqueId("CompSystem.Timeout");
        timeOuts.add(this.m_currentCap.getParameterList().indexOf(desc1));
        desc1 = this.m_currentCap.getParameterForUniqueId("CompSystem.TimeMillSec");
        timeOuts.add(this.m_currentCap.getParameterList().indexOf(desc1));
        int timeout = 0;
        Iterator iterator = timeOuts.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            if (index <= -1) continue;
            MessageParam param = (MessageParam)messageCap.getMessageParams().get(index);
            String paramTimeOut = param.getValue();
            timeout += Integer.parseInt(paramTimeOut);
        }
        boolean isShowText = messageCap.getMethod().equals("gdShowText");
        if (isShowText && (showTextTimeout = this.calculateShowTextTimeout(messageCap)) != -1) {
            timeout += showTextTimeout;
        }
        return this.m_requestTimeout + timeout;
    }

    private CAPTestResponseMessage clientExecutionHandling(ICapPO cap, CAPTestMessage capTestMessage) {
        Action action = cap.getMetaAction();
        if (!action.isClientAction()) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.valueOf(Messages.ExecutingClientAction) + ":" + " " + action.getPostExecutionCommand());
        }
        String postExecCommandClass = action.getPostExecutionCommand();
        IPostExecutionCommand command = this.m_postExecCmdFactory.createCommand(postExecCommandClass);
        try {
            TestErrorEvent errorEvent = command.execute();
            if (errorEvent != null) {
                CAPTestResponseMessage response = new CAPTestResponseMessage();
                response.setTestErrorEvent(errorEvent);
                response.setMessageCap(capTestMessage.getMessageCap());
                return response;
            }
        }
        catch (JBException jBException) {}
        return null;
    }

    private int calculateShowTextTimeout(MessageCap messageCap) {
        MessageParam textParam = (MessageParam)messageCap.getMessageParams().get(0);
        MessageParam timePerWordParam = (MessageParam)messageCap.getMessageParams().get(2);
        try {
            int numWords = StringParsing.countWords((String)textParam.getValue());
            return Integer.parseInt(timePerWordParam.getValue()) * numWords;
        }
        catch (NumberFormatException e) {
            LOG.warn(String.valueOf(Messages.ErrorParsingTimeoutParameter) + "." + " " + Messages.UsingDefaultValue + ".", (Throwable)e);
            return -1;
        }
    }

    private MessageCap buildMessageCap(ICapPO cap, boolean runIncomplete) throws InvalidDataException, LogicComponentNotManagedException {
        String logicalName = null;
        try {
            IComponentIdentifier technicalName;
            MessageCap messageCap = new MessageCap();
            CompSystem compSystem = ComponentBuilder.getInstance().getCompSystem();
            this.m_currentCap = cap;
            ITestSuitePO ts = (ITestSuitePO)this.m_trav.getRoot();
            IAUTMainPO aut = ts.getAut();
            IObjectMappingPO om = aut.getObjMap();
            IObjectMappingPO transientOm = ObjectMappingEventDispatcher.getObjMapTransient();
            logicalName = this.m_compNamesBP.findCompName(this.m_trav.getExecStackAsNodeList(), cap, cap.getComponentName(), ComponentNamesBP.getInstance()).getCompName();
            messageCap.setResolvedLogicalName(logicalName);
            try {
                technicalName = transientOm.getTechnicalName(logicalName);
            }
            catch (LogicComponentNotManagedException logicComponentNotManagedException) {
                technicalName = om.getTechnicalName(logicalName);
            }
            if (technicalName == null) {
                throw new LogicComponentNotManagedException("", MessageIDs.E_COMPONENT_NOT_MANAGED);
            }
            Component comp = compSystem.findComponent(cap.getComponentType());
            Action action = comp.findAction(cap.getActionName());
            messageCap.setMethod(action.getMethod());
            messageCap.setPostExecutionCommand(action.getPostExecutionCommand());
            messageCap.setCi(technicalName);
            if (cap.getParameterList() != null) {
                messageCap = this.configureMessageCap(cap, messageCap, action, runIncomplete);
            }
            return messageCap;
        }
        catch (LogicComponentNotManagedException blcnme) {
            StringBuilder msg = new StringBuilder();
            msg.append(Messages.NoEntryFor);
            msg.append(" ");
            msg.append(cap.getComponentName());
            msg.append("(");
            msg.append("=");
            msg.append(Messages.ProfessionalName);
            msg.append(")");
            msg.append(" ");
            msg.append("/");
            msg.append(" ");
            msg.append("(");
            msg.append("=");
            msg.append(Messages.TechnicalName);
            msg.append(")");
            LOG.error(msg.toString(), (Throwable)((Object)blcnme));
            throw blcnme;
        }
        catch (InvalidDataException e) {
            if (runIncomplete) {
                throw e;
            }
            return null;
        }
    }

    private MessageCap configureMessageCap(ICapPO cap, MessageCap messageCap, Action action, boolean runIncomplete) throws InvalidDataException {
        ITDManager tdManager = null;
        try {
            tdManager = this.m_externalTestDataBP.getExternalCheckedTDManager(cap);
        }
        catch (JBException gde) {
            this.fireError((Exception)((Object)gde));
        }
        if (tdManager != null) {
            for (IParamDescriptionPO desc : cap.getParameterList()) {
                if (this.m_stopped) {
                    return messageCap;
                }
                MessageParam messageParam = this.createMessageParam(desc, action);
                messageCap.addMessageParam(messageParam);
                ITestDataPO date = tdManager.getCell(0, desc);
                StringBuilder msg = new StringBuilder();
                msg.append(Messages.NoTestdataAvailableForCAP);
                msg.append(":");
                msg.append(" ");
                msg.append(cap.getName());
                msg.append(",");
                msg.append(" ");
                msg.append(Messages.Parameter);
                msg.append(":");
                msg.append(" ");
                msg.append(desc.getName());
                msg.append(",");
                msg.append(" ");
                msg.append(Messages.AndDatasetNumberZero);
                Validate.notNull((Object)date, (String)msg.toString());
                String value = null;
                try {
                    int dsNumber = this.m_trav.getDataSetNumber();
                    this.m_varStore.store(CURRENT_DATASET_NUMBER, String.valueOf(dsNumber + 1));
                    ModelParamValueConverter conv = new ModelParamValueConverter(date.getValue(this.getLocale()), (IParameterInterfacePO)cap, this.getLocale(), desc);
                    ArrayList<ExecObject> stackList = new ArrayList<ExecObject>(this.m_trav.getExecStackAsList());
                    value = conv.getExecutionString(stackList, this.getLocale());
                }
                catch (InvalidDataException e) {
                    if (!runIncomplete) {
                        StringBuilder msgbuild = new StringBuilder();
                        msgbuild.append(Messages.NoValueAvailableForParameter);
                        msgbuild.append(":");
                        msgbuild.append(" ");
                        msgbuild.append(desc.getName());
                        msgbuild.append(" ");
                        msgbuild.append(Messages.InNode);
                        msgbuild.append(":");
                        msgbuild.append(" ");
                        msgbuild.append(cap.getName());
                        LOG.error(msgbuild.toString(), (Throwable)e);
                        this.fireError((Exception)((Object)e));
                    }
                    throw e;
                }
                messageParam.setValue(value);
            }
        }
        return messageCap;
    }

    private MessageParam createMessageParam(IParamDescriptionPO desc, Action action) {
        Param xmlParam = action.findParam(desc.getUniqueId());
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.valueOf(Messages.Param) + ":" + " " + xmlParam.getName());
        }
        MessageParam messageParam = new MessageParam();
        messageParam.setType(xmlParam.getType());
        return messageParam;
    }

    public void processServerResponse(final CAPTestResponseMessage msg) {
        Thread t = new Thread("Execute Test Step"){

            public void run() {
                boolean testOk;
                ICapPO nextCap = null;
                TestExecution.this.processPostExecution(msg);
                TestResultNode resultNode = TestExecution.this.m_resultTreeTracker.getEndNode();
                MessageCap mc = msg.getMessageCap();
                resultNode.setComponentName(ComponentNamesBP.getInstance().getName(mc.getResolvedLogicalName(), GeneralStorage.getInstance().getProject().getId()));
                IComponentIdentifier ci = mc.getCi();
                resultNode.setOmHeuristicEquivalence(ci.getMatchPercentage());
                resultNode.setNoOfSimilarComponents(ci.getNumberOfOtherMatchingComponents());
                boolean bl = testOk = !msg.hasTestErrorEvent();
                if (msg.getState() == 31) {
                    TestExecution.this.pauseExecution(PauseMode.PAUSE);
                }
                if (testOk) {
                    resultNode.setResult(TestExecution.this.m_trav.getSuccessResult(), null);
                } else {
                    TestErrorEvent event = msg.getTestErrorEvent();
                    if (TestExecution.this.m_trav.getEventHandlerReentry(event.getId()).equals(ReentryProperty.RETRY)) {
                        resultNode.setResult(7, event);
                    } else {
                        TestExecution.this.m_stepCounter.incrementNumberOfFailedSteps();
                        resultNode.setResult(2, event);
                        if (TestExecution.this.m_autoScreenshot) {
                            TestExecution.this.addScreenshot(resultNode);
                        }
                        if (ClientTestFactory.getClientTest().isPauseTestExecutionOnError()) {
                            TestExecution.this.pauseExecution(PauseMode.PAUSE);
                        }
                    }
                }
                while (TestExecution.this.isPaused()) {
                    TestExecution.this.testConnection();
                    TimeUtil.delay((long)100L);
                }
                if (!TestExecution.this.m_stopped) {
                    try {
                        nextCap = testOk || TestExecution.this.m_skipError ? TestExecution.this.m_trav.next() : TestExecution.this.m_trav.next(msg.getTestErrorEvent().getId());
                        TestExecution.this.m_skipError = false;
                    }
                    catch (JBException e) {
                        LOG.error(Messages.IncompleteTestdata, (Throwable)e);
                        TestExecution.this.fireError((Exception)((Object)e));
                    }
                    if (nextCap != null) {
                        TestExecution.this.processCap(nextCap);
                    } else {
                        if (LOG.isInfoEnabled()) {
                            LOG.info(Messages.TestsuiteFinished);
                        }
                        TestExecution.this.endTestExecution();
                    }
                }
            }
        };
        t.start();
    }

    private void addScreenshot(TestResultNode resultNode) {
        block4: {
            TakeScreenshotResponseCommand command = new TakeScreenshotResponseCommand(resultNode);
            TakeScreenshotMessage message = new TakeScreenshotMessage();
            try {
                AUTConnection.getInstance().request((Message)message, command, 10000);
            }
            catch (BaseConnection.NotConnectedException nce) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("An error occured: ", (Throwable)((Object)nce));
                }
            }
            catch (CommunicationException ce) {
                if (!LOG.isErrorEnabled()) break block4;
                LOG.error("An error occured: ", (Throwable)ce);
            }
        }
    }

    private void processPostExecution(CAPTestResponseMessage msg) {
        this.m_varStore.store(LAST_ACTION_RETURN, msg.getReturnValue());
        String cmdClassName = msg.getMessageCap().getPostExecutionCommand();
        if (cmdClassName != null && cmdClassName.length() > 0 && !this.m_currentCap.getMetaAction().isClientAction()) {
            TestErrorEvent errorEvent = this.executePostExecCommand(cmdClassName);
            if (msg.getTestErrorEvent() == null && errorEvent != null) {
                msg.setTestErrorEvent(errorEvent);
            }
        }
    }

    private TestErrorEvent executePostExecCommand(String cmdClassName) {
        IPostExecutionCommand cmd = this.m_postExecCmdFactory.createCommand(cmdClassName);
        try {
            return cmd.execute();
        }
        catch (JBException e) {
            StringBuilder msg = new StringBuilder();
            msg.append(Messages.ErrorExecutingCommand);
            msg.append(":");
            msg.append(" ");
            msg.append(cmdClassName);
            msg.append(" ");
            msg.append(".");
            msg.append(" ");
            msg.append(Messages.Exception);
            msg.append(":");
            msg.append(" ");
            msg.append(String.valueOf((Object)e));
            LOG.error(msg.toString());
            this.fireError((Exception)((Object)e));
            return null;
        }
    }

    protected void testConnection() {
        try {
            AUTConnection.getInstance().send((Message)new NullMessage());
        }
        catch (CommunicationException communicationException) {
            this.fireError((Exception)((Object)new JBException(MessageIDs.getMessage((Integer)MessageIDs.E_INTERRUPTED_CONNECTION), MessageIDs.E_INTERRUPTED_CONNECTION)));
        }
    }

    private void initTestExecutionMessage(Map<String, String> autConfigMap, IProgressMonitor monitor) {
        try {
            InitTestExecutionMessage msg = new InitTestExecutionMessage();
            if (autConfigMap != null) {
                monitor.subTask(Messages.StartingTestSuite_activatingAUT);
                msg.setDefaultActivationMethod(IAUTConfigPO.ActivationMethod.getRCString(autConfigMap.get("ACTIVATION_METHOD")));
                AUTConnection.getInstance().send((Message)msg);
            }
        }
        catch (CommunicationException exc) {
            this.fireError((Exception)((Object)exc));
        }
    }

    private void sendActivateAUTMessage() {
        try {
            ActivateApplicationMessage msg = MessageFactory.getActivateApplicationMessage();
            AUTConnection.getInstance().send((Message)msg);
        }
        catch (CommunicationException exc) {
            this.fireError((Exception)((Object)exc));
        }
    }

    private void fireError(Exception e) {
        ClientTestFactory.getClientTest().fireTestExecutionChanged(new TestExecutionEvent(3, e));
        this.endTestExecution();
    }

    private void fireComponentError() {
        ClientTestFactory.getClientTest().fireTestExecutionChanged(new TestExecutionEvent(8));
        ClientTestFactory.getClientTest().fireEndTestExecution();
    }

    public void setStepSpeed(int stepSpeed) {
        this.m_stepSpeed = stepSpeed > 0 ? stepSpeed : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopExecution() {
        TestExecution testExecution = this;
        synchronized (testExecution) {
            if (!this.m_stopped) {
                this.m_stopped = true;
                this.setPaused(false);
                this.m_timerStore.clear();
                try {
                    AUTConnection.getInstance().getCommunicator().interruptAllTimeouts();
                }
                catch (ConnectionException e) {
                    this.fireError((Exception)((Object)e));
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info(Messages.TestsuiteIsStopped);
                }
                ClientTestFactory.getClientTest().fireEndTestExecution();
                try {
                    AUTConnection.getInstance().close();
                }
                catch (ConnectionException connectionException) {}
            }
        }
    }

    private void resetMonitoringData(Map<String, String> autConfigMap, IProgressMonitor monitor) {
        boolean reset;
        String resetString;
        if (autConfigMap != null && (resetString = autConfigMap.get("RESET_AGENT")) != null && (reset = Boolean.valueOf(resetString).booleanValue())) {
            try {
                monitor.subTask(Messages.StartingTestSuite_resettingMonitoringData);
                ResetMonitoringDataMessage message = new ResetMonitoringDataMessage(AUTConnection.getInstance().getConnectedAutId().getExecutableName());
                ServerConnection.getInstance().send((Message)message);
            }
            catch (BaseConnection.NotConnectedException nce) {
                LOG.error("An error occured: ", (Throwable)((Object)nce));
            }
            catch (CommunicationException ce) {
                LOG.error("An error occured: ", (Throwable)ce);
            }
        }
    }

    public void endTestExecution() {
        EndTestExecutionResponseCommand command = new EndTestExecutionResponseCommand();
        EndTestExecutionMessage message = new EndTestExecutionMessage();
        try {
            AUTConnection.getInstance().request((Message)message, command, 10000);
        }
        catch (BaseConnection.NotConnectedException nce) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("An error occured: ", (Throwable)((Object)nce));
            }
            this.stopExecution();
        }
        catch (CommunicationException ce) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("An error occured: ", (Throwable)ce);
            }
            this.stopExecution();
        }
    }

    public void pauseExecution(PauseMode pm) {
        switch (pm) {
            case PAUSE: {
                if (this.isPaused()) break;
                this.pauseExecution(PauseMode.TOGGLE);
                break;
            }
            case UNPAUSE: {
                if (!this.isPaused()) break;
                this.pauseExecution(PauseMode.TOGGLE);
                break;
            }
            case TOGGLE: {
                String activateAUT;
                Map<String, String> autConfigMap;
                this.setPaused(!this.isPaused());
                if (this.isPaused()) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info(Messages.TestsuiteIsPaused);
                    }
                    ClientTestFactory.getClientTest().fireTestExecutionChanged(new TestExecutionEvent(9));
                    break;
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info(Messages.TestexecutionHasResumed);
                }
                if ((autConfigMap = this.getConnectedAUTsConfigMap()) != null && (activateAUT = autConfigMap.get("ACTIVATE_APPLICATION")) != null && Boolean.valueOf(activateAUT).booleanValue()) {
                    this.sendActivateAUTMessage();
                }
                ClientTestFactory.getClientTest().fireTestExecutionChanged(new TestExecutionEvent(1));
                break;
            }
            case CONTINUE_WITHOUT_EH: {
                this.m_skipError = true;
                this.pauseExecution(PauseMode.UNPAUSE);
                break;
            }
        }
    }

    public void timeout() {
        this.m_resultTreeTracker.getEndNode().setResult(9, null);
        this.fireError((Exception)((Object)new JBException(MessageIDs.getMessage((Integer)MessageIDs.E_TIMEOUT_CONNECTION), MessageIDs.E_TIMEOUT_CONNECTION)));
    }

    public ICapPO getActualCap() {
        return this.m_currentCap;
    }

    public Locale getLocale() {
        return this.m_executionLanguage;
    }

    public Traverser getTrav() {
        return this.m_trav;
    }

    protected boolean isPaused() {
        return this.m_paused;
    }

    public AutIdentifier getConnectedAutId() {
        try {
            return AUTConnection.getInstance().getConnectedAutId();
        }
        catch (ConnectionException connectionException) {
            return null;
        }
    }

    public IAUTMainPO getConnectedAut() {
        return AutAgentRegistration.getAutForId(this.getConnectedAutId(), GeneralStorage.getInstance().getProject());
    }

    public ITestSuitePO getStartedTestSuite() {
        return this.m_startedTestSuite;
    }

    public ITestJobPO getStartedTestJob() {
        return this.m_startedTestJob;
    }

    public void setStartedTestJob(ITestJobPO startedTestJob) {
        this.m_startedTestJob = startedTestJob;
    }

    public void setStartedTestSuite(ITestSuitePO startedTestSuite) {
        this.m_startedTestSuite = startedTestSuite;
    }

    public TDVariableStore getVariableStore() {
        return this.m_varStore;
    }

    public int getNumberOfTestedSteps() {
        return this.m_stepCounter.getTotalSteps();
    }

    public int getExpectedNumberOfSteps() {
        return this.m_expectedNumberOfSteps;
    }

    public int getNumberOfEventHandlerSteps() {
        return this.m_stepCounter.getEventHandlerSteps();
    }

    public int getNumberOfRetriedSteps() {
        return this.m_stepCounter.getRetriedSteps();
    }

    public int getNumberOfFailedSteps() {
        return this.m_stepCounter.getFailedSteps();
    }

    public void setTimerStore(Map<String, Long> timerStore) {
        this.m_timerStore = timerStore;
    }

    public Map<String, Long> getTimerStore() {
        return this.m_timerStore;
    }

    private void setPaused(boolean paused) {
        this.m_paused = paused;
    }

    public abstract class AbstractPostExecutionCommand
    implements IPostExecutionCommand {
        private AbstractPostExecutionCommand() {
        }

        protected String getValueForParam(ITestDataPO date, ICapPO cap, IParamDescriptionPO desc) throws InvalidDataException {
            String value = "";
            ModelParamValueConverter conv = new ModelParamValueConverter(date.getValue(TestExecution.this.getLocale()), (IParameterInterfacePO)cap, TestExecution.this.getLocale(), desc);
            try {
                ArrayList<ExecObject> stackList = new ArrayList<ExecObject>(TestExecution.this.m_trav.getExecStackAsList());
                value = conv.getExecutionString(stackList, TestExecution.this.getLocale());
            }
            catch (InvalidDataException invalidDataException) {
                throw new InvalidDataException(String.valueOf(Messages.NeitherValueNorReferenceForNode) + ":" + " " + cap.getName(), MessageIDs.E_NO_REFERENCE);
            }
            return value;
        }

        protected String getValueForParam(String paramID) throws JBException {
            IParamDescriptionPO desc = TestExecution.this.m_currentCap.getParameterForUniqueId(paramID);
            ITDManager tdManager = TestExecution.this.m_externalTestDataBP.getExternalCheckedTDManager(TestExecution.this.m_currentCap);
            ITestDataPO date = tdManager.getCell(0, desc);
            return this.getValueForParam(date, TestExecution.this.m_currentCap, desc);
        }
    }

    public abstract class AbstractTimerCmd
    extends AbstractPostExecutionCommand {
        protected String getTimerName() throws JBException {
            return this.getValueForParam("CompSystem.TimerName");
        }
    }

    public class CommandExecutorCmd
    extends AbstractPostExecutionCommand {
        public TestErrorEvent execute() throws JBException {
            IParamDescriptionPO desc = TestExecution.this.m_currentCap.getParameterForUniqueId("CompSystem.RunLocal");
            try {
                ITDManager tdManager = TestExecution.this.m_externalTestDataBP.getExternalCheckedTDManager(TestExecution.this.m_currentCap);
                ITestDataPO date = tdManager.getCell(0, desc);
                String runLocal = this.getValueForParam(date, TestExecution.this.m_currentCap, desc);
                if (Boolean.valueOf(runLocal).booleanValue()) {
                    desc = TestExecution.this.m_currentCap.getParameterForUniqueId("CompSystem.Command");
                    date = tdManager.getCell(0, desc);
                    String cmd = this.getValueForParam(date, TestExecution.this.m_currentCap, desc);
                    desc = TestExecution.this.m_currentCap.getParameterForUniqueId("CompSystem.Timeout");
                    date = tdManager.getCell(0, desc);
                    int timeout = Integer.parseInt(this.getValueForParam(date, TestExecution.this.m_currentCap, desc));
                    desc = TestExecution.this.m_currentCap.getParameterForUniqueId("CompSystem.ExpectedExitCode");
                    date = tdManager.getCell(0, desc);
                    int expectedExitCode = Integer.parseInt(this.getValueForParam(date, TestExecution.this.m_currentCap, desc));
                    File dataDir = ExternalTestDataBP.getDataDir();
                    ExternalCommandExecutor.MonitorTask mt = new ExternalCommandExecutor().executeCommand(dataDir, cmd, timeout);
                    if (!mt.wasCmdValid()) {
                        return EventFactory.createActionError((String)"TestErrorEvent.NoSuchCommand");
                    }
                    if (mt.hasTimeoutOccurred()) {
                        return EventFactory.createActionError((String)"TestErrorEvent.ConfirmationTimeout");
                    }
                    int actualExitValue = mt.getExitCode();
                    if (actualExitValue != expectedExitCode) {
                        return EventFactory.createVerifyFailed((String)String.valueOf(expectedExitCode), (String)String.valueOf(actualExitValue));
                    }
                }
            }
            catch (IllegalArgumentException e) {
                throw new JBException("IllegalArgumentException", (Throwable)e, MessageIDs.E_STEP_EXEC);
            }
            catch (InvalidDataException e) {
                throw new JBException("InvalidDataException", (Throwable)e, MessageIDs.E_STEP_EXEC);
            }
            return null;
        }
    }

    public static interface IPostExecutionCommand {
        public TestErrorEvent execute() throws JBException;
    }

    public class ManualTestStepCmd
    extends AbstractPostExecutionCommand {
        private String m_comment = null;
        private boolean m_status = false;

        public TestErrorEvent execute() throws JBException {
            try {
                String actionToPerform = this.getValueForParam("CompSystem.ActionToPerfom");
                String expectedBehavior = this.getValueForParam("CompSystem.ExpectedBehavior");
                int timeout = Integer.parseInt(this.getValueForParam("CompSystem.Timeout"));
                DisplayManualTestStepMessage message = new DisplayManualTestStepMessage(actionToPerform, expectedBehavior, timeout);
                DisplayManualTestStepResponseCommand command = new DisplayManualTestStepResponseCommand(this);
                ServerConnection.getInstance().request((Message)message, command, timeout);
                int waited = 0;
                while (command.getMessage() == null && waited <= timeout) {
                    try {
                        Thread.sleep(200L);
                        waited += 200;
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (waited > timeout) {
                    return EventFactory.createActionError((String)"TestErrorEvent.ConfirmationTimeout");
                }
                if (!this.m_status) {
                    return EventFactory.createVerifyFailed((String)String.valueOf(expectedBehavior), (String)String.valueOf(this.m_comment));
                }
                return null;
            }
            catch (IllegalArgumentException e) {
                throw new JBException("IllegalArgumentException", (Throwable)e, MessageIDs.E_STEP_EXEC);
            }
            catch (InvalidDataException e) {
                throw new JBException("InvalidDataException", (Throwable)e, MessageIDs.E_STEP_EXEC);
            }
        }

        public void setComment(String comment) {
            this.m_comment = comment;
        }

        public String getComment() {
            return this.m_comment;
        }

        public void setStatus(boolean status) {
            this.m_status = status;
        }

        public boolean isStatus() {
            return this.m_status;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PauseMode {
        TOGGLE,
        PAUSE,
        UNPAUSE,
        CONTINUE_WITHOUT_EH;

    }

    private class PostExecCommandFactory {
        private Map<String, IPostExecutionCommand> m_commandCache = new HashMap<String, IPostExecutionCommand>();

        private PostExecCommandFactory() {
        }

        public IPostExecutionCommand createCommand(String commandClassName) {
            Class<?> cmdClazz = null;
            IPostExecutionCommand cmdInstance = this.m_commandCache.get(commandClassName);
            if (cmdInstance != null) {
                return cmdInstance;
            }
            try {
                cmdClazz = Class.forName(commandClassName);
            }
            catch (ClassNotFoundException e) {
                LOG.error("ClassNotFoundException", (Throwable)e);
                TestExecution.this.fireError(e);
            }
            Constructor<?> constructor = null;
            try {
                constructor = cmdClazz.getConstructor(new Class[0]);
                cmdInstance = constructor.newInstance(new Object[0]);
            }
            catch (SecurityException e) {
                LOG.error("SecurityException", (Throwable)e);
                TestExecution.this.fireError(e);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    constructor = cmdClazz.getConstructor(TestExecution.this.getClass());
                    cmdInstance = constructor.newInstance(TestExecution.this);
                }
                catch (SecurityException e1) {
                    LOG.error("SecurityException", (Throwable)e1);
                    TestExecution.this.fireError(e1);
                }
                catch (NoSuchMethodException e1) {
                    LOG.error("NoSuchMethodException", (Throwable)e1);
                    TestExecution.this.fireError(e1);
                }
                catch (IllegalArgumentException e1) {
                    LOG.error("IllegalArgumentException", (Throwable)e1);
                    TestExecution.this.fireError(e1);
                }
                catch (InstantiationException e1) {
                    LOG.error("InstantiationException", (Throwable)e1);
                    TestExecution.this.fireError(e1);
                }
                catch (IllegalAccessException e1) {
                    LOG.error("IllegalAccessException", (Throwable)e1);
                    TestExecution.this.fireError(e1);
                }
                catch (InvocationTargetException e1) {
                    LOG.error("InvocationTargetException", (Throwable)e1);
                    TestExecution.this.fireError(e1);
                }
            }
            catch (IllegalArgumentException e) {
                LOG.error("IllegalArgumentException", (Throwable)e);
                TestExecution.this.fireError(e);
            }
            catch (InstantiationException e) {
                LOG.error("InstantiationException", (Throwable)e);
                TestExecution.this.fireError(e);
            }
            catch (IllegalAccessException e) {
                LOG.error("IllegalAccessException", (Throwable)e);
                TestExecution.this.fireError(e);
            }
            catch (InvocationTargetException e) {
                LOG.error("InvocationTargetException", (Throwable)e);
                TestExecution.this.fireError(e);
            }
            IPostExecutionCommand cmd = cmdInstance;
            this.m_commandCache.put(commandClassName, cmd);
            return cmd;
        }
    }

    public class ReadTimerCmd
    extends AbstractTimerCmd {
        public TestErrorEvent execute() throws JBException {
            try {
                String timerName = this.getTimerName();
                String variableName = this.getValueForParam("CompSystem.VariableToStoreTimeDeltaSinceTimerStart");
                Long timerTimeInMillisecs = TestExecution.this.getTimerStore().get(timerName);
                if (timerTimeInMillisecs == null) {
                    return EventFactory.createActionError((String)"TestErrorEvent.TimerNotFound");
                }
                Long curTimeInMillisecs = new Long(System.currentTimeMillis());
                Long timeDelta = curTimeInMillisecs - timerTimeInMillisecs;
                TestExecution.this.m_varStore.store(variableName, timeDelta.toString());
            }
            catch (IllegalArgumentException e) {
                throw new JBException("IllegalArgumentException", (Throwable)e, MessageIDs.E_STEP_EXEC);
            }
            catch (InvalidDataException e) {
                throw new JBException("InvalidDataException", (Throwable)e, MessageIDs.E_STEP_EXEC);
            }
            return null;
        }
    }

    public class RestartCmd
    implements IPostExecutionCommand {
        public TestErrorEvent execute() throws JBException {
            final AutIdentifier autId = TestExecution.this.getConnectedAutId();
            final AtomicBoolean isAutRestarted = new AtomicBoolean(false);
            IAutRegistrationListener registrationListener = new IAutRegistrationListener(){
                private boolean m_autEnded = false;

                public void handleAutRegistration(AutRegistrationEvent event) {
                    if (autId.equals((Object)event.getAutId())) {
                        if (event.getStatus() == AutRegistrationEvent.RegistrationStatus.Deregister) {
                            this.m_autEnded = true;
                        }
                        if (this.m_autEnded && event.getStatus() == AutRegistrationEvent.RegistrationStatus.Register) {
                            isAutRestarted.set(true);
                        }
                    }
                }
            };
            try {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {}
                if (LOG.isDebugEnabled()) {
                    LOG.debug(Messages.RequestingAUTAgentToCloseAUTConnection);
                }
                AUTConnection.getInstance().getCommunicator().getConnectionManager().remove(AUTConnection.getInstance().getCommunicator().getConnection());
                AUTConnection.getInstance().reset();
                AUTConnection.getInstance().close();
                boolean wasInterrupted = Thread.interrupted();
                AutAgentRegistration.getInstance().addListener(registrationListener);
                ServerConnection.getInstance().send((Message)new RestartAutMessage(autId));
                while (!isAutRestarted.get()) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {
                        wasInterrupted = true;
                    }
                }
                AUTConnection.getInstance().connectToAut(autId, (IProgressMonitor)new NullProgressMonitor());
                if (wasInterrupted) {
                    Thread.currentThread().interrupt();
                }
                TestExecution.this.initTestExecutionMessage(TestExecution.this.getConnectedAUTsConfigMap(), (IProgressMonitor)new NullProgressMonitor());
                return null;
            }
            finally {
                AutAgentRegistration.getInstance().removeListener(registrationListener);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(Messages.ContinueTestExecution);
                }
                if (!TestExecution.this.m_stopped) {
                    ClientTestFactory.getClientTest().fireTestExecutionChanged(new TestExecutionEvent(14));
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug(Messages.CantContinueTSIsStopped);
                }
            }
        }
    }

    public class StartTimerCmd
    extends AbstractTimerCmd {
        public TestErrorEvent execute() throws JBException {
            try {
                String timerName = this.getTimerName();
                String variableName = this.getValueForParam("CompSystem.VariableToStoreAbsoluteStartTime");
                Long curTimeInMillisecs = new Long(System.currentTimeMillis());
                TestExecution.this.getTimerStore().put(timerName, curTimeInMillisecs);
                TestExecution.this.m_varStore.store(variableName, curTimeInMillisecs.toString());
            }
            catch (IllegalArgumentException e) {
                throw new JBException("IllegalArgumentException", (Throwable)e, MessageIDs.E_STEP_EXEC);
            }
            catch (InvalidDataException e) {
                throw new JBException("InvalidDataException", (Throwable)e, MessageIDs.E_STEP_EXEC);
            }
            return null;
        }
    }

    private static class StepCounter
    implements IExecStackModificationListener,
    IEventStackModificationListener {
        private int m_totalSteps = 0;
        private int m_eventHandlerSteps = 0;
        private int m_retriedSteps = 0;
        private int m_failedSteps = 0;
        private int m_currentEventStackDepth = 0;
        private IProgressMonitor m_monitor;

        public StepCounter(IProgressMonitor monitor) {
            this.m_monitor = monitor;
        }

        public void nextCap(ICapPO cap) {
            if (this.m_currentEventStackDepth > 0) {
                ++this.m_eventHandlerSteps;
            } else {
                this.m_monitor.worked(1);
            }
            ++this.m_totalSteps;
        }

        public void nextDataSetIteration() {
        }

        public void retryCap(ICapPO cap) {
            if (this.m_currentEventStackDepth <= 0) {
                ++this.m_retriedSteps;
            } else {
                ++this.m_eventHandlerSteps;
            }
            ++this.m_totalSteps;
        }

        public void stackDecremented() {
        }

        public void stackIncremented(INodePO node) {
        }

        private void resetCounter() {
            this.m_totalSteps = 0;
            this.m_eventHandlerSteps = 0;
            this.m_retriedSteps = 0;
            this.m_failedSteps = 0;
        }

        public void eventStackDecremented() {
            --this.m_currentEventStackDepth;
        }

        public void eventStackIncremented() {
            ++this.m_currentEventStackDepth;
        }

        public int getTotalSteps() {
            return this.m_totalSteps;
        }

        public int getEventHandlerSteps() {
            return this.m_eventHandlerSteps;
        }

        public int getRetriedSteps() {
            return this.m_retriedSteps;
        }

        public int getFailedSteps() {
            return this.m_failedSteps;
        }

        public void incrementNumberOfFailedSteps() {
            ++this.m_failedSteps;
        }
    }

    public class VariableStorerCmd
    extends AbstractPostExecutionCommand {
        public TestErrorEvent execute() throws JBException {
            IParamDescriptionPO desc = TestExecution.this.m_currentCap.getParameterList().get(0);
            try {
                ITDManager tdManager = TestExecution.this.m_externalTestDataBP.getExternalCheckedTDManager(TestExecution.this.m_currentCap);
                ITestDataPO date = tdManager.getCell(0, desc);
                String varName = this.getValueForParam(date, TestExecution.this.m_currentCap, desc);
                TestExecution.this.m_varStore.store(varName, TestExecution.this.m_varStore.getValue(TestExecution.LAST_ACTION_RETURN));
                return null;
            }
            catch (IllegalArgumentException e) {
                throw new JBException("IllegalArgumentException", (Throwable)e, MessageIDs.E_STEP_EXEC);
            }
            catch (InvalidDataException e) {
                throw new JBException("InvalidDataException", (Throwable)e, MessageIDs.E_STEP_EXEC);
            }
        }
    }
}

