/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess.problems;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jubula.client.core.businessprocess.problems.IProblem;
import org.eclipse.jubula.client.core.businessprocess.problems.ProblemType;

final class Problem
implements IProblem {
    private String m_markerMessage;
    private IStatus m_status;
    private Object m_data;
    private ProblemType m_problemType;

    Problem(String markerMessage, IStatus status, Object data, ProblemType type) {
        Validate.notNull((Object)status);
        Validate.notNull((Object)status.getMessage());
        this.m_markerMessage = markerMessage;
        this.m_status = status;
        this.m_data = data;
        this.m_problemType = type;
    }

    public String getMarkerMessage() {
        return this.m_markerMessage;
    }

    public String getTooltipMessage() {
        return this.m_status.getMessage();
    }

    public String getPlugin() {
        return this.m_status.getPlugin();
    }

    public int getSeverity() {
        return this.m_status.getSeverity();
    }

    public Object getData() {
        return this.m_data;
    }

    public ProblemType getProblemType() {
        return this.m_problemType;
    }

    public boolean isWithMarker() {
        return this.getMarkerMessage() != null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Problem)) {
            return false;
        }
        Problem otherProblem = (Problem)obj;
        return new EqualsBuilder().append(this.getData(), otherProblem.getData()).append((Object)this.getMarkerMessage(), (Object)otherProblem.getMarkerMessage()).append((Object)this.getProblemType(), (Object)otherProblem.getProblemType()).append((Object)this.getTooltipMessage(), (Object)otherProblem.getTooltipMessage()).append(this.getSeverity(), otherProblem.getSeverity()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getData()).append((Object)this.getMarkerMessage()).append((Object)this.getProblemType()).append((Object)this.getTooltipMessage()).append(this.getSeverity()).toHashCode();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

