/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.datastructure;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.INodePO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompNameUsageMap {
    private Map<IComponentNamePO, Set<INodePO>> m_firstNameToUsers = new HashMap<IComponentNamePO, Set<INodePO>>();
    private Map<IComponentNamePO, Set<INodePO>> m_secondNameToUsers = new HashMap<IComponentNamePO, Set<INodePO>>();

    public void addFirstNameUser(IComponentNamePO componentName, INodePO user) {
        this.add(this.m_firstNameToUsers, componentName, user);
    }

    public void addSecondNameUser(IComponentNamePO componentName, INodePO user) {
        this.add(this.m_secondNameToUsers, componentName, user);
    }

    public Set<IComponentNamePO> getFirstCompNames() {
        return this.m_firstNameToUsers.keySet();
    }

    public Set<IComponentNamePO> getSecondCompNames() {
        return this.m_secondNameToUsers.keySet();
    }

    public Set<INodePO> getFirstNameUsers(IComponentNamePO componentName) {
        return this.get(this.m_firstNameToUsers, componentName);
    }

    public Set<INodePO> getSecondNameUsers(IComponentNamePO componentName) {
        return this.get(this.m_secondNameToUsers, componentName);
    }

    public void addAll(CompNameUsageMap usageMap) {
        for (IComponentNamePO compName : usageMap.getFirstCompNames()) {
            for (INodePO node : usageMap.getFirstNameUsers(compName)) {
                this.addFirstNameUser(compName, node);
            }
        }
        for (IComponentNamePO compName : usageMap.getSecondCompNames()) {
            for (INodePO node : usageMap.getSecondNameUsers(compName)) {
                this.addSecondNameUser(compName, node);
            }
        }
    }

    private void add(Map<IComponentNamePO, Set<INodePO>> nameToUsers, IComponentNamePO componentName, INodePO user) {
        Validate.notNull(nameToUsers);
        Set<INodePO> users = nameToUsers.get(componentName);
        if (users == null) {
            users = new HashSet<INodePO>();
            nameToUsers.put(componentName, users);
        }
        users.add(user);
    }

    private Set<INodePO> get(Map<IComponentNamePO, Set<INodePO>> nameToUsers, IComponentNamePO componentName) {
        Validate.notNull(nameToUsers);
        Set<INodePO> toReturn = nameToUsers.get(componentName);
        if (toReturn == null) {
            toReturn = Collections.emptySet();
        }
        return toReturn;
    }
}

