/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.model;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.eclipse.jubula.client.core.attributes.DefaultInitializer;
import org.eclipse.jubula.client.core.attributes.IDocAttributeInitializer;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IDocAttributeDescriptionPO;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="DOC_ATTR_DESC")
class DocAttributeDescriptionPO
implements IDocAttributeDescriptionPO,
Cloneable,
PersistenceWeaved,
PersistenceEntity,
PersistenceObject {
    private transient Long m_id;
    private transient Integer m_version;
    private Set<IDocAttributeDescriptionPO> m_subDescriptions;
    private String m_labelKey;
    private String m_displayClassName;
    private Set<String> m_valueSetKeys;
    private String m_defaultValue;
    private boolean m_isBXAttribute;
    private String m_initializerClassName;
    public static final long serialVersionUID = -986466897540525766L;
    protected transient Object _persistence_primaryKey;

    DocAttributeDescriptionPO() {
        this.m_id = null;
        this.m_version = null;
        this.m_subDescriptions = new HashSet<IDocAttributeDescriptionPO>();
    }

    DocAttributeDescriptionPO(String labelKey, String displayClassName, String initializerClassName) {
        this.m_id = null;
        this.m_version = null;
        this.m_subDescriptions = new HashSet<IDocAttributeDescriptionPO>();
        this.setLabelKey(labelKey);
        this.setDisplayClassName(displayClassName);
        this.setInitializerClassName(initializerClassName);
    }

    DocAttributeDescriptionPO(String labelKey, String displayClassName, String initializerClassName, Set<String> valueKeySet, String defaultValue) {
        this(labelKey, displayClassName, initializerClassName);
        this.setValueSetKeys(valueKeySet);
        this.setDefaultValue(defaultValue);
    }

    @Override
    @Transient
    public String getDefaultValue() {
        return this.getHbmDefaultValue();
    }

    private void setDefaultValue(String newDefaultValue) {
        if (!this.getValueSetKeys().contains(newDefaultValue)) {
            StringBuffer sb = new StringBuffer(Messages.AttemptedToSetADefaultValueThatDoesNotExist);
            sb.append(".");
            sb.append(" ");
            sb.append(Messages.Value);
            sb.append(":");
            sb.append(" ");
            sb.append(newDefaultValue);
            sb.append(";");
            sb.append(" ");
            sb.append(Messages.ValueSet);
            sb.append(":");
            sb.append(" ");
            sb.append("[");
            for (String value : this.getValueSetKeys()) {
                sb.append(value);
                sb.append(", ");
            }
            if (this.getValueSetKeys().isEmpty()) {
                sb.append("]");
            } else {
                sb.replace(sb.lastIndexOf(", "), sb.length(), "]");
            }
            throw new IllegalArgumentException(sb.toString());
        }
        this.setHbmDefaultValue(newDefaultValue);
    }

    @Basic
    @Column(name="DEFAULT_VALUE")
    private String getHbmDefaultValue() {
        return this.m_defaultValue;
    }

    private void setHbmDefaultValue(String defaultValue) {
        this.m_defaultValue = defaultValue;
    }

    @Override
    @Basic
    @Column(name="LABEL_KEY", unique=true)
    public String getLabelKey() {
        return this.m_labelKey;
    }

    private void setLabelKey(String labelKey) {
        this.m_labelKey = labelKey;
    }

    @Override
    @Basic
    @Column(name="DISPLAY_CLASS")
    public String getDisplayClassName() {
        return this.m_displayClassName;
    }

    @Override
    public void setDisplayClassName(String displayClassName) {
        this.m_displayClassName = displayClassName;
    }

    @Override
    @ElementCollection
    @CollectionTable(name="VALUE_SETS")
    @Column(name="VALUE")
    @JoinColumn(name="FK_DOC_ATTR_DESCRIPTION")
    public Set<String> getValueSetKeys() {
        return this.m_valueSetKeys;
    }

    private void setValueSetKeys(Set<String> valueSet) {
        this.m_valueSetKeys = valueSet;
    }

    @Override
    @Basic
    @Column(name="BX")
    public boolean isBXAttribute() {
        return this.m_isBXAttribute;
    }

    private void setBXAttribute(boolean isBXAttribute) {
        this.m_isBXAttribute = isBXAttribute;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IDocAttributeDescriptionPO)) {
            return false;
        }
        IDocAttributeDescriptionPO otherDesc = (IDocAttributeDescriptionPO)obj;
        return new EqualsBuilder().append((Object)this.getLabelKey(), (Object)otherDesc.getLabelKey()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getLabelKey()).toHashCode();
    }

    @Override
    public boolean isValueValid(String value) {
        return this.getValueSetKeys() == null || this.getValueSetKeys().isEmpty() || this.getValueSetKeys().contains(value);
    }

    @Override
    @ManyToMany(cascade={CascadeType.ALL}, targetEntity=DocAttributeDescriptionPO.class)
    @JoinTable(name="DOC_ATTR_DESC_LIST", joinColumns={@JoinColumn(name="PARENT")}, inverseJoinColumns={@JoinColumn(name="CHILD")})
    public Set<IDocAttributeDescriptionPO> getSubDescriptions() {
        return this.m_subDescriptions;
    }

    private void setSubDescriptions(Set<IDocAttributeDescriptionPO> subDescriptions) {
        this.m_subDescriptions = subDescriptions;
    }

    @Override
    public boolean removeSubDescription(IDocAttributeDescriptionPO description) {
        return this.getSubDescriptions().remove(description);
    }

    @Override
    public boolean addSubDescription(IDocAttributeDescriptionPO description) {
        return this.getSubDescriptions().add(description);
    }

    @Id
    @GeneratedValue
    public Long getId() {
        return this.m_id;
    }

    void setId(Long id) {
        this.m_id = id;
    }

    @Version
    public Integer getVersion() {
        return this.m_version;
    }

    private void setVersion(Integer version) {
        this.m_version = version;
    }

    @Override
    @Transient
    public IDocAttributeInitializer getInitializer() {
        if (StringUtils.defaultString((String)this.getInitializerClassName()).length() == 0) {
            return new DefaultInitializer();
        }
        try {
            Class<?> initializerClass = Class.forName(this.getInitializerClassName());
            Object instance = initializerClass.newInstance();
            if (instance instanceof IDocAttributeInitializer) {
                return (IDocAttributeInitializer)instance;
            }
            return new DefaultInitializer();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return new DefaultInitializer();
        }
        catch (InstantiationException instantiationException) {
            return new DefaultInitializer();
        }
        catch (IllegalAccessException illegalAccessException) {
            return new DefaultInitializer();
        }
    }

    @Basic
    @Column(name="INITIALIZER_CLASS")
    private String getInitializerClassName() {
        return this.m_initializerClassName;
    }

    @Override
    public void setInitializerClassName(String className) {
        this.m_initializerClassName = className;
    }

    public Object _persistence_post_clone() {
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_getId() {
        return this._persistence_primaryKey;
    }

    public void _persistence_setId(Object object) {
        this._persistence_primaryKey = object;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new DocAttributeDescriptionPO(persistenceObject);
    }

    public DocAttributeDescriptionPO(PersistenceObject persistenceObject) {
    }

    public Object _persistence_get(String string) {
        if (string == "id") {
            return this.id;
        }
        if (string == "displayClassName") {
            return this.displayClassName;
        }
        if (string == "subDescriptions") {
            return this.subDescriptions;
        }
        if (string == "initializerClassName") {
            return this.initializerClassName;
        }
        if (string == "labelKey") {
            return this.labelKey;
        }
        if (string == "BXAttribute") {
            return this.BXAttribute;
        }
        if (string == "valueSetKeys") {
            return this.valueSetKeys;
        }
        if (string == "version") {
            return this.version;
        }
        if (string == "hbmDefaultValue") {
            return this.hbmDefaultValue;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "id") {
            this.id = (Long)object;
            return;
        }
        if (string == "displayClassName") {
            this.displayClassName = (String)object;
            return;
        }
        if (string == "subDescriptions") {
            this.subDescriptions = (Set)object;
            return;
        }
        if (string == "initializerClassName") {
            this.initializerClassName = (String)object;
            return;
        }
        if (string == "labelKey") {
            this.labelKey = (String)object;
            return;
        }
        if (string == "BXAttribute") {
            this.BXAttribute = (Boolean)object;
            return;
        }
        if (string == "valueSetKeys") {
            this.valueSetKeys = (Set)object;
            return;
        }
        if (string == "version") {
            this.version = (Integer)object;
            return;
        }
        if (string == "hbmDefaultValue") {
            this.hbmDefaultValue = (String)object;
            return;
        }
    }
}

