/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.eclipse.jubula.client.core.model.ITestJobContPO;
import org.eclipse.jubula.client.core.model.ITestJobPO;
import org.eclipse.jubula.client.core.model.TestJobPO;
import org.eclipse.jubula.client.core.model.WrapperPO;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="TEST_JOB_CONT")
public class TestJobContPO
extends WrapperPO
implements ITestJobContPO,
PersistenceWeaved,
PersistenceObject {
    private List<ITestJobPO> m_testJobList;
    public static final long serialVersionUID = -8101221080835230203L;

    TestJobContPO() {
        this.m_testJobList = new ArrayList<ITestJobPO>();
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, targetEntity=TestJobPO.class)
    @OrderColumn(name="IDX")
    List<ITestJobPO> getHbmTestJobList() {
        return this.m_testJobList;
    }

    @Override
    @Transient
    public List<ITestJobPO> getTestJobList() {
        return Collections.unmodifiableList(this.m_testJobList);
    }

    void setHbmTestJobList(List<ITestJobPO> testJobList) {
        this.m_testJobList = testJobList;
    }

    @Override
    @Transient
    public String getName() {
        return "TestJobContPO";
    }

    @Override
    public void addTestJob(ITestJobPO ts) {
        this.addTestJob(-1, ts);
    }

    @Override
    public void addTestJob(int position, ITestJobPO ts) {
        if (position < 0 || position > this.getHbmTestJobList().size()) {
            this.getHbmTestJobList().add(ts);
        } else {
            this.getHbmTestJobList().add(position, ts);
        }
        ts.setParentProjectId(this.getParentProjectId());
    }

    @Override
    public void removeTestJob(ITestJobPO ts) {
        this.getHbmTestJobList().remove(ts);
        ts.setParentNode(null);
    }

    @Override
    public void setParentProjectId(Long projectId) {
        super.setParentProjectId(projectId);
        for (ITestJobPO ts : this.getHbmTestJobList()) {
            ts.setParentProjectId(projectId);
        }
    }

    @Override
    @Transient
    public Long getParentProjectId() {
        return super.getParentProjectId();
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new TestJobContPO(persistenceObject);
    }

    public TestJobContPO(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "hbmTestJobList") {
            return this.hbmTestJobList;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "hbmTestJobList") {
            this.hbmTestJobList = (List)object;
            return;
        }
        super._persistence_set(string, object);
    }
}

