/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.persistence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceException;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesDecorator;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameCache;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameCache;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBP;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBPDecorator;
import org.eclipse.jubula.client.core.businessprocess.ProjectComponentNameMapper;
import org.eclipse.jubula.client.core.datastructure.CompNameUsageMap;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParamNamePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ISpecObjContPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITcParamDescriptionPO;
import org.eclipse.jubula.client.core.model.ITestJobPO;
import org.eclipse.jubula.client.core.model.ITestSuiteContPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.persistence.CompNamePM;
import org.eclipse.jubula.client.core.persistence.ComponentNameExistsException;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.ISpecPersistable;
import org.eclipse.jubula.client.core.persistence.IncompatibleTypeException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PersistenceManager;
import org.eclipse.jubula.client.core.persistence.PersistenceUtil;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.core.persistence.locking.LockManager;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.messagehandling.MessageInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleNodePM
extends PersistenceManager {
    private static MultipleNodePM persManager = null;

    public static MultipleNodePM getInstance() {
        if (persManager == null) {
            persManager = new MultipleNodePM();
        }
        return persManager;
    }

    public MessageInfo executeCommands(List<AbstractCmdHandle> cmds) throws PMException, ProjectDeletedException {
        return this.executeCommands(cmds, null);
    }

    public MessageInfo executeCommands(List<AbstractCmdHandle> cmds, ParamNameBPDecorator dec) throws PMException, ProjectDeletedException {
        return this.executeCommands(cmds, dec, GeneralStorage.getInstance().getMasterSession());
    }

    public MessageInfo executeCommands(List<AbstractCmdHandle> cmds, ParamNameBPDecorator dec, EntityManager sess) throws PMException, ProjectDeletedException {
        Persistor persistor = Persistor.instance();
        EntityTransaction tx = null;
        HashSet<IPersistentObject> objectsToLock = new HashSet<IPersistentObject>();
        IPersistentObject actObj = null;
        for (AbstractCmdHandle cmd : cmds) {
            objectsToLock.addAll(cmd.getObjsToLock());
        }
        try {
            tx = persistor.getTransaction(sess);
            persistor.lockPOSet(sess, objectsToLock);
            for (AbstractCmdHandle cmd : cmds) {
                MessageInfo errorMessage = cmd.execute(sess);
                if (errorMessage == null) continue;
                persistor.rollbackTransaction(sess, tx);
                return errorMessage;
            }
            if (dec != null) {
                this.deleteParamNames(dec, sess);
            }
            persistor.commitTransaction(sess, tx);
            if (dec != null) {
                Long projId = GeneralStorage.getInstance().getProject().getId();
                dec.updateStandardMapperAndCleanup(projId);
            }
            EntityManager masterSession = GeneralStorage.getInstance().getMasterSession();
            for (AbstractCmdHandle cmd : cmds) {
                if (!(cmd instanceof UpdateParamNamesHandle)) continue;
                UpdateParamNamesHandle paramCmd = (UpdateParamNamesHandle)cmd;
                for (IParamNamePO paramName : paramCmd.getParamNames()) {
                    masterSession.detach((Object)paramName);
                }
            }
        }
        catch (PersistenceException e1) {
            PersistenceManager.handleDBExceptionForMasterSession(actObj, e1);
        }
        return null;
    }

    private void deleteParamNames(ParamNameBPDecorator dec, EntityManager s) {
        try {
            dec.persist(s, GeneralStorage.getInstance().getProject().getId());
        }
        catch (PMException e) {
            throw new PersistenceException((Throwable)((Object)e));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractCmdHandle {
        private final Set<IPersistentObject> m_objsToLock = new HashSet<IPersistentObject>();

        public final Set<IPersistentObject> getObjsToLock() {
            return this.m_objsToLock;
        }

        public abstract MessageInfo execute(EntityManager var1);
    }

    public static class DeleteCatHandle
    extends AbstractCmdHandle {
        private ICategoryPO m_category;

        public DeleteCatHandle(ICategoryPO cat) {
            this.m_category = cat;
            this.getObjsToLock().add(cat);
            if (cat.getParentNode() != null && !(cat.getParentNode() instanceof IProjectPO)) {
                this.getObjsToLock().add(cat.getParentNode());
            } else {
                IProjectPO proj = GeneralStorage.getInstance().getProject();
                this.getObjsToLock().add(proj.getSpecObjCont());
            }
        }

        public MessageInfo execute(EntityManager sess) {
            if (this.m_category.getParentNode() != null && !(this.m_category.getParentNode() instanceof IProjectPO)) {
                this.m_category.getParentNode().removeNode(this.m_category);
            } else {
                IProjectPO proj = GeneralStorage.getInstance().getProject();
                proj.getSpecObjCont().removeSpecObject(this.m_category);
            }
            PersistenceUtil.removeChildNodes(this.m_category, sess);
            sess.remove((Object)this.m_category);
            return null;
        }
    }

    public static class DeleteEvHandle
    extends AbstractCmdHandle {
        private IEventExecTestCasePO m_eventTestCase;

        public DeleteEvHandle(IEventExecTestCasePO tc) {
            this.m_eventTestCase = tc;
            this.getObjsToLock().add(tc);
            this.getObjsToLock().add(tc.getParentNode());
        }

        public MessageInfo execute(EntityManager sess) {
            ISpecTestCasePO usingSpecTc = (ISpecTestCasePO)this.m_eventTestCase.getParentNode();
            usingSpecTc.removeNode(this.m_eventTestCase);
            sess.remove((Object)this.m_eventTestCase);
            return null;
        }
    }

    public static class DeleteTCHandle
    extends AbstractCmdHandle {
        private ISpecTestCasePO m_testCase;
        private ParamNameBPDecorator m_dec;

        public DeleteTCHandle(ISpecTestCasePO tc, ParamNameBPDecorator mapper) {
            this.m_testCase = tc;
            this.m_dec = mapper;
            this.getObjsToLock().add(tc);
            if (this.isNestedTestCase(tc)) {
                this.getObjsToLock().add(tc.getParentNode());
            } else {
                IProjectPO proj = GeneralStorage.getInstance().getProject();
                this.getObjsToLock().add(proj.getSpecObjCont());
            }
        }

        public MessageInfo execute(EntityManager sess) {
            if (this.isNestedTestCase(this.m_testCase)) {
                this.m_testCase.getParentNode().removeNode(this.m_testCase);
            } else {
                IProjectPO proj = GeneralStorage.getInstance().getProject();
                proj.getSpecObjCont().removeSpecObject(this.m_testCase);
            }
            this.registerParamNamesForDeletion(this.m_testCase);
            PersistenceUtil.removeChildNodes(this.m_testCase, sess);
            sess.remove((Object)this.m_testCase);
            return null;
        }

        private boolean isNestedTestCase(ISpecTestCasePO tc) {
            boolean isNested = false;
            if (tc.getParentNode() != null && !(tc.getParentNode() instanceof IProjectPO)) {
                isNested = true;
            }
            return isNested;
        }

        private void registerParamNamesForDeletion(ISpecTestCasePO specTcPO) {
            for (IParamDescriptionPO desc : specTcPO.getParameterList()) {
                this.m_dec.registerParamDescriptions((ITcParamDescriptionPO)desc);
                this.m_dec.removeParamNamePO(desc.getUniqueId());
            }
        }
    }

    public static class DeleteTJHandle
    extends AbstractCmdHandle {
        private ITestJobPO m_testjob;

        public DeleteTJHandle(ITestJobPO tj) {
            this.m_testjob = tj;
            this.getObjsToLock().add(tj);
            IProjectPO proj = GeneralStorage.getInstance().getProject();
            this.getObjsToLock().add(proj.getTestJobCont());
        }

        public MessageInfo execute(EntityManager sess) {
            IProjectPO proj = GeneralStorage.getInstance().getProject();
            proj.getTestJobCont().removeTestJob(this.m_testjob);
            sess.remove((Object)this.m_testjob);
            return null;
        }
    }

    public static class DeleteTSHandle
    extends AbstractCmdHandle {
        private ITestSuitePO m_testSuite;

        public DeleteTSHandle(ITestSuitePO ts) {
            this.m_testSuite = ts;
            this.getObjsToLock().add(ts);
            IProjectPO proj = GeneralStorage.getInstance().getProject();
            this.getObjsToLock().add(proj.getTestSuiteCont());
        }

        public MessageInfo execute(EntityManager sess) {
            IProjectPO proj = GeneralStorage.getInstance().getProject();
            proj.getTestSuiteCont().removeTestSuite(this.m_testSuite);
            sess.remove((Object)this.m_testSuite);
            return null;
        }
    }

    public static class MoveNodeHandle
    extends AbstractCmdHandle {
        private INodePO m_node;
        private IPersistentObject m_oldParent;
        private IPersistentObject m_newParent;

        public MoveNodeHandle(INodePO node, IPersistentObject oldParent, IPersistentObject newParent) {
            IProjectPO proj = GeneralStorage.getInstance().getProject();
            this.m_oldParent = oldParent;
            if (oldParent instanceof IProjectPO) {
                if (node instanceof ITestSuitePO) {
                    this.m_oldParent = proj.getTestSuiteCont();
                } else if (node instanceof ISpecTestCasePO || node instanceof ICategoryPO) {
                    this.m_oldParent = proj.getSpecObjCont();
                }
            }
            this.m_newParent = newParent;
            if (newParent instanceof IProjectPO) {
                if (node instanceof ITestSuitePO) {
                    this.m_newParent = proj.getTestSuiteCont();
                } else if (node instanceof ISpecTestCasePO || node instanceof ICategoryPO) {
                    this.m_newParent = proj.getSpecObjCont();
                }
            }
            this.m_node = node;
            this.getObjsToLock().add(this.m_node);
            this.getObjsToLock().add(this.m_oldParent);
            this.getObjsToLock().add(this.m_newParent);
        }

        public MessageInfo execute(EntityManager sess) {
            EntityManager masterSession = GeneralStorage.getInstance().getMasterSession();
            IPersistentObject oldParent = this.m_oldParent;
            IPersistentObject newParent = this.m_newParent;
            INodePO node = this.m_node;
            DataEventDispatcher eventDispatcher = DataEventDispatcher.getInstance();
            if (masterSession != sess) {
                masterSession.detach((Object)node);
                oldParent = (IPersistentObject)sess.find(oldParent.getClass(), (Object)oldParent.getId());
                newParent = (IPersistentObject)sess.find(newParent.getClass(), (Object)newParent.getId());
                node = (INodePO)sess.find(node.getClass(), (Object)node.getId());
            }
            if (oldParent instanceof ISpecObjContPO) {
                ((ISpecObjContPO)oldParent).removeSpecObject((ISpecPersistable)node);
            } else if (oldParent instanceof ITestSuiteContPO) {
                ((ITestSuiteContPO)oldParent).removeTestSuite((ITestSuitePO)node);
            } else {
                ((INodePO)oldParent).removeNode(node);
            }
            if (newParent instanceof ISpecObjContPO) {
                ((ISpecObjContPO)newParent).addSpecObject((ISpecPersistable)node);
            } else if (newParent instanceof ITestSuiteContPO) {
                ((ITestSuiteContPO)newParent).addTestSuite((ITestSuitePO)node);
            } else {
                ((INodePO)newParent).addNode(node);
            }
            eventDispatcher.fireDataChangedListener(newParent, DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.notInEditor);
            eventDispatcher.fireDataChangedListener(oldParent, DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.notInEditor);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class TransferCompNameHandle
    extends AbstractCmdHandle {
        private Map<IComponentNamePO, Set<INodePO>> m_firstCompNameToUsers = new HashMap<IComponentNamePO, Set<INodePO>>();
        private Map<IComponentNamePO, Set<INodePO>> m_secondCompNameToUsers;
        private Long m_currentProjectId = null;
        private IProjectPO m_newParentProj = null;

        public TransferCompNameHandle(CompNameUsageMap usageMap, Long currentProjectId, IProjectPO newParentProj) {
            HashSet<INodePO> users;
            for (IComponentNamePO compName : usageMap.getFirstCompNames()) {
                users = new HashSet<INodePO>();
                users.addAll(usageMap.getFirstNameUsers(compName));
                this.m_firstCompNameToUsers.put(compName, users);
            }
            this.m_secondCompNameToUsers = new HashMap<IComponentNamePO, Set<INodePO>>();
            for (IComponentNamePO compName : usageMap.getSecondCompNames()) {
                users = new HashSet();
                users.addAll(usageMap.getSecondNameUsers(compName));
                this.m_secondCompNameToUsers.put(compName, users);
            }
            this.m_currentProjectId = currentProjectId;
            this.m_newParentProj = newParentProj;
        }

        @Override
        public MessageInfo execute(EntityManager sess) {
            ProjectComponentNameMapper extProjectCompMapper = new ProjectComponentNameMapper((IWritableComponentNameCache)new ComponentNamesDecorator(sess), this.m_newParentProj);
            try {
                HashMap<String, IComponentNamePO> createdComponentNames = new HashMap<String, IComponentNamePO>();
                createdComponentNames.putAll(this.handleFirstNames(sess, extProjectCompMapper));
                createdComponentNames.putAll(this.handleSecondNames(sess, extProjectCompMapper));
                for (String guid : createdComponentNames.keySet()) {
                    this.handleMapping(sess, extProjectCompMapper, guid, (IComponentNamePO)createdComponentNames.get(guid));
                }
                CompNamePM.flushCompNames(sess, this.m_newParentProj.getId(), extProjectCompMapper);
            }
            catch (PMException e) {
                return new MessageInfo(e.getErrorId(), null);
            }
            catch (IncompatibleTypeException e) {
                return new MessageInfo(e.getErrorId(), e.getErrorMessageParams());
            }
            catch (ComponentNameExistsException e) {
                return new MessageInfo(e.getErrorId(), e.getErrorMessageParams());
            }
            return null;
        }

        private void handleMapping(EntityManager sess, IWritableComponentNameMapper extProjectCompMapper, String originalGuid, IComponentNamePO compName) throws PMException, IncompatibleTypeException {
            IProjectPO currentProject = (IProjectPO)sess.find(NodeMaker.getProjectPOClass(), (Object)this.m_currentProjectId);
            for (IAUTMainPO aut : currentProject.getAutMainList()) {
                if (!LockManager.instance().lockPO(sess, aut, true)) continue;
                IObjectMappingAssoziationPO assoc = aut.getObjMap().getLogicalNameAssoc(originalGuid);
                extProjectCompMapper.changeReuse(assoc, null, compName.getGuid());
            }
        }

        private Map<String, IComponentNamePO> handleSecondNames(EntityManager sess, IWritableComponentNameMapper extProjectCompMapper) throws IncompatibleTypeException, PMException {
            HashMap<String, IComponentNamePO> createdNames = new HashMap<String, IComponentNamePO>();
            Map<IComponentNamePO, Set<INodePO>> secondCompNameToUsers = this.loadInSession(sess, this.m_secondCompNameToUsers);
            for (IComponentNamePO compName : secondCompNameToUsers.keySet()) {
                IComponentNamePO existingExtCompName = this.getCompNamePOForName(compName.getName(), extProjectCompMapper.getCompNameCache(), this.m_newParentProj.getId());
                if (existingExtCompName != null && existingExtCompName.getParentProjectId().equals(this.m_newParentProj.getId())) {
                    this.updateSecondNameUsers(extProjectCompMapper, secondCompNameToUsers, compName, existingExtCompName);
                    continue;
                }
                String compType = ComponentBuilder.getInstance().getCompSystem().getMostAbstractComponent().getType();
                IComponentNamePO newCompName = extProjectCompMapper.getCompNameCache().createComponentNamePO(compName.getName(), compType, ComponentNamesBP.CompNameCreationContext.OVERRIDDEN_NAME);
                newCompName.setParentProjectId(this.m_newParentProj.getId());
                createdNames.put(compName.getGuid(), newCompName);
                this.updateSecondNameUsers(extProjectCompMapper, secondCompNameToUsers, compName, newCompName);
            }
            return createdNames;
        }

        private void updateSecondNameUsers(IWritableComponentNameMapper extProjectCompMapper, Map<IComponentNamePO, Set<INodePO>> secondCompNameToUsers, IComponentNamePO compName, IComponentNamePO existingExtCompName) throws IncompatibleTypeException, PMException {
            for (INodePO node : secondCompNameToUsers.get(compName)) {
                if (node instanceof ICapPO) {
                    ICapPO capPo = (ICapPO)node;
                    extProjectCompMapper.changeReuse(capPo, capPo.getComponentName(), existingExtCompName.getGuid());
                    continue;
                }
                if (!(node instanceof IExecTestCasePO)) continue;
                for (ICompNamesPairPO pair : ((IExecTestCasePO)node).getCompNamesPairs()) {
                    if (!pair.getSecondName().equals(compName.getGuid())) continue;
                    extProjectCompMapper.changeReuse(pair, pair.getSecondName(), existingExtCompName.getGuid());
                }
            }
        }

        private Map<String, IComponentNamePO> handleFirstNames(EntityManager sess, IWritableComponentNameMapper compMapper) throws ComponentNameExistsException {
            HashMap<String, IComponentNamePO> createdComponentNames = new HashMap<String, IComponentNamePO>();
            Map<IComponentNamePO, Set<INodePO>> firstCompNameToUsers = this.loadInSession(sess, this.m_firstCompNameToUsers);
            for (IComponentNamePO compName : firstCompNameToUsers.keySet()) {
                if (!compName.getParentProjectId().equals(this.m_currentProjectId)) continue;
                IComponentNamePO existingExtCompName = this.getCompNamePOForName(compName.getName(), compMapper.getCompNameCache(), this.m_newParentProj.getId());
                if (existingExtCompName != null && existingExtCompName.getParentProjectId().equals(this.m_newParentProj.getId())) {
                    throw new ComponentNameExistsException("Cannot perform move operation.", MessageIDs.E_MOVE_TC_COMP_NAME_EXISTS, new String[]{existingExtCompName.getName()});
                }
                String compType = ComponentBuilder.getInstance().getCompSystem().getMostAbstractComponent().getType();
                IComponentNamePO newCompName = compMapper.getCompNameCache().createComponentNamePO(compName.getName(), compType, ComponentNamesBP.CompNameCreationContext.STEP);
                newCompName.setParentProjectId(this.m_newParentProj.getId());
                createdComponentNames.put(compName.getGuid(), newCompName);
                for (INodePO node : firstCompNameToUsers.get(compName)) {
                    if (!(node instanceof IExecTestCasePO)) continue;
                    for (ICompNamesPairPO pair : ((IExecTestCasePO)node).getCompNamesPairs()) {
                        if (!pair.getFirstName().equals(compName.getGuid())) continue;
                        pair.setFirstName(newCompName.getGuid());
                    }
                }
            }
            return createdComponentNames;
        }

        private Map<IComponentNamePO, Set<INodePO>> loadInSession(EntityManager sess, Map<IComponentNamePO, Set<INodePO>> toLoad) {
            HashMap<IComponentNamePO, Set<INodePO>> sessionMap = new HashMap<IComponentNamePO, Set<INodePO>>();
            for (IComponentNamePO compName : toLoad.keySet()) {
                HashSet<INodePO> userSet = new HashSet<INodePO>();
                for (INodePO node : toLoad.get(compName)) {
                    userSet.add((INodePO)sess.find(node.getClass(), (Object)node.getId()));
                }
                sessionMap.put((IComponentNamePO)sess.find(compName.getClass(), (Object)compName.getId()), userSet);
            }
            return sessionMap;
        }

        private IComponentNamePO getCompNamePOForName(String name, IComponentNameCache compNameCache, Long parentProjectId) {
            String guid = compNameCache.getGuidForName(name, parentProjectId);
            if (guid != null) {
                return compNameCache.getCompNamePo(guid);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UpdateParamNamesHandle
    extends AbstractCmdHandle {
        private List<ISpecTestCasePO> m_specTestCases;
        private IProjectPO m_reusedProject;
        private List<IParamNamePO> m_paramNames = new ArrayList<IParamNamePO>();

        public UpdateParamNamesHandle(List<ISpecTestCasePO> specTCs, IProjectPO reusedProject) {
            this.m_specTestCases = specTCs;
            this.m_reusedProject = reusedProject;
        }

        @Override
        public MessageInfo execute(EntityManager sess) {
            for (ISpecTestCasePO specTC : this.m_specTestCases) {
                for (IParamDescriptionPO desc : specTC.getParameterList()) {
                    IParamNamePO paramNamePO = ParamNameBP.getInstance().getParamNamePO(desc.getUniqueId());
                    if (paramNamePO == null) continue;
                    paramNamePO.setParentProjectId(this.m_reusedProject.getId());
                    this.m_paramNames.add(paramNamePO);
                    sess.merge((Object)paramNamePO);
                    this.getObjsToLock().add(paramNamePO);
                }
            }
            return null;
        }

        List<IParamNamePO> getParamNames() {
            return this.m_paramNames;
        }
    }

    public static class UpdateTestCaseRefHandle
    extends AbstractCmdHandle {
        private IExecTestCasePO m_execTc;
        private ISpecTestCasePO m_specTc;

        public UpdateTestCaseRefHandle(IExecTestCasePO execTc, ISpecTestCasePO specTc) {
            this.m_execTc = execTc;
            this.m_specTc = specTc;
            this.getObjsToLock().add(this.m_execTc);
        }

        public MessageInfo execute(EntityManager sess) {
            ISpecTestCasePO specTc = (ISpecTestCasePO)sess.find(this.m_specTc.getClass(), (Object)this.m_specTc.getId());
            IExecTestCasePO execTc = (IExecTestCasePO)sess.find(this.m_execTc.getClass(), (Object)this.m_execTc.getId());
            execTc.setSpecTestCase(specTc);
            return null;
        }
    }
}

