/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.businessprocess.db.TestCaseBP;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.dialogs.InputDialog;
import org.eclipse.jubula.client.ui.editors.JBEditorHelper;
import org.eclipse.jubula.client.ui.editors.TestCaseEditor;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractNewTestCaseAction
extends Action {
    private String m_helpid = null;

    public AbstractNewTestCaseAction() {
        this(null);
    }

    public AbstractNewTestCaseAction(String helpId) {
        super(Messages.AbstractNewTestCaseActionNewTC);
        this.setImageDescriptor(IconConstants.NEW_TC_IMAGE_DESCRIPTOR);
        this.setDisabledImageDescriptor(IconConstants.NEW_TC_DISABLED_IMAGE_DESCRIPTOR);
        this.setEnabled(false);
        this.m_helpid = helpId;
    }

    public void run() {
        TestCaseEditor tce = (TestCaseEditor)Plugin.getActiveEditor();
        if (!(tce.getTreeViewer().getSelection() instanceof IStructuredSelection)) {
            return;
        }
        if (JBEditorHelper.EditableState.OK == tce.getEditorHelper().requestEditableState()) {
            INodePO selectedNode = (INodePO)((IStructuredSelection)tce.getTreeViewer().getSelection()).getFirstElement();
            ISpecTestCasePO editorNode = (ISpecTestCasePO)tce.getEditorHelper().getEditSupport().getWorkVersion();
            InputDialog dialog = new InputDialog(Plugin.getShell(), Messages.NewTestCaseActionTCTitle, "New Test Case", Messages.NewTestCaseActionTCMessage, Messages.RenameActionTCLabel, Messages.RenameActionTCError, Messages.NewTestCaseActionDoubleTCName, "newTestCaseDialog.gif", Messages.NewTestCaseActionTCShell, false);
            if (this.m_helpid != null) {
                dialog.setHelpAvailable(true);
                dialog.create();
                Plugin.getHelpSystem().setHelp((Control)dialog.getShell(), this.m_helpid);
            } else {
                dialog.create();
            }
            DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
            dialog.open();
            ISpecTestCasePO newSpecTC = null;
            if (dialog.getReturnCode() == 0) {
                String tcName = dialog.getName();
                IProjectPO parent = GeneralStorage.getInstance().getProject();
                try {
                    newSpecTC = TestCaseBP.createNewSpecTestCase((String)tcName, (INodePO)parent, null);
                    DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)newSpecTC, DataEventDispatcher.DataState.Added, DataEventDispatcher.UpdateState.all);
                }
                catch (PMException e) {
                    PMExceptionHandler.handlePMExceptionForMasterSession(e);
                }
                catch (ProjectDeletedException projectDeletedException) {
                    PMExceptionHandler.handleGDProjectDeletedException();
                }
            }
            if (newSpecTC != null) {
                Integer index = null;
                if (selectedNode instanceof IExecTestCasePO) {
                    index = AbstractNewTestCaseAction.getPositionToInsert((INodePO)editorNode, (IExecTestCasePO)selectedNode);
                }
                try {
                    ISpecTestCasePO workNewSpecTC = (ISpecTestCasePO)tce.getEditorHelper().getEditSupport().createWorkVersion((IPersistentObject)newSpecTC);
                    IExecTestCasePO newExecTC = TestCaseBP.addReferencedTestCase((EditSupport)tce.getEditorHelper().getEditSupport(), (INodePO)editorNode, (ISpecTestCasePO)workNewSpecTC, (Integer)index);
                    tce.getEditorHelper().setDirty(true);
                    DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)newExecTC, DataEventDispatcher.DataState.Added, DataEventDispatcher.UpdateState.all);
                }
                catch (PMException e) {
                    PMExceptionHandler.handlePMExceptionForEditor(e, tce);
                }
            }
        }
    }

    public static Integer getPositionToInsert(INodePO workNode, IExecTestCasePO selectedNode) {
        int positionToAdd = workNode.indexOf((INodePO)selectedNode) + 1;
        if (Plugin.getDefault().getPreferenceStore().getBoolean("NODE_INSERT_KEY")) {
            positionToAdd = workNode.getUnmodifiableNodeList().size() + 1;
        }
        return positionToAdd;
    }
}

