/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.businessprocess.db.TestCaseBP;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.dialogs.InputDialog;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.client.ui.views.TestCaseBrowser;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;
import org.eclipse.swt.widgets.Control;

public class NewTestCaseActionTCBrowser
extends Action {
    public NewTestCaseActionTCBrowser() {
        super(Messages.AbstractNewTestCaseActionNewTC);
        this.setImageDescriptor(IconConstants.NEW_TC_IMAGE_DESCRIPTOR);
        this.setDisabledImageDescriptor(IconConstants.NEW_TC_DISABLED_IMAGE_DESCRIPTOR);
        this.setEnabled(false);
    }

    public void run() {
        InputDialog dialog = new InputDialog(Plugin.getShell(), Messages.NewTestCaseActionTCTitle, "New Test Case", Messages.NewTestCaseActionTCMessage, Messages.NewTestCaseActionTCLabel, Messages.RenameActionTCError, Messages.NewTestCaseActionDoubleTCName, "newTestCaseDialog.gif", Messages.NewTestCaseActionTCShell, false);
        dialog.setHelpAvailable(true);
        dialog.create();
        DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
        Plugin.getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.jubula.client.ua.help.testcaseNewContextId");
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            String tcName = dialog.getName();
            TestCaseBrowser tstv = (TestCaseBrowser)Plugin.getView("org.eclipse.jubula.client.ui.views.TestCaseBrowser");
            IProjectPO parent = null;
            if (tstv.getTreeViewer().getSelection() instanceof IStructuredSelection) {
                IStructuredSelection sel = (IStructuredSelection)tstv.getTreeViewer().getSelection();
                parent = (INodePO)sel.getFirstElement();
                parent = TestCaseBP.getSpecTestCaseContainer((INodePO)parent);
            } else {
                parent = GeneralStorage.getInstance().getProject();
            }
            try {
                ISpecTestCasePO newSpecTC = TestCaseBP.createNewSpecTestCase((String)tcName, (INodePO)parent, null);
                DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)newSpecTC, DataEventDispatcher.DataState.Added, DataEventDispatcher.UpdateState.all);
            }
            catch (PMException e) {
                PMExceptionHandler.handlePMExceptionForMasterSession(e);
            }
            catch (ProjectDeletedException projectDeletedException) {
                PMExceptionHandler.handleGDProjectDeletedException();
            }
        }
    }
}

