/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jubula.client.ui.actions.AbstractAction;
import org.eclipse.jubula.client.ui.businessprocess.AbstractActionBP;
import org.eclipse.jubula.client.ui.businessprocess.ShowServerLogBP;
import org.eclipse.jubula.client.ui.editors.ISimpleEditorInput;
import org.eclipse.jubula.client.ui.editors.ServerLogInput;
import org.eclipse.jubula.client.ui.utils.Utils;
import org.eclipse.jubula.communication.message.ServerLogResponseMessage;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;

public class ShowServerLogAction
extends AbstractAction {
    private IWorkbenchWindow m_window;
    private ISimpleEditorInput m_serverLogInput = null;

    public void init(IWorkbenchWindow window) {
        this.m_window = window;
    }

    public void runWithEvent(IAction action, Event event) {
        IWorkbenchPage currentPage;
        int status;
        if (action != null && !action.isEnabled()) {
            return;
        }
        ServerLogResponseMessage response = ShowServerLogBP.getInstance().requestServerLog();
        if (response != null && (status = response.getStatus()) == 0 && (currentPage = this.m_window.getActivePage()) != null) {
            if (this.m_serverLogInput != null && currentPage.findEditor((IEditorInput)this.m_serverLogInput) != null) {
                currentPage.closeEditor(currentPage.findEditor((IEditorInput)this.m_serverLogInput), false);
            }
            this.m_serverLogInput = new ServerLogInput(response.getServerLog());
            try {
                currentPage.openEditor((IEditorInput)this.m_serverLogInput, "org.eclipse.jubula.client.ui.editors.LogViewer");
            }
            catch (PartInitException partInitException) {
                Utils.createMessageDialog(MessageIDs.E_CANNOT_OPEN_EDITOR);
            }
        }
    }

    protected AbstractActionBP getActionBP() {
        return ShowServerLogBP.getInstance();
    }
}

