/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.businessprocess;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IAUTConfigPO;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.businessprocess.AbstractActionBP;
import org.eclipse.jubula.client.ui.utils.ServerManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConnectServerBP
extends AbstractActionBP {
    private static ConnectServerBP instance = null;
    private ServerManager.Server m_currentServer = null;
    private Set<ServerManager.Server> m_serverFromPref = ServerManager.getInstance().getServers();
    private boolean m_isConnected = false;
    private boolean m_isConnecting;
    private DataEventDispatcher.IServerConnectionListener m_serverConnectionListener = new DataEventDispatcher.IServerConnectionListener(){

        public void handleServerConnStateChanged(DataEventDispatcher.ServerState state) {
            ConnectServerBP.this.m_isConnected = state == DataEventDispatcher.ServerState.Connected;
            ConnectServerBP.this.m_isConnecting = state == DataEventDispatcher.ServerState.Connecting;
            ConnectServerBP.this.setEnabledStatus();
        }
    };
    private DataEventDispatcher.IServerPrefListener m_serverPrefListener = new DataEventDispatcher.IServerPrefListener(){

        public void handlePrefServerChanged() {
            if (ConnectServerBP.this.m_currentServer != null && !ServerManager.getInstance().getServers().contains(ConnectServerBP.this.m_currentServer)) {
                ConnectServerBP.this.m_currentServer = null;
            }
            ConnectServerBP.this.setEnabledStatus();
        }
    };

    private ConnectServerBP() {
        DataEventDispatcher.getInstance().addServerConnectionListener(this.m_serverConnectionListener, true);
        DataEventDispatcher.getInstance().addServerPrefListener(this.m_serverPrefListener, true);
        this.setEnabledStatus();
    }

    public static ConnectServerBP getInstance() {
        if (instance == null) {
            instance = new ConnectServerBP();
        }
        return instance;
    }

    @Override
    public boolean isEnabled() {
        return !this.m_isConnected && !this.isServerListEmpty() && !this.m_isConnecting;
    }

    public void setCurrentServer(ServerManager.Server server) {
        this.m_currentServer = server;
        ServerManager.getInstance().setLastUsedServer(server);
        ServerManager.getInstance().storeServerList();
    }

    public ServerManager.Server getCurrentServer() {
        return this.m_currentServer;
    }

    public ServerManager.Server getWorkingServer() {
        ServerManager.Server currentServer = null;
        ServerManager.Server lastUsedServer = ServerManager.getInstance().getLastUsedServer();
        if (this.m_currentServer != null) {
            currentServer = this.m_currentServer;
        } else if (lastUsedServer != null) {
            currentServer = lastUsedServer;
        } else if (ServerManager.getInstance().getServers().size() == 1) {
            currentServer = (ServerManager.Server)ServerManager.getInstance().getServers().iterator().next();
        }
        return currentServer;
    }

    public List<IAUTConfigPO> computeUnconfiguredServers() {
        ArrayList<IAUTConfigPO> unconfServers = new ArrayList<IAUTConfigPO>();
        HashSet<IAUTConfigPO> confs = new HashSet<IAUTConfigPO>();
        IProjectPO project = GeneralStorage.getInstance().getProject();
        if (project != null) {
            Set auts = project.getAutMainList();
            for (IAUTMainPO aut : auts) {
                if (aut.getAutConfigSet().isEmpty()) continue;
                Iterator it = aut.getAutConfigSet().iterator();
                while (it.hasNext()) {
                    confs.add((IAUTConfigPO)it.next());
                }
            }
            for (IAUTConfigPO conf : confs) {
                if (!this.isUnconfiguredServer(conf.getServer())) continue;
                unconfServers.add(conf);
            }
        }
        return unconfServers;
    }

    private boolean isUnconfiguredServer(String serverName) {
        for (ServerManager.Server server : this.m_serverFromPref) {
            if (!server.getName().equals(serverName)) continue;
            return false;
        }
        return true;
    }

    private boolean isServerListEmpty() {
        return ServerManager.getInstance().getServers().isEmpty();
    }
}

