/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.businessprocess;

import org.eclipse.jubula.client.core.IServerLogListener;
import org.eclipse.jubula.client.core.commands.ServerLogResponseCommand;
import org.eclipse.jubula.client.core.communication.BaseConnection;
import org.eclipse.jubula.client.core.communication.ServerConnection;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.ui.businessprocess.AbstractActionBP;
import org.eclipse.jubula.client.ui.utils.Utils;
import org.eclipse.jubula.communication.ICommand;
import org.eclipse.jubula.communication.message.Message;
import org.eclipse.jubula.communication.message.SendServerLogMessage;
import org.eclipse.jubula.communication.message.ServerLogResponseMessage;
import org.eclipse.jubula.tools.exception.CommunicationException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.utils.TimeUtil;

public final class ShowServerLogBP
extends AbstractActionBP
implements DataEventDispatcher.IServerConnectionListener,
IServerLogListener {
    private static final int TIMEOUT = 3000;
    private static ShowServerLogBP instance = null;
    private boolean m_isConnectedToServer = false;
    private ServerLogResponseMessage m_response = null;

    private ShowServerLogBP() {
        DataEventDispatcher.getInstance().addServerConnectionListener((DataEventDispatcher.IServerConnectionListener)this, true);
    }

    public static ShowServerLogBP getInstance() {
        if (instance == null) {
            instance = new ShowServerLogBP();
        }
        return instance;
    }

    public void handleServerConnStateChanged(DataEventDispatcher.ServerState state) {
        this.m_isConnectedToServer = state == DataEventDispatcher.ServerState.Connected;
        this.setEnabledStatus();
    }

    public boolean isEnabled() {
        return this.m_isConnectedToServer;
    }

    public void processServerLog(ServerLogResponseMessage response) {
        this.m_response = response;
    }

    public ServerLogResponseMessage requestServerLog() {
        ServerLogResponseCommand request = new ServerLogResponseCommand((IServerLogListener)this);
        SendServerLogMessage message = new SendServerLogMessage();
        try {
            ServerConnection.getInstance().request((Message)message, (ICommand)request, 3000);
        }
        catch (BaseConnection.NotConnectedException notConnectedException) {
            Utils.createMessageDialog(MessageIDs.E_NO_SERVER_CONNECTION_INIT);
        }
        catch (CommunicationException communicationException) {
            Utils.createMessageDialog(MessageIDs.E_MESSAGE_REQUEST);
        }
        int waited = 0;
        while (this.m_response == null && waited <= 3000) {
            TimeUtil.delay((long)200L);
            waited += 200;
        }
        ServerLogResponseMessage responseToReturn = this.m_response;
        this.m_response = null;
        this.handleServerRequestErrors(responseToReturn);
        return responseToReturn;
    }

    private void handleServerRequestErrors(ServerLogResponseMessage response) {
        if (response != null) {
            int status = response.getStatus();
            if (status == 1) {
                Utils.createMessageDialog(MessageIDs.I_FILE_LOGGING_NOT_ENABLED, (Object[])new String[]{"AUT Agent"}, null);
            } else if (status == 2) {
                Utils.createMessageDialog(MessageIDs.E_FILE_NOT_FOUND);
            } else if (status == 3) {
                Utils.createMessageDialog(MessageIDs.E_IO_EXCEPTION);
            } else if (status == 4) {
                Utils.createMessageDialog(MessageIDs.E_CONFIG_ERROR);
            }
        } else {
            Utils.createMessageDialog(MessageIDs.E_MESSAGE_REQUEST);
        }
    }
}

