/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.command.parameters;

import org.apache.commons.lang.Validate;
import org.eclipse.core.commands.ParameterValueConversionException;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.ui.i18n.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterValueConverterUtil {
    private ParameterValueConverterUtil() {
    }

    public static long parseId(String idString) throws ParameterValueConversionException {
        try {
            return Long.parseLong(idString);
        }
        catch (NumberFormatException nfe) {
            throw new ParameterValueConversionException(Messages.ParameterValueMustBeAValidID, (Throwable)nfe);
        }
    }

    public static void checkType(Object parameterValue, Class<? extends Object> type) throws ParameterValueConversionException {
        Validate.notNull(type);
        if (!type.isInstance(parameterValue)) {
            throw new ParameterValueConversionException(String.valueOf(Messages.ParameterValueMustBeOfType) + ":" + " " + type.getName());
        }
    }

    public static String getIdString(IPersistentObject po) {
        return po.getId() != null ? po.getId().toString() : null;
    }
}

