/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.constants;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.utils.Utils;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class Layout {
    public static final int ZERO = 0;
    public static final int SMALL = 10;
    public static final int BIG = 15;
    public static final int WIDTH = 30;
    public static final int SMALL_MARGIN_WIDTH = 10;
    public static final int BIG_MARGIN_WIDTH = 15;
    public static final int SMALL_MARGIN_HEIGHT = 10;
    public static final int BIG_MARGIN_HEIGHT = 15;
    public static final int SMALL_HORIZONTAL_SPACING = 10;
    public static final int BIG_HORIZONTAL_SPACING = 15;
    public static final int SMALL_VERTICAL_SPACING = 10;
    public static final int BIG_VERTICAL_SPACING = 15;
    public static final int HORIZONTAL_ALIGNMENT = 4;
    public static final int LABEL_HORIZONTAL_ALIGNMENT = 0x1000008;
    public static final int MULTI_COLUMN_LABEL_HORIZONTAL_ALIGNMENT = 1;
    public static final int TEXT_HORIZONTAL_ALIGNMENT = 1;
    public static final int MULTI_LINE_TEXT_HORIZONTAL_ALIGNMENT = 4;
    public static final int VERTICAL_ALIGNMENT = 0x1000000;
    public static final int SINGLE_TEXT_STYLE = 2052;
    public static final int MULTI_TEXT_STYLE = 2818;
    public static final int MULTI_TEXT = 66;
    public static final int MARGIN_WIDTH = 2;
    public static final int MARGIN_HEIGHT = 2;
    public static final Color WHITE_COLOR = Display.getDefault().getSystemColor(1);
    public static final Color GRAY_COLOR = new Color((Device)Plugin.getDisplay(), new RGB(100, 100, 100));
    public static final Color LIGHT_GRAY_COLOR = Display.getDefault().getSystemColor(22);
    public static final Color GREEN_COLOR = Display.getDefault().getSystemColor(5);
    public static final Color RED_COLOR = Display.getDefault().getSystemColor(3);
    public static final Color YELLOW_COLOR = Display.getDefault().getSystemColor(7);
    public static final Color ERROR_COLOR = RED_COLOR;
    public static final Color INACTIVE_COLOR = Display.getDefault().getSystemColor(6);
    public static final Color HAS_DETAILS_COLOR = new Color((Device)Plugin.getDisplay(), new RGB(170, 211, 255));
    public static final Color DEFAULT_OS_COLOR = null;
    public static final RGB CLIENT_LIGHT_RED = new RGB(255, 204, 230);
    public static final Color TOOLTIP_COLOR = new Color((Device)Plugin.getDisplay(), CLIENT_LIGHT_RED);
    public static final String FONT_NAME = "Tahoma";
    public static final int FONT_HEIGHT = 9;
    public static final Font BOLD_TAHOMA = new Font(null, "Tahoma", 9, 1);
    public static final Font BOLD_ITALIC_TAHOMA = new Font(null, "Tahoma", 9, 3);
    public static final Font ITALIC_TAHOMA = new Font(null, "Tahoma", 9, 2);
    public static final Font NORMAL_TAHOMA = new Font(null, "Tahoma", 9, 0);

    private Layout() {
    }

    public static GridLayout createDefaultGridLayout(int numColumns) {
        GridLayout result = new GridLayout();
        result.numColumns = numColumns;
        result.horizontalSpacing = 10;
        result.verticalSpacing = 10;
        result.marginWidth = 10;
        result.marginHeight = 10;
        return result;
    }

    public static void setMaxChar(Text textField) {
        Layout.setMaxChar(textField, 255);
    }

    public static void setMaxChar(Text textField, final int maxLength) {
        if (textField == null) {
            return;
        }
        textField.setTextLimit(maxLength);
        textField.addModifyListener(new ModifyListener(textField){
            private String m_oldValue;
            {
                this.m_oldValue = text.getText();
            }

            public void modifyText(ModifyEvent e) {
                Text theWidget = (Text)e.widget;
                if (theWidget.getCharCount() >= maxLength) {
                    Utils.createMessageDialog(MessageIDs.W_MAX_CHAR, new Object[]{maxLength}, null);
                    theWidget.setText(this.m_oldValue);
                }
                this.m_oldValue = theWidget.getText();
            }
        });
    }

    public static void addToolTipAndMaxWidth(GridData gridData, final Control control) {
        gridData.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)Layout.getFontMetrics(control), (int)30);
        control.addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent e) {
                String toolTipText = "";
                if (control instanceof Combo) {
                    toolTipText = ((Combo)control).getText();
                } else if (control instanceof Text) {
                    toolTipText = ((Text)control).getText();
                } else {
                    return;
                }
                int width = Dialog.convertWidthInCharsToPixels((FontMetrics)Layout.getFontMetrics(control), (int)toolTipText.length());
                if (width > control.getBounds().width) {
                    control.setToolTipText(toolTipText);
                }
            }

            public void mouseExit(MouseEvent e) {
                control.setToolTipText("");
            }

            public void mouseHover(MouseEvent e) {
            }
        });
    }

    public static Control createGridSmallSkip(Composite parent, int numColumns) {
        Label result = new Label(parent, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        gd.heightHint = 10;
        result.setLayoutData((Object)gd);
        return result;
    }

    public static Control createGridBigSkip(Composite parent, int numColumns) {
        Label result = new Label(parent, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        gd.heightHint = 15;
        result.setLayoutData((Object)gd);
        return result;
    }

    public static GridData createDefaultLabelGridData() {
        GridData result = new GridData();
        result.horizontalAlignment = 0x1000008;
        result.verticalAlignment = 0x1000000;
        result.horizontalSpan = 1;
        result.verticalSpan = 1;
        return result;
    }

    public static GridData createMultiColumnLabelGridData() {
        GridData result = new GridData();
        result.horizontalAlignment = 1;
        result.verticalAlignment = 0x1000000;
        result.horizontalSpan = 1;
        result.verticalSpan = 1;
        result.horizontalIndent = 15;
        return result;
    }

    public static GridData createTopLabelGridData() {
        GridData result = new GridData();
        result.horizontalAlignment = 0x1000008;
        result.verticalAlignment = 1;
        result.horizontalSpan = 1;
        result.verticalSpan = 1;
        return result;
    }

    public static GridData createDefaultTextGridData() {
        return Layout.createDefaultTextGridData(1);
    }

    public static GridData createDefaultTextGridData(int numColumns) {
        GridData result = Layout.createTextGridData();
        result.horizontalSpan = numColumns;
        return result;
    }

    public static GridData createDefaultTextGridData(Control control, int numChars) {
        GridData result = new GridData();
        result.horizontalAlignment = 1;
        result.verticalAlignment = 0x1000000;
        result.horizontalSpan = 1;
        result.verticalSpan = 1;
        result.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)Layout.getFontMetrics(control), (int)numChars);
        return result;
    }

    public static GridData createMultiLineTextGridData(Control control, int numLines) {
        GridData result = new GridData();
        result.horizontalAlignment = 4;
        result.verticalAlignment = 0x1000000;
        result.horizontalSpan = 1;
        result.verticalSpan = 1;
        result.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)Layout.getFontMetrics(control), (int)numLines);
        return result;
    }

    private static GridData createTextGridData() {
        GridData result = new GridData();
        result.horizontalAlignment = 4;
        result.verticalAlignment = 0x1000000;
        result.verticalSpan = 1;
        return result;
    }

    public static FontMetrics getFontMetrics(Control control) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        return fontMetrics;
    }
}

