/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.controllers;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.businessprocess.TestExecution;
import org.eclipse.jubula.client.core.commands.AUTModeChangedCommand;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.ui.actions.OMMarkInAutAction;
import org.eclipse.jubula.client.ui.actions.OMSetCategoryToMapInto;
import org.eclipse.jubula.client.ui.editors.ObjectMappingMultiPageEditor;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class JubulaStateController {
    private static JubulaStateController instance;
    private IWorkbenchPart m_lastPart = null;
    private ISelection m_lastSelection = null;
    private ISelectionListener m_selListener;

    private JubulaStateController() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().addPartListener(new IPartListener(){

            public void partActivated(IWorkbenchPart part) {
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
                JubulaStateController.this.removeSelectionListenerFromSelectionService();
            }

            public void partOpened(IWorkbenchPart part) {
            }
        });
    }

    public static JubulaStateController getInstance() {
        if (instance == null) {
            instance = new JubulaStateController();
        }
        return instance;
    }

    public void addSelectionListenerToSelectionService() {
        this.m_selListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                JubulaStateController.this.reactOnChange(part, selection);
            }
        };
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().addSelectionListener(this.m_selListener);
    }

    public void removeSelectionListenerFromSelectionService() {
        if (this.m_selListener != null) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().removeSelectionListener(this.m_selListener);
        }
    }

    void reactOnChange(IWorkbenchPart part, ISelection sel) {
        if (part.equals(this.m_lastPart) && sel.equals(this.m_lastSelection) && this.m_lastPart != null && this.m_lastSelection != null) {
            return;
        }
        this.m_lastPart = part;
        this.m_lastSelection = sel;
        if (!"org.eclipse.ui.views.ProblemView".equals(part.getSite().getId())) {
            this.checkGlobalActions();
        }
        if (sel instanceof IStructuredSelection && ((IStructuredSelection)sel).size() > 0) {
            IStructuredSelection structuredSel = (IStructuredSelection)sel;
            if (part instanceof ObjectMappingMultiPageEditor) {
                this.checkObjectMappingEditor(part, structuredSel);
            }
        }
    }

    private void checkGlobalActions() {
        this.checkAutState();
    }

    private void checkObjectMappingEditor(IWorkbenchPart part, IStructuredSelection sel) {
        IAUTMainPO connectedAut;
        if (sel.size() == 1 && !(sel.getFirstElement() instanceof IObjectMappingAssoziationPO)) {
            OMMarkInAutAction.setEnabled(false);
        }
        if ((connectedAut = TestExecution.getInstance().getConnectedAut()) != null) {
            ObjectMappingMultiPageEditor editor = (ObjectMappingMultiPageEditor)part;
            switch (AUTModeChangedCommand.getAutMode()) {
                case 2: {
                    if (editor.getAut().equals(connectedAut)) {
                        OMSetCategoryToMapInto.setEnabled(true);
                        break;
                    }
                }
                default: {
                    OMSetCategoryToMapInto.setEnabled(false);
                }
            }
        }
    }

    private void checkAutState() {
    }
}

