/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.controllers;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.PMAlreadyLockedException;
import org.eclipse.jubula.client.core.persistence.PMDirtyVersionException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PMExtProjDeletedException;
import org.eclipse.jubula.client.core.persistence.PMObjectDeletedException;
import org.eclipse.jubula.client.core.persistence.PMSaveException;
import org.eclipse.jubula.client.ui.actions.AbstractAction;
import org.eclipse.jubula.client.ui.editors.IJBEditor;
import org.eclipse.jubula.client.ui.handlers.project.RefreshProjectHandler;
import org.eclipse.jubula.client.ui.utils.Utils;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class PMExceptionHandler {
    private PMExceptionHandler() {
    }

    public static void handlePMExceptionForMasterSession(PMException e) {
        if (e instanceof PMDirtyVersionException || e instanceof PMObjectDeletedException || e instanceof PMSaveException) {
            Utils.createMessageDialog(e.getErrorId());
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, false, (IRunnableWithProgress)new RefreshProjectHandler.RefreshProjectOperation());
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
        } else if (e instanceof PMExtProjDeletedException) {
            Utils.createMessageDialog(e.getErrorId());
        } else if (e instanceof PMAlreadyLockedException) {
            boolean result = false;
            if (((PMAlreadyLockedException)((Object)e)).getLockedObject() != null) {
                result = AbstractAction.handleLockedObject(((PMAlreadyLockedException)((Object)e)).getLockedObject());
            }
            if (!result) {
                Utils.createMessageDialog(e.getErrorId());
            }
        } else {
            GeneralStorage.handleFatalError((Throwable)e);
        }
    }

    public static void handlePMExceptionForEditor(PMException exc, IJBEditor editor) {
        if (exc instanceof PMDirtyVersionException || exc instanceof PMObjectDeletedException) {
            Utils.createMessageDialog((JBException)((Object)exc));
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, false, (IRunnableWithProgress)new RefreshProjectHandler.RefreshProjectOperation());
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
        } else if (exc instanceof PMAlreadyLockedException) {
            PMExceptionHandler.handlePMAlreadyLockedException((PMAlreadyLockedException)((Object)exc), null);
        } else if (exc instanceof PMObjectDeletedException) {
            Utils.createMessageDialog(MessageIDs.E_DELETED_OBJECT);
        } else {
            Utils.createMessageDialog(MessageIDs.E_DATABASE_GENERAL);
            if (editor != null) {
                editor.getSite().getPage().closeEditor((IEditorPart)editor, false);
            }
        }
    }

    public static void handlePMAlreadyLockedException(PMAlreadyLockedException exc, String[] details) {
        Utils.createMessageDialog((JBException)((Object)exc), null, details);
    }

    public static void handleGDProjectDeletedException() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                IProjectPO oldProj = GeneralStorage.getInstance().getProject();
                Utils.createMessageDialog(MessageIDs.E_CURRENT_PROJ_DEL);
                Utils.clearClient();
                GeneralStorage.getInstance().setProject(null);
                if (oldProj != null) {
                    DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)oldProj, DataEventDispatcher.DataState.Deleted, DataEventDispatcher.UpdateState.all);
                }
            }
        });
    }
}

