/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.controllers.dnd;

import java.util.Iterator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public class LocalSelectionClipboardTransfer
extends ByteArrayTransfer {
    private static final String TYPE_NAME = "local-selection-transfer-format" + new Long(System.currentTimeMillis()).toString();
    private static final int TYPEID = LocalSelectionClipboardTransfer.registerType((String)TYPE_NAME);
    private static final LocalSelectionClipboardTransfer INSTANCE = new LocalSelectionClipboardTransfer();
    private StructuredViewer m_source;
    private StructuredViewer[] m_otherViewersToRefresh = new StructuredViewer[0];
    private IStructuredSelection m_selection;

    private LocalSelectionClipboardTransfer() {
    }

    public static LocalSelectionClipboardTransfer getInstance() {
        return INSTANCE;
    }

    public IStructuredSelection getSelection() {
        return this.m_selection;
    }

    private boolean isInvalidNativeType(Object result) {
        return !(result instanceof byte[]) || !TYPE_NAME.equals(new String((byte[])result));
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    public void javaToNative(Object object, TransferData transferData) {
        byte[] check = TYPE_NAME.getBytes();
        super.javaToNative((Object)check, transferData);
    }

    public Object nativeToJava(TransferData transferData) {
        Object result = super.nativeToJava(transferData);
        if (this.isInvalidNativeType(result)) {
            this.isInvalidNativeType(result);
        }
        return this.m_selection;
    }

    public void setSelection(IStructuredSelection sel, StructuredViewer source) {
        this.setSelection(sel, source, null);
    }

    public void setSelection(IStructuredSelection sel, StructuredViewer source, StructuredViewer[] otherViewersToRefresh) {
        StructuredViewer toRefresh;
        int n;
        int n2;
        StructuredViewer[] structuredViewerArray;
        IStructuredSelection oldSelection = this.getSelection();
        StructuredViewer oldSource = this.getSource();
        StructuredViewer[] oldViewersToRefresh = this.getOtherViewersToRefresh();
        this.setSelection(sel);
        this.setSource(source);
        this.setOtherViewersToRefresh(otherViewersToRefresh);
        if (oldSource != null && !oldSource.getControl().isDisposed()) {
            oldSource.update(oldSelection.toArray(), null);
            structuredViewerArray = oldViewersToRefresh;
            n2 = oldViewersToRefresh.length;
            n = 0;
            while (n < n2) {
                toRefresh = structuredViewerArray[n];
                if (toRefresh != oldSource) {
                    toRefresh.update(oldSelection.toArray(), null);
                }
                ++n;
            }
        }
        if (source != null) {
            source.update(sel.toArray(), null);
            structuredViewerArray = this.getOtherViewersToRefresh();
            n2 = structuredViewerArray.length;
            n = 0;
            while (n < n2) {
                toRefresh = structuredViewerArray[n];
                if (toRefresh != source) {
                    toRefresh.update(sel.toArray(), null);
                }
                ++n;
            }
        }
    }

    private void setSelection(IStructuredSelection sel) {
        this.m_selection = sel;
    }

    public boolean hasSingleClassType() {
        Class<?> classType = null;
        for (Object obj : this.getSelection()) {
            if (classType == null) {
                classType = obj.getClass();
            }
            if (obj.getClass() == classType) continue;
            return false;
        }
        return true;
    }

    public StructuredViewer getSource() {
        return this.m_source;
    }

    private void setSource(StructuredViewer source) {
        this.m_source = source;
    }

    private StructuredViewer[] getOtherViewersToRefresh() {
        return this.m_otherViewersToRefresh;
    }

    private void setOtherViewersToRefresh(StructuredViewer[] otherViewersToRefresh) {
        this.m_otherViewersToRefresh = otherViewersToRefresh != null ? otherViewersToRefresh : new StructuredViewer[]{};
    }

    public boolean containsOnlyType(Class supportedClass) {
        Iterator iter = this.getSelection().iterator();
        while (iter.hasNext()) {
            if (supportedClass.isInstance(iter.next())) continue;
            return false;
        }
        return true;
    }
}

