/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.controllers.dnd;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.businessprocess.db.NodeBP;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.persistence.MultipleNodePM;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.views.TestCaseBrowser;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;
import org.eclipse.ui.IViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCBrowserDndSupport {
    private TCBrowserDndSupport() {
    }

    public static boolean canMove(IStructuredSelection selection, Object target) {
        for (Object obj : selection) {
            if (!(obj instanceof ISpecTestCasePO) && !(obj instanceof ICategoryPO) || obj instanceof INodePO && !NodeBP.isEditable((INodePO)((INodePO)obj))) {
                return false;
            }
            if (!(target instanceof ICategoryPO) && !(target instanceof IProjectPO) || target instanceof INodePO && !NodeBP.isEditable((INodePO)((INodePO)target))) {
                return false;
            }
            if (!((INodePO)obj).hasCircularDependences((INodePO)target)) continue;
            return false;
        }
        return true;
    }

    public static void moveNodes(List<INodePO> nodesToBeMoved, INodePO target) throws PMException, ProjectDeletedException {
        if (TCBrowserDndSupport.getSpecView() != null) {
            TCBrowserDndSupport.doMove(nodesToBeMoved, target);
        }
    }

    private static void doMove(List<INodePO> nodes, INodePO target) throws PMException, ProjectDeletedException {
        ArrayList<MultipleNodePM.MoveNodeHandle> cmds = new ArrayList<MultipleNodePM.MoveNodeHandle>();
        for (INodePO nodeToMove : nodes) {
            INodePO oldParent = nodeToMove.getParentNode();
            cmds.add(new MultipleNodePM.MoveNodeHandle(nodeToMove, (IPersistentObject)oldParent, (IPersistentObject)target));
        }
        MultipleNodePM.getInstance().executeCommands(cmds);
    }

    private static TestCaseBrowser getSpecView() {
        IViewPart viewPart = Plugin.getView("org.eclipse.jubula.client.ui.views.TestCaseBrowser");
        if (viewPart != null) {
            return (TestCaseBrowser)viewPart;
        }
        return null;
    }
}

