/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.controllers.dnd;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jubula.client.core.businessprocess.db.TestCaseBP;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.core.persistence.PMAlreadyLockedException;
import org.eclipse.jubula.client.core.persistence.PMDirtyVersionException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.controllers.dnd.LocalSelectionTransfer;
import org.eclipse.jubula.client.ui.editors.AbstractTestCaseEditor;
import org.eclipse.jubula.client.ui.editors.JBEditorHelper;
import org.eclipse.jubula.client.ui.editors.NodeEditorInput;
import org.eclipse.jubula.client.ui.views.TestCaseBrowser;
import org.eclipse.ui.IViewPart;

public class TCEditorDndSupport {
    private TCEditorDndSupport() {
    }

    public static boolean performDrop(AbstractTestCaseEditor targetEditor, IStructuredSelection toDrop, INodePO dropTarget, int dropPosition) {
        if (targetEditor.getEditorHelper().requestEditableState() != JBEditorHelper.EditableState.OK) {
            return false;
        }
        List selectedElements = toDrop.toList();
        Collections.reverse(selectedElements);
        Iterator iter = selectedElements.iterator();
        while (iter.hasNext()) {
            INodePO target;
            INodePO droppedNode = null;
            Object obj = iter.next();
            if (!(obj instanceof INodePO)) {
                return false;
            }
            INodePO node = (INodePO)obj;
            if ((node instanceof ICapPO || node instanceof IExecTestCasePO) && (target = dropTarget) != node && (target instanceof ICapPO || target instanceof IExecTestCasePO)) {
                droppedNode = TCEditorDndSupport.moveNode(node, target);
            }
            if (node instanceof ISpecTestCasePO && !TCEditorDndSupport.performDrop(targetEditor, dropTarget, dropPosition, (ISpecTestCasePO)node)) {
                return false;
            }
            TCEditorDndSupport.postDropAction(droppedNode, targetEditor);
        }
        return true;
    }

    private static boolean performDrop(AbstractTestCaseEditor targetEditor, INodePO dropTarget, int dropPosition, ISpecTestCasePO toDrop) {
        INodePO target = dropTarget;
        if (target != toDrop) {
            EditSupport editSupport = targetEditor.getEditorHelper().getEditSupport();
            try {
                if (target instanceof ICapPO || target instanceof IExecTestCasePO) {
                    TCEditorDndSupport.dropOnCAPorExecTc(editSupport, (INodePO)toDrop, target, dropPosition);
                } else if (target instanceof ISpecTestCasePO) {
                    TCEditorDndSupport.dropOnSpecTc(editSupport, (INodePO)toDrop, target);
                } else if (target instanceof ITestSuitePO) {
                    TCEditorDndSupport.dropOnTestsuite(editSupport, (ITestSuitePO)target, toDrop);
                }
            }
            catch (PMException e) {
                NodeEditorInput inp = (NodeEditorInput)targetEditor.getAdapter(NodeEditorInput.class);
                INodePO inpNode = inp.getNode();
                PMExceptionHandler.handlePMExceptionForMasterSession(e);
                if (!(e instanceof PMAlreadyLockedException) || ((PMAlreadyLockedException)((Object)e)).getLockedObject() == null || ((PMAlreadyLockedException)((Object)e)).getLockedObject().equals(inpNode) || !targetEditor.isDirty()) {
                    try {
                        targetEditor.reOpenEditor((IPersistentObject)inpNode);
                    }
                    catch (PMException pMException) {
                        PMExceptionHandler.handlePMExceptionForEditor(e, targetEditor);
                    }
                }
                return false;
            }
        }
        return true;
    }

    public static boolean validateDrop(Viewer sourceViewer, Viewer targetViewer, IStructuredSelection toDrop, INodePO dropTarget, boolean allowFromBrowser) {
        if (toDrop == null || toDrop.isEmpty() || dropTarget == null) {
            return false;
        }
        if (sourceViewer != null && !sourceViewer.equals(targetViewer)) {
            if (TCEditorDndSupport.getTCBrowser() != null) {
                if (!allowFromBrowser || !sourceViewer.equals(TCEditorDndSupport.getTCBrowser().getTreeViewer())) {
                    return false;
                }
            } else {
                return false;
            }
        }
        for (Object obj : toDrop) {
            ISpecTestCasePO childGUI;
            if (!(obj instanceof INodePO)) {
                return false;
            }
            INodePO transferGUI = (INodePO)obj;
            INodePO parentNode = transferGUI.getParentNode();
            if (!(parentNode instanceof ISpecTestCasePO || parentNode instanceof IProjectPO || parentNode instanceof ICategoryPO)) {
                return false;
            }
            if (!(transferGUI instanceof ISpecTestCasePO) && transferGUI.getParentNode() != dropTarget.getParentNode()) {
                return false;
            }
            ISpecTestCasePO specTcGUI = !(dropTarget instanceof ISpecTestCasePO) ? (ISpecTestCasePO)dropTarget.getParentNode() : (ISpecTestCasePO)dropTarget;
            if (!(transferGUI instanceof ISpecTestCasePO) || !(childGUI = (ISpecTestCasePO)transferGUI).hasCircularDependences((INodePO)specTcGUI)) continue;
            return false;
        }
        return true;
    }

    static TestCaseBrowser getTCBrowser() {
        IViewPart viewPart = Plugin.getView("org.eclipse.jubula.client.ui.views.TestCaseBrowser");
        if (viewPart != null) {
            return (TestCaseBrowser)viewPart;
        }
        return null;
    }

    private static void dropOnSpecTc(EditSupport editSupport, INodePO node, INodePO target) throws PMAlreadyLockedException, PMDirtyVersionException, PMException {
        TestCaseBP.addReferencedTestCase((EditSupport)editSupport, (INodePO)target, (ISpecTestCasePO)((ISpecTestCasePO)node), (Integer)0);
    }

    private static void dropOnTestsuite(EditSupport editSupport, ITestSuitePO testSuite, ISpecTestCasePO testcase) throws PMAlreadyLockedException, PMDirtyVersionException, PMException {
        TestCaseBP.addReferencedTestCase((EditSupport)editSupport, (INodePO)testSuite, (ISpecTestCasePO)testcase, (Integer)0);
    }

    private static void dropOnCAPorExecTc(EditSupport editSupport, INodePO node, INodePO target, int location) throws PMAlreadyLockedException, PMDirtyVersionException, PMException {
        ISpecTestCasePO specTcGUItoDrop = (ISpecTestCasePO)node;
        INodePO parentGUI = target.getParentNode();
        int position = parentGUI.indexOf(target);
        if (location != 1) {
            ++position;
        }
        TestCaseBP.addReferencedTestCase((EditSupport)editSupport, (INodePO)parentGUI, (ISpecTestCasePO)specTcGUItoDrop, (Integer)position);
    }

    private static INodePO moveNode(INodePO node, INodePO target) {
        int newPos = target.getParentNode().indexOf(target);
        node.getParentNode().removeNode(node);
        target.getParentNode().addNode(newPos, node);
        return node;
    }

    private static void postDropAction(INodePO node, AbstractTestCaseEditor targetEditor) {
        targetEditor.setFocus();
        if (node != null) {
            targetEditor.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)node));
        }
        targetEditor.getTreeViewer().refresh();
        targetEditor.getEditorHelper().setDirty(true);
        LocalSelectionTransfer.getInstance().setSelection(null);
    }
}

