/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.controllers.dnd;

import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IRefTestSuitePO;
import org.eclipse.jubula.client.core.model.ITestJobPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.PMAlreadyLockedException;
import org.eclipse.jubula.client.core.persistence.PMDirtyVersionException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PMReadException;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.controllers.dnd.LocalSelectionTransfer;
import org.eclipse.jubula.client.ui.editors.JBEditorHelper;
import org.eclipse.jubula.client.ui.editors.NodeEditorInput;
import org.eclipse.jubula.client.ui.editors.TestJobEditor;
import org.eclipse.jubula.client.ui.views.TestSuiteBrowser;
import org.eclipse.ui.IViewPart;

public class TJEditorDndSupport {
    private TJEditorDndSupport() {
    }

    public static boolean performDrop(TestJobEditor targetEditor, IStructuredSelection toDrop, INodePO dropTarget, int dropPosition) {
        if (targetEditor.getEditorHelper().requestEditableState() != JBEditorHelper.EditableState.OK) {
            return false;
        }
        List selectedElements = toDrop.toList();
        Collections.reverse(selectedElements);
        for (Object obj : selectedElements) {
            INodePO target;
            INodePO node;
            ITestSuitePO testSuite;
            if (obj instanceof ITestSuitePO && dropTarget != (testSuite = (ITestSuitePO)obj)) {
                try {
                    if (dropTarget instanceof IRefTestSuitePO) {
                        TJEditorDndSupport.dropOnRefTS(testSuite, dropTarget, dropPosition);
                    } else if (dropTarget instanceof ITestJobPO) {
                        TJEditorDndSupport.dropOnTJ(testSuite, dropTarget);
                    }
                }
                catch (PMException e) {
                    NodeEditorInput inp = (NodeEditorInput)targetEditor.getAdapter(NodeEditorInput.class);
                    INodePO inpNode = inp.getNode();
                    PMExceptionHandler.handlePMExceptionForMasterSession(e);
                    if (!(e instanceof PMAlreadyLockedException) || ((PMAlreadyLockedException)((Object)e)).getLockedObject() == null || ((PMAlreadyLockedException)((Object)e)).getLockedObject().equals(inpNode) || !targetEditor.isDirty()) {
                        try {
                            targetEditor.reOpenEditor((IPersistentObject)inpNode);
                        }
                        catch (PMException pMException) {
                            PMExceptionHandler.handlePMExceptionForEditor(e, targetEditor);
                        }
                    }
                    return false;
                }
            }
            if (!(obj instanceof INodePO) || !((node = (INodePO)obj) instanceof IRefTestSuitePO) || (target = dropTarget) == node || !(target instanceof IRefTestSuitePO)) continue;
            INodePO droppedNode = TJEditorDndSupport.moveNode(node, target);
            TJEditorDndSupport.postDropAction(droppedNode, targetEditor);
        }
        return true;
    }

    public static boolean validateDrop(Viewer sourceViewer, Viewer targetViewer, IStructuredSelection toDrop, INodePO dropTarget, boolean allowFromBrowser) {
        if (toDrop == null || toDrop.isEmpty() || dropTarget == null) {
            return false;
        }
        if (sourceViewer != null && !sourceViewer.equals(targetViewer)) {
            if (TJEditorDndSupport.getTSBrowser() != null) {
                if (!allowFromBrowser || !sourceViewer.equals(TJEditorDndSupport.getTSBrowser().getTreeViewer())) {
                    return false;
                }
            } else {
                return false;
            }
        }
        Object[] objectArray = toDrop.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object toDropElement = objectArray[n2];
            if (!(toDropElement instanceof ITestSuitePO) && !(toDropElement instanceof IRefTestSuitePO)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    static TestSuiteBrowser getTSBrowser() {
        IViewPart viewPart = Plugin.getView("org.eclipse.jubula.client.ui.views.TestSuiteBrowser");
        if (viewPart != null) {
            return (TestSuiteBrowser)viewPart;
        }
        return null;
    }

    private static void dropOnTJ(ITestSuitePO node, INodePO target) throws PMReadException, PMAlreadyLockedException, PMDirtyVersionException, PMException {
        if (TJEditorDndSupport.getTSBrowser() != null) {
            TJEditorDndSupport.getTSBrowser().addReferencedTestSuite(node, target, 0);
        }
    }

    private static void dropOnRefTS(ITestSuitePO node, INodePO target, int location) throws PMReadException, PMAlreadyLockedException, PMDirtyVersionException, PMException {
        INodePO parentGUI = target.getParentNode();
        int position = parentGUI.indexOf(target);
        if (location != 1) {
            ++position;
        }
        TJEditorDndSupport.getTSBrowser().addReferencedTestSuite(node, parentGUI, position);
    }

    private static INodePO moveNode(INodePO node, INodePO target) {
        int newPos = target.getParentNode().indexOf(target);
        node.getParentNode().removeNode(node);
        target.getParentNode().addNode(newPos, node);
        return node;
    }

    private static void postDropAction(INodePO node, TestJobEditor targetEditor) {
        targetEditor.setFocus();
        if (node != null) {
            targetEditor.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)node));
        }
        targetEditor.getTreeViewer().refresh();
        targetEditor.getEditorHelper().setDirty(true);
        LocalSelectionTransfer.getInstance().setSelection(null);
    }
}

