/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.controllers.propertysources;

import org.eclipse.jubula.client.core.model.IAUTConfigPO;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.tools.registration.AutIdentifier;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class AutIdentifierPropertySource
implements IPropertySource {
    private static final String PROP_MATCHED_AUT = "matchedAut";
    private AutIdentifier m_autId;
    private IPropertyDescriptor[] m_descriptors = null;

    public AutIdentifierPropertySource(AutIdentifier autId) {
        this.m_autId = autId;
    }

    public Object getEditableValue() {
        return this.m_autId;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.m_descriptors == null) {
            this.m_descriptors = new IPropertyDescriptor[]{new PropertyDescriptor((Object)"executableName", Messages.AutIdentifierPropertySourcePropertyLabelExecutable), new PropertyDescriptor((Object)PROP_MATCHED_AUT, Messages.AutIdentifierPropertySourcePropertyLabelMatchedAut)};
        }
        return this.m_descriptors;
    }

    public Object getPropertyValue(Object id) {
        if ("executableName".equals(id)) {
            return this.m_autId.getExecutableName();
        }
        if (PROP_MATCHED_AUT.equals(id)) {
            IProjectPO currentProject = GeneralStorage.getInstance().getProject();
            String runningAutId = this.m_autId.getExecutableName();
            if (runningAutId != null && currentProject != null) {
                for (IAUTMainPO aut : currentProject.getAutMainList()) {
                    if (aut.getAutIds().contains(runningAutId)) {
                        return aut.getName();
                    }
                    for (IAUTConfigPO autConfig : aut.getAutConfigSet()) {
                        if (!runningAutId.equals(autConfig.getConfigMap().get("AUT_ID"))) continue;
                        return aut.getName();
                    }
                }
            }
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

