/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.controllers.propertysources;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.ReentryProperty;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.utils.StringHelper;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.controllers.propertydescriptors.IntegerTextPropertyDescriptor;
import org.eclipse.jubula.client.ui.controllers.propertysources.AbstractGuiNodePropertySource;
import org.eclipse.jubula.client.ui.controllers.propertysources.AbstractPropertySource;
import org.eclipse.jubula.client.ui.editors.AbstractJBEditor;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.tools.exception.Assert;
import org.eclipse.jubula.tools.exception.InvalidDataException;
import org.eclipse.jubula.tools.i18n.I18n;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSuiteGUIPropertySource
extends AbstractGuiNodePropertySource {
    private static final String P_SUITENAME_DISPLAY_NAME = Messages.TestSuiteGUIPropertySourceTestSuiteName;
    private static final String P_AUT_DISPLAY_NAME = Messages.TestSuiteGUIPropertySourceAUTName;
    private static final String P_STEPDELAY_DISPLAY_NAME = Messages.TestSuiteGUIPropertySourceStepDelay;
    private static final String P_EVENTHANDLER_CAT = Messages.TestSuiteGUIPropertySourceEventHandler;
    private String[] m_autNameList = new String[0];
    private IAUTMainPO[] m_autSubList = new IAUTMainPO[0];
    private String[] m_reentryTypeList = new String[0];
    private IProjectPO m_project = GeneralStorage.getInstance().getProject();
    private IPropertyDescriptor m_namePropDesc = null;
    private IPropertyDescriptor m_stepDelayPropDesc = null;
    private IPropertyDescriptor m_autPropDesc = null;
    private List<IPropertyDescriptor> m_eventHandlerDescriptors = new ArrayList<IPropertyDescriptor>();

    public TestSuiteGUIPropertySource(ITestSuitePO testSuite) {
        super((INodePO)testSuite);
        this.initAUTList();
        this.initPropDescriptor();
    }

    @Override
    protected void initPropDescriptor() {
        if (!this.getPropertyDescriptorList().isEmpty()) {
            this.clearPropertyDescriptors();
        }
        if (this.m_namePropDesc == null) {
            this.m_namePropDesc = new TextPropertyDescriptor((Object)new AbstractGuiNodePropertySource.ElementNameController(), P_SUITENAME_DISPLAY_NAME);
        }
        this.addPropertyDescriptor(this.m_namePropDesc);
        super.initPropDescriptor();
        if (this.m_stepDelayPropDesc == null) {
            this.m_stepDelayPropDesc = new IntegerTextPropertyDescriptor(new StepDelayController(), P_STEPDELAY_DISPLAY_NAME, false, 0, 10000);
        }
        this.addPropertyDescriptor(this.m_stepDelayPropDesc);
        this.addPropertyDescriptor(this.getAUTPropDesc());
        this.addPropertyDescriptor(this.getEventHandlerDescriptors());
    }

    private List<IPropertyDescriptor> getEventHandlerDescriptors() {
        if (this.m_eventHandlerDescriptors.isEmpty()) {
            ITestSuitePO testSuitePO = (ITestSuitePO)this.getPoNode();
            this.m_reentryTypeList = new String[ReentryProperty.TS_REENTRY_PROP_ARRAY.length];
            int i = 0;
            while (i < ReentryProperty.TS_REENTRY_PROP_ARRAY.length) {
                this.m_reentryTypeList[i] = ReentryProperty.TS_REENTRY_PROP_ARRAY[i].toString();
                ++i;
            }
            for (String key : testSuitePO.getDefaultEventHandler().keySet()) {
                ComboBoxPropertyDescriptor cbpd = new ComboBoxPropertyDescriptor((Object)new EventHandlerController(), I18n.getString((String)key), this.m_reentryTypeList);
                cbpd.setCategory(P_EVENTHANDLER_CAT);
                this.m_eventHandlerDescriptors.add((IPropertyDescriptor)cbpd);
            }
        }
        return this.m_eventHandlerDescriptors;
    }

    private IPropertyDescriptor getAUTPropDesc() {
        if (this.m_autPropDesc == null) {
            ComboBoxPropertyDescriptor cbpd = new ComboBoxPropertyDescriptor((Object)new AUTController(), P_AUT_DISPLAY_NAME, this.m_autNameList);
            cbpd.setLabelProvider((ILabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof Integer) {
                        if (TestSuiteGUIPropertySource.this.m_autNameList.length == 0 || (Integer)element == -1) {
                            return "";
                        }
                        return TestSuiteGUIPropertySource.this.m_autNameList[(Integer)element];
                    }
                    Assert.notReached((String)(String.valueOf(Messages.WrongAUT) + "."));
                    return String.valueOf(element);
                }
            });
            this.m_autPropDesc = cbpd;
        }
        return this.m_autPropDesc;
    }

    private void initAUTList() {
        ArrayList<String> tmpList = new ArrayList<String>();
        ArrayList<IAUTMainPO> tmpSubList = new ArrayList<IAUTMainPO>();
        HashMap<String, IAUTMainPO> helpMap = new HashMap<String, IAUTMainPO>();
        int autListSize = this.m_project.getAutMainList().size();
        if (autListSize == 0) {
            return;
        }
        for (IAUTMainPO autW : this.m_project.getAutMainList()) {
            tmpList.add(autW.getName());
            helpMap.put(autW.getName(), autW);
        }
        this.m_autNameList = tmpList.toArray(new String[tmpList.size()]);
        Arrays.sort(this.m_autNameList);
        String[] stringArray = this.m_autNameList;
        int n = this.m_autNameList.length;
        int n2 = 0;
        while (n2 < n) {
            String autName = stringArray[n2];
            tmpSubList.add((IAUTMainPO)helpMap.get(autName));
            ++n2;
        }
        this.m_autSubList = tmpSubList.toArray(new IAUTMainPO[tmpSubList.size()]);
    }

    IPersistentObject getWorkVersion(IPersistentObject object) {
        AbstractJBEditor edit = Plugin.getDefault().getActiveGDEditor();
        EditSupport editSupport = edit.getEditorHelper().getEditSupport();
        IPersistentObject objectW = null;
        try {
            objectW = editSupport.createWorkVersion(object);
        }
        catch (PMException e) {
            PMExceptionHandler.handlePMExceptionForMasterSession(e);
        }
        return objectW;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AUTController
    extends AbstractPropertySource.AbstractPropertyController {
        private AUTController() {
        }

        @Override
        public boolean setProperty(Object value) {
            if (value == null) {
                return false;
            }
            ITestSuitePO testSuite = (ITestSuitePO)TestSuiteGUIPropertySource.this.getPoNode();
            IAUTMainPO aut = TestSuiteGUIPropertySource.this.m_autSubList[(Integer)value];
            IAUTMainPO autW = (IAUTMainPO)TestSuiteGUIPropertySource.this.getWorkVersion((IPersistentObject)aut);
            testSuite.setAut(autW);
            return true;
        }

        @Override
        public Object getProperty() {
            return this.getIndexOfAUTs();
        }

        @Override
        public Image getImage() {
            return DEFAULT_IMAGE;
        }

        private Integer getIndexOfAUTs() {
            ITestSuitePO testSuite = (ITestSuitePO)TestSuiteGUIPropertySource.this.getPoNode();
            IAUTMainPO aut = testSuite.getAut();
            int autListLength = TestSuiteGUIPropertySource.this.m_autSubList.length;
            int i = 0;
            while (i < autListLength) {
                if (TestSuiteGUIPropertySource.this.m_autSubList[i].equals(aut)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EventHandlerController
    extends AbstractPropertySource.AbstractPropertyController {
        private EventHandlerController() {
        }

        @Override
        public boolean setProperty(Object value) {
            IPropertyDescriptor propertyDescriptor;
            Integer reentryType;
            ITestSuitePO testSuite;
            block4: {
                if (value == null) {
                    return false;
                }
                testSuite = (ITestSuitePO)TestSuiteGUIPropertySource.this.getPoNode();
                try {
                    reentryType = ReentryProperty.getProperty((String)TestSuiteGUIPropertySource.this.m_reentryTypeList[(Integer)value]);
                    propertyDescriptor = TestSuiteGUIPropertySource.this.getPropertyDescriptorById(this);
                    if (propertyDescriptor != null) break block4;
                    return false;
                }
                catch (InvalidDataException invalidDataException) {}
            }
            String eventType = (String)StringHelper.getInstance().getMap().get(propertyDescriptor.getDisplayName());
            testSuite.getDefaultEventHandler().put(eventType, reentryType);
            return true;
        }

        @Override
        public Object getProperty() {
            return this.getIndexOfEHs();
        }

        private Integer getIndexOfEHs() {
            ITestSuitePO testSuite = (ITestSuitePO)TestSuiteGUIPropertySource.this.getPoNode();
            IPropertyDescriptor propertyDescriptor = TestSuiteGUIPropertySource.this.getPropertyDescriptorById(this);
            if (propertyDescriptor == null) {
                return -1;
            }
            String eventType = (String)StringHelper.getInstance().getMap().get(propertyDescriptor.getDisplayName());
            Integer reentryNumber = (Integer)testSuite.getDefaultEventHandler().get(eventType);
            try {
                String reentryType = ReentryProperty.getProperty((Integer)reentryNumber).toString();
                int reentryTypeListLength = TestSuiteGUIPropertySource.this.m_reentryTypeList.length;
                int i = 0;
                while (i < reentryTypeListLength) {
                    if (TestSuiteGUIPropertySource.this.m_reentryTypeList[i].equals(reentryType)) {
                        return i;
                    }
                    ++i;
                }
            }
            catch (InvalidDataException invalidDataException) {}
            return -1;
        }

        @Override
        public Image getImage() {
            return DEFAULT_IMAGE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StepDelayController
    extends AbstractPropertySource.AbstractPropertyController {
        private StepDelayController() {
        }

        @Override
        public boolean setProperty(Object value) {
            ITestSuitePO testSuite = (ITestSuitePO)TestSuiteGUIPropertySource.this.getPoNode();
            if (value == null || "".equals(value)) {
                testSuite.setStepDelay(-1);
            } else {
                try {
                    int stepDelay = Integer.parseInt(String.valueOf(value));
                    if (stepDelay >= 0) {
                        testSuite.setStepDelay(stepDelay);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public Object getProperty() {
            ITestSuitePO testSuite = (ITestSuitePO)TestSuiteGUIPropertySource.this.getPoNode();
            if (testSuite.getStepDelay() == -1) {
                return "";
            }
            return String.valueOf(testSuite.getStepDelay());
        }
    }
}

