/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.databinding.validators;

import java.util.HashSet;
import org.apache.commons.lang.Validate;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jubula.client.core.model.IAUTConfigPO;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.utils.NameValidationUtil;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.osgi.util.NLS;

public class AutIdValidator
implements IValidator {
    private IProjectPO m_project;
    private IAUTMainPO m_additionalAut;
    private IAUTConfigPO m_editedConfig;

    public AutIdValidator(IProjectPO project) {
        this(project, null);
    }

    public AutIdValidator(IProjectPO project, IAUTMainPO additionalAut) {
        this(project, additionalAut, null);
    }

    public AutIdValidator(IProjectPO project, IAUTMainPO additionalAut, IAUTConfigPO editedConfig) {
        Validate.notNull((Object)project);
        this.m_project = project;
        this.m_additionalAut = additionalAut;
        this.m_editedConfig = editedConfig;
    }

    public IStatus validate(Object value) {
        String stringValue = String.valueOf(value);
        if (stringValue.length() == 0) {
            return ValidationStatus.error((String)Messages.AutIdValidatorErrorEmptyString);
        }
        if (!stringValue.trim().equals(stringValue)) {
            return ValidationStatus.error((String)Messages.AutIdValidatorErrorTrimWhitespace);
        }
        if (!NameValidationUtil.containsNoIllegalChars((String)stringValue)) {
            return ValidationStatus.error((String)Messages.AutIdValidatorErrorIllegalChars);
        }
        HashSet<IAUTMainPO> validationContext = new HashSet<IAUTMainPO>();
        validationContext.addAll(this.m_project.getAutMainList());
        if (this.m_additionalAut != null) {
            validationContext.add(this.m_additionalAut);
        }
        for (IAUTMainPO aut : validationContext) {
            if (aut.getAutIds().contains(value)) {
                return ValidationStatus.error((String)NLS.bind((String)Messages.AutIdValidatorErrorAlreadyExistsInAut, (Object[])new String[]{stringValue, aut.getName()}));
            }
            for (IAUTConfigPO autConfig : aut.getAutConfigSet()) {
                if (autConfig.equals(this.m_editedConfig) || !autConfig.getValue("AUT_ID", "").equals(value)) continue;
                return ValidationStatus.error((String)NLS.bind((String)Messages.AutIdValidatorErrorAlreadyExistsInAutConfiguration, (Object[])new String[]{stringValue, autConfig.getName(), aut.getName()}));
            }
        }
        return ValidationStatus.ok();
    }
}

