/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.databinding.validators;

import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameMapper;
import org.eclipse.jubula.client.ui.i18n.Messages;

public class ComponentNameValidator
implements IValidator {
    private IComponentNameMapper m_compNamesMapper;
    private String m_oldName;

    public ComponentNameValidator(IComponentNameMapper compNamesMapper, String oldName) {
        this.m_compNamesMapper = compNamesMapper;
        this.m_oldName = oldName;
    }

    public IStatus validate(Object value) {
        String stringValue = value.toString();
        return this.isValidComponentName(stringValue);
    }

    public IStatus isValidComponentName(String stringValue) {
        IStatus is = ComponentNameValidator.isValidComponentNameString(stringValue);
        if (!is.isOK()) {
            return is;
        }
        if (this.m_compNamesMapper.getCompNameCache().getGuidForName(stringValue) == null || stringValue.equals(this.m_oldName)) {
            return ValidationStatus.ok();
        }
        return ValidationStatus.error((String)Messages.LogicalNameErrorExists);
    }

    public static IStatus isValidComponentNameString(String stringValue) {
        if (stringValue.trim().length() == 0) {
            return ValidationStatus.error((String)Messages.LogicalNameErrorEmpty);
        }
        if (stringValue.startsWith(" ") || stringValue.charAt(stringValue.length() - 1) == ' ') {
            return ValidationStatus.error((String)Messages.LogicalNameErrorNoSpaceAtStartOrEnd);
        }
        char[] cArray = stringValue.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (Character.isISOControl(ch)) {
                return ValidationStatus.error((String)Messages.LogicalNameErrorInvalidChar);
            }
            ++n2;
        }
        return ValidationStatus.ok();
    }
}

