/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.dialogs;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.constants.Layout;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.provider.ControlDecorator;
import org.eclipse.jubula.client.ui.widgets.DirectCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectDialog
extends TitleAreaDialog {
    private static Logger log = LoggerFactory.getLogger(TitleAreaDialog.class);
    private static final int NUM_COLUMNS_1 = 1;
    private static final int NUM_COLUMNS_4 = 4;
    private static final int VERTICAL_SPACING = 2;
    private static final int MARGIN_WIDTH = 10;
    private static final int MARGIN_HEIGHT = 10;
    private static final int WIDTH_HINT = 300;
    private static final int HORIZONTAL_SPAN = 3;
    private String m_message;
    private DirectCombo<String> m_nameComboBox;
    private DirectCombo<String> m_versionComboBox;
    private Map<String, List<String>> m_nameToVersionMap;
    private Map<ProjectData, IProjectPO> m_projectMap;
    private List<String> m_nameList;
    private List<String> m_versionList;
    private IProjectPO m_selection = null;
    private String m_label = Messages.OpenProjectActionLabel;
    private String m_label2 = Messages.OpenProjectActionLabel2;
    private String m_title;
    private Image m_image;
    private String m_shellTitle;
    private boolean m_isDeleteAction = false;
    private Button m_keepTestresultSummaryButton;
    private boolean m_keepTestresultSummary = false;

    public ProjectDialog(Shell parentShell, List<IProjectPO> projectList, String message, String title, Image image, String shellTitle, boolean isDeleteAction) {
        super(parentShell);
        this.m_nameToVersionMap = new HashMap<String, List<String>>();
        this.m_projectMap = new HashMap<ProjectData, IProjectPO>();
        this.m_nameList = new ArrayList<String>();
        this.m_versionList = new ArrayList<String>();
        for (IProjectPO proj : projectList) {
            String projName = proj.getName();
            String projVersion = proj.getVersionString();
            if (projName != null && projVersion != null) {
                if (!this.m_nameToVersionMap.containsKey(projName)) {
                    this.m_nameList.add(projName);
                    this.m_nameToVersionMap.put(projName, new ArrayList());
                }
                this.m_nameToVersionMap.get(projName).add(projVersion);
                this.m_projectMap.put(new ProjectData(projName, projVersion), proj);
                continue;
            }
            log.warn(String.valueOf(Messages.ProjectWithGUID) + " " + proj.getGuid() + " " + Messages.HasNoName + ".");
        }
        this.m_message = message;
        this.m_title = title;
        this.m_image = image;
        this.m_shellTitle = shellTitle;
        this.m_isDeleteAction = isDeleteAction;
    }

    protected Control createDialogArea(Composite parent) {
        this.setMessage(this.m_message);
        this.setTitle(this.m_title);
        this.setTitleImage(this.m_image);
        this.getShell().setText(this.m_shellTitle);
        GridLayout gridLayoutParent = new GridLayout();
        gridLayoutParent.numColumns = 1;
        gridLayoutParent.verticalSpacing = 2;
        gridLayoutParent.marginWidth = 10;
        gridLayoutParent.marginHeight = 10;
        parent.setLayout((org.eclipse.swt.widgets.Layout)gridLayoutParent);
        Plugin.createSeparator(parent);
        Composite area = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        area.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.widthHint = 300;
        area.setLayoutData((Object)gridData);
        this.createComboBoxes(area);
        if (this.m_isDeleteAction) {
            this.createDeleteTestresultsCheckbox(area);
        }
        Plugin.createSeparator(parent);
        return area;
    }

    private void createDeleteTestresultsCheckbox(Composite composite) {
        this.m_keepTestresultSummaryButton = new Button(composite, 32);
        this.m_keepTestresultSummaryButton.setText(Messages.DeleteProjectActionKeepTestresultSummaryCheckbox);
        this.m_keepTestresultSummaryButton.setSelection(false);
        GridData data = new GridData();
        data.horizontalSpan = 3;
        this.m_keepTestresultSummaryButton.setLayoutData((Object)data);
        ControlDecorator.decorateInfo((Control)this.m_keepTestresultSummaryButton, "GDControlDecorator.KeepTestresultSummary", false);
    }

    private void createComboBoxes(Composite parent) {
        new Label(parent, 0).setLayoutData((Object)new GridData(4, 2, false, false, 4, 1));
        new Label(parent, 0).setText(this.m_label);
        this.m_nameComboBox = new DirectCombo<String>(parent, 2060, this.m_nameList, this.m_nameList, false, true);
        GridData gridData = this.newGridData();
        Layout.addToolTipAndMaxWidth(gridData, this.m_nameComboBox);
        this.m_nameComboBox.setLayoutData(gridData);
        this.m_nameComboBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProjectDialog.this.m_versionList = (List)ProjectDialog.this.m_nameToVersionMap.get(ProjectDialog.this.m_nameComboBox.getSelectedObject());
                ProjectDialog.this.m_versionComboBox.setItems(ProjectDialog.this.m_versionList, ProjectDialog.this.m_versionList);
                ProjectDialog.this.m_versionComboBox.select(ProjectDialog.this.m_versionComboBox.getItemCount() - 1);
                ProjectDialog.this.enableOKButton();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (this.m_nameComboBox.getItemCount() > 0) {
            this.m_nameComboBox.select(0);
        }
        this.m_versionList = this.m_nameToVersionMap.get(this.m_nameComboBox.getSelectedObject());
        new Label(parent, 0).setLayoutData((Object)new GridData(4, 2, false, false, 4, 1));
        new Label(parent, 0).setText(this.m_label2);
        this.m_versionComboBox = new DirectCombo<String>(parent, 2060, this.m_versionList, this.m_versionList, false, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                Float f1 = Float.valueOf(Float.parseFloat(s1));
                Float f2 = Float.valueOf(Float.parseFloat(s2));
                return f1.compareTo(f2);
            }
        });
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.horizontalAlignment = 1;
        gridData.horizontalSpan = 3;
        this.m_versionComboBox.setLayoutData(gridData);
        this.m_versionComboBox.select(this.m_versionComboBox.getItemCount() - 1);
        this.m_versionComboBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProjectDialog.this.enableOKButton();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void enableOKButton() {
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(true);
        }
        this.setMessage(this.m_message);
    }

    protected void okPressed() {
        this.m_selection = this.m_projectMap.get(new ProjectData(this.m_nameComboBox.getSelectedObject(), this.m_versionComboBox.getSelectedObject()));
        if (this.m_isDeleteAction) {
            this.m_keepTestresultSummary = this.m_keepTestresultSummaryButton.getSelection();
        }
        this.setReturnCode(0);
        this.close();
    }

    private GridData newGridData() {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 3;
        return gridData;
    }

    public IProjectPO getSelection() {
        return this.m_selection;
    }

    public boolean keepTestresultSummary() {
        return this.m_keepTestresultSummary;
    }

    private class ProjectData {
        private String m_name;
        private String m_versionString;

        public ProjectData(String name, String versionString) {
            this.m_name = name;
            this.m_versionString = versionString;
        }

        private String getVersionString() {
            return this.m_versionString;
        }

        private String getName() {
            return this.m_name;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ProjectData)) {
                return false;
            }
            ProjectData otherData = (ProjectData)obj;
            return new EqualsBuilder().append((Object)this.getName(), (Object)otherData.getName()).append((Object)this.getVersionString(), (Object)otherData.getVersionString()).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.getName()).append((Object)this.getVersionString()).toHashCode();
        }
    }
}

