/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.editingsupport;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameMapper;
import org.eclipse.jubula.client.core.model.ICompIdentifierPO;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.ui.provider.contentprovider.objectmapping.ObjectMappingRow;
import org.eclipse.jubula.client.ui.widgets.CompNamePopupTextCellEditor;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractObjectMappingEditingSupport
extends EditingSupport {
    private Map<String, CompNamePopupTextCellEditor> m_editorMap;
    private IComponentNameMapper m_compNameMapper;

    public AbstractObjectMappingEditingSupport(IComponentNameMapper compNameMapper, TableViewer viewer) {
        super((ColumnViewer)viewer);
        this.m_compNameMapper = compNameMapper;
        this.m_editorMap = new HashMap<String, CompNamePopupTextCellEditor>();
    }

    protected boolean canEdit(Object element) {
        return true;
    }

    protected CellEditor getCellEditor(Object element) {
        ICompIdentifierPO compId;
        ObjectMappingRow row;
        IObjectMappingAssoziationPO assoc;
        if (element instanceof ObjectMappingRow && (assoc = (row = (ObjectMappingRow)element).getAssociation()) != null && (compId = assoc.getTechnicalName()) != null) {
            String typeFilter = compId.getSupportedClassName();
            CompNamePopupTextCellEditor editor = new CompNamePopupTextCellEditor(this.m_compNameMapper, (Composite)this.getViewer().getTable());
            editor.setFilter(typeFilter);
            this.m_editorMap.put(typeFilter, editor);
            return editor;
        }
        return null;
    }

    protected void setValue(Object element, Object value) {
        this.doSetValue(element, value);
        this.getViewer().update(element, null);
    }

    protected abstract void doSetValue(Object var1, Object var2);

    public TableViewer getViewer() {
        return (TableViewer)super.getViewer();
    }
}

