/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.factory;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jubula.client.core.businessprocess.UsedToolkitBP;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.widgets.DirectCombo;
import org.eclipse.jubula.toolkit.common.businessprocess.ToolkitSupportBP;
import org.eclipse.jubula.toolkit.common.exception.ToolkitPluginException;
import org.eclipse.jubula.toolkit.common.utils.ToolkitUtils;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.xml.businessmodell.CompSystem;
import org.eclipse.jubula.tools.xml.businessmodell.ToolkitPluginDescriptor;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlFactory {
    private ControlFactory() {
    }

    public static DirectCombo<String> createToolkitCombo(Composite parent) {
        List descriptors = ComponentBuilder.getInstance().getCompSystem().getIndependentToolkitPluginDescriptors(false);
        ArrayList<String> values = new ArrayList<String>();
        ArrayList<String> displayValues = new ArrayList<String>();
        for (ToolkitPluginDescriptor desc : descriptors) {
            values.add(desc.getToolkitID());
            displayValues.add(desc.getName());
        }
        return new DirectCombo<String>(parent, 8, values, displayValues, false, true);
    }

    public static DirectCombo<String> createAutToolkitCombo(Composite parent, IProjectPO project, String currentValue) throws ToolkitPluginException {
        List<ToolkitPluginDescriptor> toolkits = ControlFactory.getAutToolkits(project);
        ArrayList<String> values = new ArrayList<String>();
        ArrayList<String> displayValues = new ArrayList<String>();
        for (ToolkitPluginDescriptor desc : toolkits) {
            values.add(desc.getToolkitID());
            displayValues.add(desc.getName());
        }
        if (currentValue != null && currentValue.trim().length() != 0 && !values.contains(currentValue)) {
            values.add(currentValue);
            displayValues.add(currentValue);
        }
        return new DirectCombo<String>(parent, 8, values, displayValues, false, true);
    }

    public static DirectCombo<String> createProjectToolkitCombo(Composite parent) {
        IProjectPO project = GeneralStorage.getInstance().getProject();
        List toolkits = UsedToolkitBP.getInstance().getAllowedProjectToolkits(project);
        ArrayList<String> values = new ArrayList<String>();
        ArrayList<String> displayValues = new ArrayList<String>();
        for (ToolkitPluginDescriptor desc : toolkits) {
            values.add(desc.getToolkitID());
            displayValues.add(desc.getName());
        }
        String currentValue = project.getToolkit();
        if (currentValue != null && currentValue.trim().length() != 0 && !values.contains(currentValue)) {
            values.add(currentValue);
            String tkName = ToolkitUtils.getToolkitName((String)currentValue);
            displayValues.add(tkName);
        }
        return new DirectCombo<String>(parent, 0, values, displayValues, false, true);
    }

    public static DirectCombo<String> createAutToolkitCombo(Composite parent, IAUTMainPO aut) {
        ToolkitPluginDescriptor toolkit = ComponentBuilder.getInstance().getCompSystem().getToolkitPluginDescriptor(aut.getToolkit());
        ArrayList<String> values = new ArrayList<String>();
        ArrayList<String> displayValues = new ArrayList<String>();
        if (toolkit != null) {
            values.add(toolkit.getToolkitID());
            displayValues.add(toolkit.getName());
        } else {
            String autToolkitId = aut.getToolkit();
            if (autToolkitId != null && autToolkitId.trim().length() != 0) {
                values.add(autToolkitId);
                displayValues.add(autToolkitId);
            }
        }
        return new DirectCombo<String>(parent, 8, values, displayValues, false, true);
    }

    public static List<ToolkitPluginDescriptor> getAutToolkits(IProjectPO project) throws ToolkitPluginException {
        CompSystem compSys = ComponentBuilder.getInstance().getCompSystem();
        String projToolkit = project.getToolkit();
        if (projToolkit == null) {
            return compSys.getIndependentToolkitPluginDescriptors("toolkit");
        }
        String level = ToolkitSupportBP.getToolkitLevel((String)projToolkit);
        if ("toolkit".equals(level)) {
            ArrayList<ToolkitPluginDescriptor> toolkitList = new ArrayList<ToolkitPluginDescriptor>(1);
            toolkitList.add(compSys.getToolkitPluginDescriptor(projToolkit));
            for (Object descObj : compSys.getIndependentToolkitPluginDescriptors("toolkit")) {
                ToolkitPluginDescriptor desc = (ToolkitPluginDescriptor)descObj;
                if (!ToolkitUtils.doesToolkitInclude((String)desc.getToolkitID(), (String)projToolkit)) continue;
                toolkitList.add(desc);
            }
            return toolkitList;
        }
        return compSys.getIndependentToolkitPluginDescriptors("toolkit");
    }
}

