/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.handlers;

import java.util.Collection;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jubula.client.core.businessprocess.RunningAutBP;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.tools.registration.AutIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRunningAutHandler
extends AbstractHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRunningAutHandler.class);

    protected AutIdentifier getRunningAut(ExecutionEvent event, String parameterKey) {
        if (Job.getJobManager().find((Object)this).length > 0) {
            return null;
        }
        Object runningAutObj = null;
        try {
            runningAutObj = event.getObjectParameterForExecution(parameterKey);
        }
        catch (ExecutionException executionException) {
            LOG.info(Messages.MissingRunningAUTParameter);
        }
        if (runningAutObj == null) {
            Collection availableAUTs = RunningAutBP.getListOfDefinedRunningAuts();
            if (availableAUTs.size() == 1) {
                runningAutObj = availableAUTs.iterator().next();
            } else {
                LOG.info(Messages.UsingFallbackFailed);
                return null;
            }
        }
        if (!(runningAutObj instanceof AutIdentifier)) {
            LOG.error(String.valueOf(Messages.RunningAUTParameter) + " " + "'" + runningAutObj + "'" + " " + Messages.NotOfCorrectType + ".");
            return null;
        }
        return (AutIdentifier)runningAutObj;
    }
}

