/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.handlers;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ITestDataCubeContPO;
import org.eclipse.jubula.client.core.model.ITestDataCubePO;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.dialogs.NewTestDataManagerDialog;
import org.eclipse.jubula.client.ui.editors.CentralTestDataEditor;
import org.eclipse.jubula.client.ui.editors.JBEditorHelper;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddNewTestDataManagerHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart instanceof CentralTestDataEditor) {
            CentralTestDataEditor ctdEditor = (CentralTestDataEditor)activePart;
            if (ctdEditor.getEditorHelper().requestEditableState() != JBEditorHelper.EditableState.OK) {
                return null;
            }
            String newName = this.openDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), AddNewTestDataManagerHandler.getSetOfUsedNames(ctdEditor));
            if (newName != null) {
                this.performOperation(ctdEditor, newName);
            }
        }
        return null;
    }

    public static Set<String> getSetOfUsedNames(CentralTestDataEditor ctdEditor) {
        ITestDataCubeContPO po = (ITestDataCubeContPO)ctdEditor.getEditorHelper().getEditSupport().getWorkVersion();
        HashSet<String> usedNames = new HashSet<String>();
        for (IParameterInterfacePO cube : po.getTestDataCubeList()) {
            usedNames.add(cube.getName());
        }
        return usedNames;
    }

    protected String openDialog(Shell parentShell, Set<String> usedNames) {
        NewTestDataManagerDialog newNameDialog = new NewTestDataManagerDialog(parentShell, usedNames);
        newNameDialog.setHelpAvailable(true);
        newNameDialog.create();
        DialogUtils.setWidgetNameForModalDialog((Dialog)newNameDialog);
        Plugin.getHelpSystem().setHelp((Control)newNameDialog.getShell(), "org.eclipse.jubula.client.ua.help.newTestDataCubeNameContextId");
        if (newNameDialog.open() == 0) {
            return newNameDialog.getName();
        }
        return null;
    }

    private void performOperation(CentralTestDataEditor ctdEditor, String newName) {
        EditSupport es = ctdEditor.getEditorHelper().getEditSupport();
        ITestDataCubeContPO cont = (ITestDataCubeContPO)es.getWorkVersion();
        ITestDataCubePO testdata = PoMaker.createTestDataCubePO((String)newName);
        cont.addTestDataCube((IParameterInterfacePO)testdata);
        ctdEditor.getEditorHelper().setDirty(true);
        DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)cont, DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.onlyInEditor);
        DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)testdata, DataEventDispatcher.DataState.Added, DataEventDispatcher.UpdateState.onlyInEditor);
    }
}

