/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.handlers;

import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jubula.client.core.businessprocess.AbstractParamInterfaceBP;
import org.eclipse.jubula.client.core.businessprocess.TestCaseParamBP;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IModifiableParameterInterfacePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.dialogs.AbstractEditParametersDialog;
import org.eclipse.jubula.client.ui.dialogs.EditParametersDialog;
import org.eclipse.jubula.client.ui.editors.AbstractJBEditor;
import org.eclipse.jubula.client.ui.editors.JBEditorHelper;
import org.eclipse.jubula.client.ui.handlers.AbstractEditParametersHandler;
import org.eclipse.jubula.client.ui.utils.DialogUtils;

public class EditParametersHandler
extends AbstractEditParametersHandler {
    public Object execute(ExecutionEvent event) {
        AbstractJBEditor editor = this.getEditorInEditableState();
        if (editor != null) {
            JBEditorHelper.EditableState state = editor.getEditorHelper().getEditableState();
            ISpecTestCasePO workTC = (ISpecTestCasePO)editor.getEditorHelper().getEditSupport().getWorkVersion();
            EditParametersDialog dialog = new EditParametersDialog(Plugin.getShell(), workTC);
            dialog.create();
            DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                EditParametersHandler.performChanges(editor, state, workTC, dialog);
            } else if (state == JBEditorHelper.EditableState.NotChecked) {
                workTC.setIsReused(null);
                editor.getEditorHelper().resetEditableState();
            }
        }
        return null;
    }

    private static void performChanges(AbstractJBEditor editor, JBEditorHelper.EditableState state, ISpecTestCasePO workTC, EditParametersDialog dialog) {
        boolean isInterfaceLocked;
        List<AbstractEditParametersDialog.Parameter> parameters = dialog.getParameters();
        boolean isModified = EditParametersHandler.editParameters((IModifiableParameterInterfacePO)workTC, parameters, isInterfaceLocked = dialog.isInterfaceLocked(), editor.getEditorHelper().getEditSupport().getParamMapper(), (AbstractParamInterfaceBP)new TestCaseParamBP());
        if (isModified) {
            editor.getEditorHelper().setDirty(true);
            DataEventDispatcher.getInstance().fireParamChangedListener();
            DataEventDispatcher.getInstance().firePropertyChanged(false);
        } else if (state == JBEditorHelper.EditableState.NotChecked) {
            workTC.setIsReused(null);
            editor.getEditorHelper().resetEditableState();
        }
    }
}

