/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.handlers;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesDecorator;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameCache;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.ProjectComponentNameMapper;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.persistence.CompNamePM;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.IncompatibleTypeException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.ui.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.handlers.AbstractNewComponentNameHandler;
import org.eclipse.jubula.client.ui.utils.Utils;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;
import org.eclipse.ui.handlers.HandlerUtil;

public class NewComponentNameInViewHandler
extends AbstractNewComponentNameHandler {
    /*
     * Loose catch block
     */
    public Object execute(ExecutionEvent event) {
        EntityManager s = Persistor.instance().openSession();
        ProjectComponentNameMapper compNameMapper = new ProjectComponentNameMapper((IWritableComponentNameCache)new ComponentNamesDecorator(s), GeneralStorage.getInstance().getProject());
        String newName = this.openDialog((IComponentNameMapper)compNameMapper, HandlerUtil.getActiveShell((ExecutionEvent)event));
        try {
            try {
                if (newName != null) {
                    EntityTransaction tx = Persistor.instance().getTransaction(s);
                    IComponentNamePO newCompName = this.performOperation(newName, (IWritableComponentNameMapper)compNameMapper);
                    CompNamePM.flushCompNames((EntityManager)s, (Long)GeneralStorage.getInstance().getProject().getId(), (IWritableComponentNameMapper)compNameMapper);
                    Persistor.instance().commitTransaction(s, tx);
                    compNameMapper.getCompNameCache().updateStandardMapperAndCleanup(GeneralStorage.getInstance().getProject().getId());
                    DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)newCompName, DataEventDispatcher.DataState.Added, DataEventDispatcher.UpdateState.all);
                }
            }
            catch (IncompatibleTypeException e) {
                Utils.createMessageDialog((JBException)((Object)e), (Object[])e.getErrorMessageParams(), null);
                Persistor.instance().dropSession(s);
            }
            catch (PMException e) {
                PMExceptionHandler.handlePMExceptionForMasterSession(e);
                Persistor.instance().dropSession(s);
            }
            catch (ProjectDeletedException projectDeletedException) {
                PMExceptionHandler.handleGDProjectDeletedException();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                Persistor.instance().dropSession(s);
            }
        }
        finally {
            Persistor.instance().dropSession(s);
        }
        return null;
    }
}

