/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.dialogs.InputDialog;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;
import org.eclipse.swt.widgets.Control;

public class NewTestSuiteHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent arg0) {
        this.newTestSuite();
        return null;
    }

    public void newTestSuite() {
        InputDialog dialog = this.newTestSuitePopUp();
        if (dialog.getReturnCode() == 1) {
            return;
        }
        IProjectPO project = GeneralStorage.getInstance().getProject();
        try {
            ITestSuitePO testSuite = NodeMaker.createTestSuitePO((String)dialog.getName());
            this.setDefaultValuesToTestSuite(testSuite, project);
            NodePM.AbstractCmdHandleChild cmd = NodePM.getCmdHandleChild((INodePO)project, (INodePO)testSuite);
            NodePM.addAndPersistChildNode((INodePO)project, (INodePO)testSuite, null, (NodePM.AbstractCmdHandleChild)cmd);
            DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)testSuite, DataEventDispatcher.DataState.Added, DataEventDispatcher.UpdateState.all);
        }
        catch (PMException e) {
            PMExceptionHandler.handlePMExceptionForMasterSession(e);
        }
        catch (ProjectDeletedException projectDeletedException) {
            PMExceptionHandler.handleGDProjectDeletedException();
        }
    }

    private void setDefaultValuesToTestSuite(ITestSuitePO testSuite, IProjectPO project) {
        int autListSize = project.getAutMainList().size();
        if (autListSize == 0 || autListSize > 1) {
            return;
        }
        IAUTMainPO aut = (IAUTMainPO)project.getAutMainList().toArray()[0];
        testSuite.setAut(aut);
        int autConfigListLength = aut.getAutConfigSet().size();
        if (autConfigListLength == 0 || autConfigListLength > 1) {
            return;
        }
    }

    private InputDialog newTestSuitePopUp() {
        final IProjectPO project = GeneralStorage.getInstance().getProject();
        int testSuiteCount = project.getTestSuiteCont().getTestSuiteList().size();
        String str = "";
        if (testSuiteCount > 0) {
            str = String.valueOf(str) + testSuiteCount;
        }
        str = "New Test Suite" + str;
        InputDialog dialog = new InputDialog(Plugin.getShell(), Messages.NewTestSuiteActionTSTitle, str, Messages.NewTestSuiteActionTSMessage, Messages.NewTestSuiteActionTSLabel, Messages.NewTestSuiteActionTSError, Messages.NewTestSuiteActionDoubleTSName, "newTestSuiteDialog.gif", Messages.NewTestSuiteActionTSShell, false){

            protected boolean isInputAllowed() {
                String newName = this.getInputFieldText();
                return !ProjectPM.doesTestSuiteExists((Long)project.getId(), (String)newName);
            }
        };
        dialog.setHelpAvailable(true);
        dialog.create();
        DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
        Plugin.getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.jubula.client.ua.help.dialogTestsuiteNewContextId");
        dialog.open();
        return dialog;
    }
}

