/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameMapper;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.ui.editors.JBEditorHelper;
import org.eclipse.jubula.client.ui.editors.ObjectMappingMultiPageEditor;
import org.eclipse.jubula.client.ui.handlers.rename.AbstractRenameComponentNameHandler;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class RenameLogicalNameHandler
extends AbstractRenameComponentNameHandler {
    public Object execute(ExecutionEvent event) {
        IEditorPart activeEditor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (activeEditor instanceof ObjectMappingMultiPageEditor) {
            String newName;
            ObjectMappingMultiPageEditor omEditor = (ObjectMappingMultiPageEditor)activeEditor;
            IWritableComponentNameMapper compNamesMapper = omEditor.getEditorHelper().getEditSupport().getCompMapper();
            IComponentNamePO compName = this.getSelectedComponentName(event);
            if (compName != null && (newName = this.getNewName(event, (IComponentNameMapper)compNamesMapper, compName)) != null && omEditor.getEditorHelper().requestEditableState() == JBEditorHelper.EditableState.OK) {
                this.rename(omEditor.getEditorHelper().getEditSupport().getCompMapper(), compName.getGuid(), newName);
                omEditor.getEditorHelper().setDirty(true);
                DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)compName, DataEventDispatcher.DataState.Renamed, DataEventDispatcher.UpdateState.onlyInEditor);
                ISelectionProvider selectionProvider = activeEditor.getSite().getSelectionProvider();
                if (selectionProvider != null) {
                    ISelection currentSelection = selectionProvider.getSelection();
                    selectionProvider.setSelection((ISelection)StructuredSelection.EMPTY);
                    selectionProvider.setSelection(currentSelection);
                }
            }
        }
        return null;
    }
}

