/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.handlers.delete;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ITestJobPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.MultipleNodePM;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.persistence.PMAlreadyLockedException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PMSaveException;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.editors.ObjectMappingMultiPageEditor;
import org.eclipse.jubula.client.ui.editors.TestJobEditor;
import org.eclipse.jubula.client.ui.editors.TestSuiteEditor;
import org.eclipse.jubula.client.ui.handlers.delete.AbstractDeleteTreeItemHandler;
import org.eclipse.jubula.client.ui.utils.Utils;
import org.eclipse.jubula.client.ui.views.TestSuiteBrowser;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class DeleteTreeItemHandlerTSBrowser
extends AbstractDeleteTreeItemHandler {
    public Object execute(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (activePart instanceof TestSuiteBrowser && currentSelection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)currentSelection;
            try {
                if (this.confirmDelete(structuredSelection)) {
                    this.deleteExecItems(structuredSelection);
                }
            }
            catch (PMException e) {
                PMExceptionHandler.handlePMExceptionForMasterSession(e);
            }
            catch (ProjectDeletedException projectDeletedException) {
                PMExceptionHandler.handleGDProjectDeletedException();
            }
        }
        return null;
    }

    private void deleteExecItems(IStructuredSelection selection) throws PMSaveException, PMAlreadyLockedException, PMException, ProjectDeletedException {
        IEditorReference[] editors = Plugin.getActivePage().getEditorReferences();
        Iterator iter = selection.iterator();
        IProjectPO project = GeneralStorage.getInstance().getProject();
        ArrayList<MultipleNodePM.DeleteTJHandle> cmds = new ArrayList<MultipleNodePM.DeleteTJHandle>();
        ArrayList<Object> tsbList = new ArrayList<Object>();
        if (selection.getFirstElement() instanceof ITestSuitePO || selection.getFirstElement() instanceof ITestJobPO) {
            while (iter.hasNext()) {
                INodePO iNodePO = (INodePO)iter.next();
                MultipleNodePM.DeleteTJHandle cmd = null;
                if (iNodePO instanceof ITestSuitePO) {
                    ITestSuitePO testSuite = (ITestSuitePO)iNodePO;
                    List refTs = NodePM.getInternalRefTestSuites((String)testSuite.getGuid(), (long)testSuite.getParentProjectId());
                    if (refTs.size() > 0) {
                        Utils.createMessageDialog(MessageIDs.I_REUSED_TS);
                        return;
                    }
                    this.closeEditors(project, testSuite, editors);
                    tsbList.add(testSuite);
                    cmd = new MultipleNodePM.DeleteTSHandle(testSuite);
                } else if (iNodePO instanceof ITestJobPO) {
                    ITestJobPO testjob = (ITestJobPO)iNodePO;
                    this.closeEditors(testjob, editors);
                    tsbList.add(testjob);
                    cmd = new MultipleNodePM.DeleteTJHandle(testjob);
                }
                cmds.add(cmd);
            }
        }
        MultipleNodePM.getInstance().executeCommands(cmds);
        for (INodePO iNodePO : tsbList) {
            DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)iNodePO, DataEventDispatcher.DataState.Deleted, DataEventDispatcher.UpdateState.all);
        }
    }

    private void closeEditors(ITestJobPO testjob, IEditorReference[] editors) {
        IEditorReference[] iEditorReferenceArray = editors;
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            TestJobEditor tjEditor;
            IEditorReference editor = iEditorReferenceArray[n2];
            if (editor.getPart(true) instanceof TestJobEditor && (tjEditor = (TestJobEditor)editor.getPart(true)).getEditorInput().getName().endsWith(testjob.getName())) {
                tjEditor.getEditorSite().getPage().closeEditor((IEditorPart)tjEditor, true);
            }
            ++n2;
        }
    }

    private void closeEditors(IProjectPO project, ITestSuitePO execTS, IEditorReference[] editors) {
        IEditorReference[] iEditorReferenceArray = editors;
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            TestSuiteEditor tsEditor;
            IEditorReference editor = iEditorReferenceArray[n2];
            if (editor.getPart(true) instanceof TestSuiteEditor && (tsEditor = (TestSuiteEditor)editor.getPart(true)).getEditorInput().getName().endsWith(execTS.getName())) {
                tsEditor.getEditorSite().getPage().closeEditor((IEditorPart)tsEditor, true);
            }
            if (editor.getPart(true) instanceof ObjectMappingMultiPageEditor) {
                int autCounter = 0;
                ObjectMappingMultiPageEditor omEditor = (ObjectMappingMultiPageEditor)editor.getPart(true);
                IAUTMainPO omAut = omEditor.getAut();
                List tsList = project.getTestSuiteCont().getTestSuiteList();
                for (ITestSuitePO ts : tsList) {
                    if (ts.getAut() == null || !ts.getAut().equals(omAut)) continue;
                    ++autCounter;
                }
                if (execTS.getAut() != null && execTS.getAut().equals(omAut)) {
                    --autCounter;
                }
                if (autCounter == 0) {
                    omEditor.getEditorSite().getPage().closeEditor((IEditorPart)omEditor, true);
                }
            }
            ++n2;
        }
    }
}

