/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.handlers.filter.testcases;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.persistence.NodePM;

public class FilterUsedTestCases
extends ViewerFilter {
    private Map<INodePO, Boolean> m_alreadyVisited = new HashMap<INodePO, Boolean>();

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof ISpecTestCasePO) {
            ISpecTestCasePO tc = (ISpecTestCasePO)element;
            if (!this.m_alreadyVisited.containsKey(tc)) {
                List execTestCases = NodePM.getInternalExecTestCases((String)tc.getGuid(), (long)tc.getParentProjectId());
                if (execTestCases.isEmpty()) {
                    this.m_alreadyVisited.put((INodePO)tc, Boolean.TRUE);
                    return true;
                }
            } else {
                return this.m_alreadyVisited.get(tc);
            }
            return false;
        }
        if (element instanceof ICategoryPO) {
            ICategoryPO cat = (ICategoryPO)element;
            for (INodePO child : cat.getUnmodifiableNodeList()) {
                if (!this.m_alreadyVisited.containsKey(child)) {
                    if (!this.select(viewer, parentElement, child)) continue;
                    this.m_alreadyVisited.put(child, Boolean.TRUE);
                    return true;
                }
                return this.m_alreadyVisited.get(child);
            }
            return false;
        }
        return true;
    }

    public void resetCache() {
        this.m_alreadyVisited.clear();
    }
}

