/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.handlers.newcap;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.businessprocess.CapBP;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameMapper;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.persistence.IncompatibleTypeException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.dialogs.NewCAPDialog;
import org.eclipse.jubula.client.ui.editors.AbstractTestCaseEditor;
import org.eclipse.jubula.client.ui.editors.JBEditorHelper;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.client.ui.utils.Utils;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.ui.IWorkbenchPart;

public class NewCAP
extends AbstractHandler {
    public Object execute(ExecutionEvent event) {
        AbstractTestCaseEditor tse;
        IWorkbenchPart activePart = Plugin.getActivePart();
        if (activePart instanceof AbstractTestCaseEditor && (tse = (AbstractTestCaseEditor)activePart).getEditorHelper().requestEditableState() == JBEditorHelper.EditableState.OK) {
            ISpecTestCasePO workTC = (ISpecTestCasePO)tse.getEditorHelper().getEditSupport().getWorkVersion();
            if (!(tse.getTreeViewer().getSelection() instanceof IStructuredSelection)) {
                return null;
            }
            IStructuredSelection selection = (IStructuredSelection)tse.getTreeViewer().getSelection();
            INodePO selectedNodeGUI = (INodePO)selection.getFirstElement();
            if (selectedNodeGUI != null) {
                ISpecTestCasePO specTcGUI = null;
                int posistionToAdd = workTC.indexOf(selectedNodeGUI);
                while (!(selectedNodeGUI instanceof ISpecTestCasePO)) {
                    selectedNodeGUI = selectedNodeGUI.getParentNode();
                }
                specTcGUI = (ISpecTestCasePO)selectedNodeGUI;
                this.addCap(specTcGUI, workTC, posistionToAdd, tse);
            }
        }
        return null;
    }

    private void addCap(ISpecTestCasePO specTcGUI, ISpecTestCasePO workTC, Integer position, AbstractTestCaseEditor tse) {
        NewCAPDialog dialog = new NewCAPDialog(Plugin.getShell(), specTcGUI, (IComponentNameMapper)tse.getEditorHelper().getEditSupport().getCompMapper());
        dialog.create();
        DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
        dialog.open();
        if (dialog.getReturnCode() != 0) {
            return;
        }
        String componentType = dialog.getComponentType();
        String capName = dialog.getCapName();
        String action = dialog.getActionName();
        String componentName = dialog.getComponentName();
        ICapPO cap = CapBP.createCapWithDefaultParams((String)capName, (String)componentName, (String)componentType, (String)action);
        IWritableComponentNameMapper compMapper = tse.getEditorHelper().getEditSupport().getCompMapper();
        try {
            cap.setComponentName(null);
            ComponentNamesBP.getInstance().setCompName(cap, componentName, ComponentNamesBP.CompNameCreationContext.STEP, compMapper);
            workTC.addNode(position.intValue(), (INodePO)cap);
            tse.getEditorHelper().setDirty(true);
            DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)cap, DataEventDispatcher.DataState.Added, DataEventDispatcher.UpdateState.onlyInEditor);
        }
        catch (IncompatibleTypeException e) {
            Utils.createMessageDialog((JBException)((Object)e), (Object[])e.getErrorMessageParams(), null);
        }
        catch (PMException pme) {
            PMExceptionHandler.handlePMExceptionForEditor(pme, tse);
        }
    }
}

