/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.handlers.rename;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameMapper;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.dialogs.RenameLogicalCompNameDialog;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractRenameComponentNameHandler
extends AbstractHandler {
    protected final IComponentNamePO getSelectedComponentName(ExecutionEvent event) {
        IStructuredSelection structuredSelection;
        Object selectedObject;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && (selectedObject = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof IComponentNamePO) {
            return (IComponentNamePO)selectedObject;
        }
        return null;
    }

    protected final String getNewName(ExecutionEvent event, IComponentNameMapper compNamesMapper, IComponentNamePO compName) {
        String originalName = compName.getName();
        RenameLogicalCompNameDialog dialog = new RenameLogicalCompNameDialog(compNamesMapper, HandlerUtil.getActiveShell((ExecutionEvent)event), originalName);
        dialog.setHelpAvailable(true);
        dialog.create();
        DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
        Plugin.getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.jubula.client.ua.help.renameComponentNameContextId");
        int result = dialog.open();
        if (result != 0) {
            return null;
        }
        String newName = dialog.getName();
        return newName;
    }

    protected final void rename(IWritableComponentNameMapper compNameMapper, String guid, String newName) {
        compNameMapper.getCompNameCache().renameComponentName(guid, newName);
    }
}

